/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base.sensors;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.TagLostException;
import android.nfc.tech.Ndef;
import android.nfc.tech.NdefFormatable;
import android.os.Handler;
import android.util.Log;
import com.google.vr.sdk.base.GvrViewerParams;
import com.google.vr.sdk.base.PermissionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class NfcSensor {
    private static final String TAG = "NfcSensor";
    private static final int MAX_CONNECTION_FAILURES = 1;
    private static final long NFC_POLLING_INTERVAL_MS = 250L;
    private static NfcSensor sInstance;
    private final Context context;
    private final NfcAdapter nfcAdapter;
    private final Object tagLock;
    private final List<ListenerHelper> listeners;
    private BroadcastReceiver nfcBroadcastReceiver;
    private IntentFilter[] nfcIntentFilters;
    private Ndef currentNdef;
    private Tag currentTag;
    private boolean currentTagIsCardboard;
    private Timer nfcDisconnectTimer;
    private int tagConnectionFailures;

    public static NfcSensor getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new NfcSensor(context);
        }
        return sInstance;
    }

    private NfcSensor(Context context) {
        this.context = context.getApplicationContext();
        this.listeners = new ArrayList<ListenerHelper>();
        this.tagLock = new Object();
        this.nfcAdapter = PermissionUtils.hasPermission(context, "android.permission.NFC") ? NfcAdapter.getDefaultAdapter((Context)context) : null;
        if (this.nfcAdapter == null) {
            Log.w((String)TAG, (String)"NFC is not supported on this phone or application doesn't have NFC permission.");
            return;
        }
        this.nfcBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                NfcSensor.this.onNfcIntent(intent);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnCardboardNfcListener(OnCardboardNfcListener listener) {
        if (listener == null) {
            return;
        }
        List<ListenerHelper> list = this.listeners;
        synchronized (list) {
            if (this.listeners.isEmpty()) {
                IntentFilter ndefIntentFilter = new IntentFilter("android.nfc.action.NDEF_DISCOVERED");
                ndefIntentFilter.addAction("android.nfc.action.TECH_DISCOVERED");
                ndefIntentFilter.addAction("android.nfc.action.TAG_DISCOVERED");
                this.nfcIntentFilters = new IntentFilter[]{ndefIntentFilter};
                this.context.registerReceiver(this.nfcBroadcastReceiver, ndefIntentFilter);
            }
            for (ListenerHelper helper : this.listeners) {
                if (helper.getListener() != listener) continue;
                return;
            }
            this.listeners.add(new ListenerHelper(listener, new Handler()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnCardboardNfcListener(OnCardboardNfcListener listener) {
        if (listener == null) {
            return;
        }
        List<ListenerHelper> list = this.listeners;
        synchronized (list) {
            for (ListenerHelper helper : this.listeners) {
                if (helper.getListener() != listener) continue;
                this.listeners.remove(helper);
                break;
            }
            if (this.nfcBroadcastReceiver != null && this.listeners.isEmpty()) {
                this.context.unregisterReceiver(this.nfcBroadcastReceiver);
            }
        }
    }

    public boolean isNfcSupported() {
        return this.nfcAdapter != null;
    }

    public boolean isNfcEnabled() {
        return this.isNfcSupported() && this.nfcAdapter.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeviceInCardboard() {
        Object object = this.tagLock;
        synchronized (object) {
            return this.currentTagIsCardboard;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdefMessage getTagContents() {
        Object object = this.tagLock;
        synchronized (object) {
            return this.currentNdef != null ? this.currentNdef.getCachedNdefMessage() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdefMessage getCurrentTagContents() throws TagLostException, IOException, FormatException {
        Object object = this.tagLock;
        synchronized (object) {
            return this.currentNdef != null ? this.currentNdef.getNdefMessage() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTagCapacity() {
        Object object = this.tagLock;
        synchronized (object) {
            if (this.currentNdef == null) {
                throw new IllegalStateException("No NFC tag");
            }
            return this.currentNdef.getMaxSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUri(Uri uri) throws TagLostException, IOException, IllegalArgumentException {
        Object object = this.tagLock;
        synchronized (object) {
            int recordFound;
            if (this.currentTag == null) {
                throw new IllegalStateException("No NFC tag found");
            }
            NdefMessage currentMessage = null;
            NdefMessage newMessage = null;
            NdefRecord newRecord = NdefRecord.createUri((Uri)uri);
            try {
                currentMessage = this.getCurrentTagContents();
            }
            catch (Exception e) {
                currentMessage = this.getTagContents();
            }
            if (currentMessage != null) {
                ArrayList<NdefRecord> newRecords = new ArrayList<NdefRecord>();
                recordFound = 0;
                for (NdefRecord record : currentMessage.getRecords()) {
                    if (this.isCardboardNdefRecord(record)) {
                        if (recordFound != 0) continue;
                        newRecords.add(newRecord);
                        recordFound = 1;
                        continue;
                    }
                    newRecords.add(record);
                }
                newMessage = new NdefMessage(newRecords.toArray(new NdefRecord[newRecords.size()]));
            }
            if (newMessage == null) {
                newMessage = new NdefMessage(new NdefRecord[]{newRecord});
            }
            if (this.currentNdef != null) {
                if (!this.currentNdef.isConnected()) {
                    this.currentNdef.connect();
                }
                if (this.currentNdef.getMaxSize() < newMessage.getByteArrayLength()) {
                    int newRecords = this.currentNdef.getMaxSize();
                    recordFound = newMessage.getByteArrayLength();
                    throw new IllegalArgumentException(new StringBuilder(82).append("Not enough capacity in NFC tag. Capacity: ").append(newRecords).append(" bytes, ").append(recordFound).append(" required.").toString());
                }
                try {
                    this.currentNdef.writeNdefMessage(newMessage);
                }
                catch (FormatException e) {
                    String string = String.valueOf(e.toString());
                    throw new RuntimeException(string.length() != 0 ? "Internal error when writing to NFC tag: ".concat(string) : new String("Internal error when writing to NFC tag: "));
                }
            }
            NdefFormatable ndef = NdefFormatable.get((Tag)this.currentTag);
            if (ndef == null) {
                throw new IOException("Could not find a writable technology for the NFC tag");
            }
            Log.w((String)TAG, (String)"Ndef technology not available. Falling back to NdefFormattable.");
            try {
                ndef.connect();
                ndef.format(newMessage);
                ndef.close();
            }
            catch (FormatException e) {
                String string = String.valueOf(e.toString());
                throw new RuntimeException(string.length() != 0 ? "Internal error when writing to NFC tag: ".concat(string) : new String("Internal error when writing to NFC tag: "));
            }
            this.onNewNfcTag(this.currentTag);
        }
    }

    public void onResume(Activity activity) {
        if (!this.isNfcEnabled()) {
            return;
        }
        Intent intent = new Intent("android.nfc.action.NDEF_DISCOVERED");
        intent.setPackage(activity.getPackageName());
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)intent, (int)0);
        this.nfcAdapter.enableForegroundDispatch(activity, pendingIntent, this.nfcIntentFilters, null);
    }

    public void onPause(Activity activity) {
        if (!this.isNfcEnabled()) {
            return;
        }
        this.nfcAdapter.disableForegroundDispatch(activity);
    }

    public void onNfcIntent(Intent intent) {
        if (!this.isNfcEnabled() || intent == null || !this.nfcIntentFilters[0].matchAction(intent.getAction())) {
            return;
        }
        this.onNewNfcTag((Tag)intent.getParcelableExtra("android.nfc.extra.TAG"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNewNfcTag(Tag nfcTag) {
        if (nfcTag == null) {
            return;
        }
        Object object = this.tagLock;
        synchronized (object) {
            NdefMessage nfcTagContents;
            Tag previousTag = this.currentTag;
            Ndef previousNdef = this.currentNdef;
            boolean previousTagWasCardboard = this.currentTagIsCardboard;
            this.closeCurrentNfcTag();
            this.currentTag = nfcTag;
            this.currentNdef = Ndef.get((Tag)nfcTag);
            if (this.currentNdef == null) {
                if (previousTagWasCardboard) {
                    this.sendDisconnectionEvent();
                }
                return;
            }
            boolean isSameTag = false;
            if (previousNdef != null) {
                byte[] tagId1 = this.currentTag.getId();
                byte[] tagId2 = previousTag.getId();
                boolean bl = isSameTag = tagId1 != null && tagId2 != null && Arrays.equals(tagId1, tagId2);
                if (!isSameTag && previousTagWasCardboard) {
                    this.sendDisconnectionEvent();
                }
            }
            try {
                this.currentNdef.connect();
                nfcTagContents = this.currentNdef.getCachedNdefMessage();
            }
            catch (Exception e) {
                String string = String.valueOf(e.toString());
                Log.e((String)TAG, (String)(string.length() != 0 ? "Error reading NFC tag: ".concat(string) : new String("Error reading NFC tag: ")));
                if (isSameTag && previousTagWasCardboard) {
                    this.sendDisconnectionEvent();
                }
                return;
            }
            this.currentTagIsCardboard = this.isCardboardNdefMessage(nfcTagContents);
            if (!isSameTag && this.currentTagIsCardboard) {
                List<ListenerHelper> list = this.listeners;
                synchronized (list) {
                    for (ListenerHelper listener : this.listeners) {
                        listener.onInsertedIntoGvrViewer(GvrViewerParams.createFromNfcContents(nfcTagContents));
                    }
                }
            }
            if (this.currentTagIsCardboard) {
                this.tagConnectionFailures = 0;
                this.nfcDisconnectTimer = new Timer("NFC disconnect timer");
                this.nfcDisconnectTimer.schedule(new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = NfcSensor.this.tagLock;
                        synchronized (object) {
                            if (!NfcSensor.this.currentNdef.isConnected()) {
                                ++NfcSensor.this.tagConnectionFailures;
                                if (NfcSensor.this.tagConnectionFailures > 1) {
                                    NfcSensor.this.closeCurrentNfcTag();
                                    NfcSensor.this.sendDisconnectionEvent();
                                }
                            }
                        }
                    }
                }, 250L, 250L);
            }
        }
    }

    private void closeCurrentNfcTag() {
        if (this.nfcDisconnectTimer != null) {
            this.nfcDisconnectTimer.cancel();
        }
        if (this.currentNdef == null) {
            return;
        }
        try {
            this.currentNdef.close();
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)e.toString());
        }
        this.currentTag = null;
        this.currentNdef = null;
        this.currentTagIsCardboard = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDisconnectionEvent() {
        List<ListenerHelper> list = this.listeners;
        synchronized (list) {
            for (ListenerHelper listener : this.listeners) {
                listener.onRemovedFromGvrViewer();
            }
        }
    }

    private boolean isCardboardNdefMessage(NdefMessage message) {
        if (message == null) {
            return false;
        }
        for (NdefRecord record : message.getRecords()) {
            if (!this.isCardboardNdefRecord(record)) continue;
            return true;
        }
        return false;
    }

    private boolean isCardboardNdefRecord(NdefRecord record) {
        if (record == null) {
            return false;
        }
        Uri uri = record.toUri();
        return uri != null && GvrViewerParams.isGvrUri(uri);
    }

    private static class ListenerHelper
    implements OnCardboardNfcListener {
        private OnCardboardNfcListener listener;
        private Handler handler;

        public ListenerHelper(OnCardboardNfcListener listener, Handler handler) {
            this.listener = listener;
            this.handler = handler;
        }

        public OnCardboardNfcListener getListener() {
            return this.listener;
        }

        @Override
        public void onInsertedIntoGvrViewer(final GvrViewerParams viewerParams) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    ListenerHelper.this.listener.onInsertedIntoGvrViewer(viewerParams);
                }
            });
        }

        @Override
        public void onRemovedFromGvrViewer() {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    ListenerHelper.this.listener.onRemovedFromGvrViewer();
                }
            });
        }
    }

    public static interface OnCardboardNfcListener {
        public void onInsertedIntoGvrViewer(GvrViewerParams var1);

        public void onRemovedFromGvrViewer();
    }
}

