/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.base;

import android.content.Context;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.google.vr.cardboard.VrParamsProvider;
import com.google.vr.cardboard.VrParamsProviderFactory;
import com.google.vr.sdk.base.GvrViewerParams;
import com.google.vr.sdk.base.HeadMountedDisplay;
import com.google.vr.sdk.base.ScreenParams;
import com.google.vrtoolkit.cardboard.proto.nano.CardboardDevice;
import com.google.vrtoolkit.cardboard.proto.nano.Phone;

public class HeadMountedDisplayManager {
    private static final String TAG = "HeadMountedDisplayManager";
    private final HeadMountedDisplay hmd;
    private final Context context;
    private final VrParamsProvider paramsProvider;

    public HeadMountedDisplayManager(Context context) {
        this.context = context;
        this.paramsProvider = VrParamsProviderFactory.create((Context)context);
        this.hmd = new HeadMountedDisplay(this.createScreenParams(), this.createGvrViewerParams());
    }

    public HeadMountedDisplay getHeadMountedDisplay() {
        return this.hmd;
    }

    public void onResume() {
        Phone.PhoneParams phoneProto;
        ScreenParams screenParams;
        GvrViewerParams deviceParams;
        CardboardDevice.DeviceParams deviceProto = this.paramsProvider.readDeviceParams();
        GvrViewerParams gvrViewerParams = deviceParams = deviceProto != null ? new GvrViewerParams(deviceProto) : null;
        if (deviceParams != null && !deviceParams.equals(this.hmd.getGvrViewerParams())) {
            this.hmd.setGvrViewerParams(deviceParams);
            Log.i((String)TAG, (String)"Successfully read updated device params from external storage");
        }
        ScreenParams screenParams2 = screenParams = (phoneProto = this.paramsProvider.readPhoneParams()) != null ? ScreenParams.fromProto(this.getDisplay(), phoneProto) : null;
        if (screenParams != null && !screenParams.equals(this.hmd.getScreenParams())) {
            this.hmd.setScreenParams(screenParams);
            Log.i((String)TAG, (String)"Successfully read updated screen params from external storage");
        }
    }

    public void onPause() {
    }

    public boolean updateGvrViewerParams(GvrViewerParams gvrViewerParams) {
        if (gvrViewerParams == null || gvrViewerParams.equals(this.hmd.getGvrViewerParams())) {
            return false;
        }
        this.hmd.setGvrViewerParams(gvrViewerParams);
        this.paramsProvider.writeDeviceParams(gvrViewerParams.toProtobuf());
        return true;
    }

    public boolean updateScreenParams(ScreenParams screenParams) {
        if (screenParams == null || screenParams.equals(this.hmd.getScreenParams())) {
            return false;
        }
        this.hmd.setScreenParams(screenParams);
        return true;
    }

    private Display getDisplay() {
        WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
        return windowManager.getDefaultDisplay();
    }

    private ScreenParams createScreenParams() {
        Display display = this.getDisplay();
        ScreenParams params = ScreenParams.fromProto(display, this.paramsProvider.readPhoneParams());
        return params != null ? params : new ScreenParams(display);
    }

    private GvrViewerParams createGvrViewerParams() {
        return new GvrViewerParams(this.paramsProvider.readDeviceParams());
    }
}

