/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.parser;

import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.datatable.value.DateTimeValue;
import com.google.visualization.datasource.datatable.value.DateValue;
import com.google.visualization.datasource.datatable.value.TimeOfDayValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class ParserUtils {
    private static final Log log = LogFactory.getLog((String)ParserUtils.class.getName());
    private static final String dateMessage = "Invalid date literal [%1$s]. Date literals should be of form yyyy-MM-dd.";
    private static final String timeOfDayMessage = "Invalid timeofday literal [%1$s]. Timeofday literals should be of form HH:mm:ss[.SSS]";
    private static final String dateTimeMessage = "Invalid datetime literal [%1$s]. Datetime literals should  be of form yyyy-MM-dd HH:mm:ss[.SSS]";

    public static DateValue stringToDate(String string) throws InvalidQueryException {
        String[] stringArray = string.split("-");
        if (stringArray.length != 3) {
            log.error((Object)String.format(dateMessage, string));
            throw new InvalidQueryException(String.format(dateMessage, string));
        }
        try {
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            int n3 = Integer.parseInt(stringArray[2]);
            return new DateValue(n, --n2, n3);
        }
        catch (NumberFormatException numberFormatException) {
            log.error((Object)String.format(dateMessage, string));
            throw new InvalidQueryException(String.format(dateMessage, string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error((Object)String.format(dateMessage, string));
            throw new InvalidQueryException(String.format(dateMessage, string));
        }
    }

    public static TimeOfDayValue stringToTimeOfDay(String string) throws InvalidQueryException {
        String[] stringArray = string.split(":");
        if (stringArray.length != 3) {
            log.error((Object)String.format(timeOfDayMessage, string));
            throw new InvalidQueryException(String.format(timeOfDayMessage, string));
        }
        try {
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            if (stringArray[2].contains(".")) {
                String[] stringArray2 = stringArray[2].split(".");
                if (stringArray2.length != 2) {
                    log.error((Object)String.format(timeOfDayMessage, string));
                    throw new InvalidQueryException(String.format(timeOfDayMessage, string));
                }
                int n3 = Integer.parseInt(stringArray2[0]);
                int n4 = Integer.parseInt(stringArray2[1]);
                return new TimeOfDayValue(n, n2, n3, n4);
            }
            int n5 = Integer.parseInt(stringArray[2]);
            return new TimeOfDayValue(n, n2, n5);
        }
        catch (NumberFormatException numberFormatException) {
            log.error((Object)String.format(timeOfDayMessage, string));
            throw new InvalidQueryException(String.format(timeOfDayMessage, string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error((Object)String.format(timeOfDayMessage, string));
            throw new InvalidQueryException(String.format(timeOfDayMessage, string));
        }
    }

    public static DateTimeValue stringToDatetime(String string) throws InvalidQueryException {
        String[] stringArray = string.split(" ");
        if (stringArray.length != 2) {
            log.error((Object)String.format(dateTimeMessage, string));
            throw new InvalidQueryException(String.format(dateTimeMessage, string));
        }
        String[] stringArray2 = stringArray[0].split("-");
        String[] stringArray3 = stringArray[1].split(":");
        if (stringArray2.length != 3 || stringArray3.length != 3) {
            log.error((Object)String.format(dateTimeMessage, string));
            throw new InvalidQueryException(String.format(dateTimeMessage, string));
        }
        try {
            int n;
            int n2 = Integer.parseInt(stringArray2[0]);
            int n3 = Integer.parseInt(stringArray2[1]);
            --n3;
            int n4 = Integer.parseInt(stringArray2[2]);
            int n5 = Integer.parseInt(stringArray3[0]);
            int n6 = Integer.parseInt(stringArray3[1]);
            int n7 = 0;
            if (stringArray3[2].contains(".")) {
                String[] stringArray4 = stringArray3[2].split("\\.");
                if (stringArray4.length != 2) {
                    log.error((Object)String.format(dateTimeMessage, string));
                    throw new InvalidQueryException(String.format(dateTimeMessage, string));
                }
                n = Integer.parseInt(stringArray4[0]);
                n7 = Integer.parseInt(stringArray4[1]);
            } else {
                n = Integer.parseInt(stringArray3[2]);
            }
            return new DateTimeValue(n2, n3, n4, n5, n6, n, n7);
        }
        catch (NumberFormatException numberFormatException) {
            log.error((Object)String.format(dateTimeMessage, string));
            throw new InvalidQueryException(String.format(dateTimeMessage, string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error((Object)String.format(dateTimeMessage, string));
            throw new InvalidQueryException(String.format(dateTimeMessage, string));
        }
    }

    public static String stripQuotes(String string) {
        if (string.length() < 2) {
            throw new RuntimeException("String is of length < 2 on call to stripQuotes: " + string);
        }
        return string.substring(1, string.length() - 1);
    }

    private ParserUtils() {
    }
}

