/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable.value;

import com.google.visualization.datasource.datatable.value.NullValueException;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;

public class TimeOfDayValue
extends Value {
    private static final TimeOfDayValue NULL_VALUE = new TimeOfDayValue();
    private int hours;
    private int minutes;
    private int seconds;
    private int milliseconds;
    private Integer hashCode = null;

    public static TimeOfDayValue getNullValue() {
        return NULL_VALUE;
    }

    private TimeOfDayValue() {
        this.hashCode = 0;
    }

    public TimeOfDayValue(int n, int n2, int n3) {
        this(n, n2, n3, 0);
    }

    public TimeOfDayValue(int n, int n2, int n3, int n4) {
        if (n >= 24 || n < 0) {
            throw new IllegalArgumentException("This hours value is invalid: " + n);
        }
        if (n2 >= 60 || n2 < 0) {
            throw new IllegalArgumentException("This minutes value is invalid: " + n2);
        }
        if (n3 >= 60 || n3 < 0) {
            throw new IllegalArgumentException("This seconds value is invalid: " + n3);
        }
        if (n4 >= 1000 || n4 < 0) {
            throw new IllegalArgumentException("This milliseconds value is invalid: " + n4);
        }
        this.hours = n;
        this.minutes = n2;
        this.seconds = n3;
        this.milliseconds = n4;
    }

    public TimeOfDayValue(GregorianCalendar gregorianCalendar) {
        if (!gregorianCalendar.getTimeZone().equals((Object)TimeZone.getTimeZone((String)"GMT"))) {
            throw new IllegalArgumentException("Can't create TimeOfDayValue from GregorianCalendar that is not GMT.");
        }
        this.hours = gregorianCalendar.get(11);
        this.minutes = gregorianCalendar.get(12);
        this.seconds = gregorianCalendar.get(13);
        this.milliseconds = gregorianCalendar.get(14);
    }

    @Override
    public ValueType getType() {
        return ValueType.TIMEOFDAY;
    }

    public String toString() {
        if (this == NULL_VALUE) {
            return "null";
        }
        String string = String.format("%1$02d:%2$02d:%3$02d", this.hours, this.minutes, this.seconds);
        if (this.milliseconds > 0) {
            string = string + "." + String.format("%1$3d", this.milliseconds);
        }
        return string;
    }

    @Override
    public boolean isNull() {
        return this == NULL_VALUE;
    }

    @Override
    public int compareTo(Value value) {
        if (this == value) {
            return 0;
        }
        TimeOfDayValue timeOfDayValue = (TimeOfDayValue)value;
        if (this.isNull()) {
            return -1;
        }
        if (timeOfDayValue.isNull()) {
            return 1;
        }
        if (this.hours > timeOfDayValue.hours) {
            return 1;
        }
        if (this.hours < timeOfDayValue.hours) {
            return -1;
        }
        if (this.minutes > timeOfDayValue.minutes) {
            return 1;
        }
        if (this.minutes < timeOfDayValue.minutes) {
            return -1;
        }
        if (this.seconds > timeOfDayValue.seconds) {
            return 1;
        }
        if (this.seconds < timeOfDayValue.seconds) {
            return -1;
        }
        if (this.milliseconds > timeOfDayValue.milliseconds) {
            return 1;
        }
        if (this.milliseconds < timeOfDayValue.milliseconds) {
            return -1;
        }
        return 0;
    }

    @Override
    public int hashCode() {
        if (null != this.hashCode) {
            return this.hashCode;
        }
        int n = 1193;
        n = n * 13 + this.hours;
        n = n * 13 + this.minutes;
        n = n * 13 + this.seconds;
        n = n * 13 + this.milliseconds;
        this.hashCode = n;
        return this.hashCode;
    }

    public Calendar getObjectToFormat() {
        if (this.isNull()) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone((String)"GMT"));
        gregorianCalendar.set(1, 1899);
        gregorianCalendar.set(2, 11);
        gregorianCalendar.set(5, 30);
        gregorianCalendar.set(11, this.hours);
        gregorianCalendar.set(12, this.minutes);
        gregorianCalendar.set(13, this.seconds);
        gregorianCalendar.set(14, this.milliseconds);
        return gregorianCalendar;
    }

    public int getHours() {
        if (this.isNull()) {
            throw new NullValueException("This object is null");
        }
        return this.hours;
    }

    public int getMinutes() {
        if (this.isNull()) {
            throw new NullValueException("This object is null");
        }
        return this.minutes;
    }

    public int getSeconds() {
        if (this.isNull()) {
            throw new NullValueException("This object is null");
        }
        return this.seconds;
    }

    public int getMilliseconds() {
        if (this.isNull()) {
            throw new NullValueException("This object is null");
        }
        return this.milliseconds;
    }

    @Override
    protected String innerToQueryString() {
        String string = "TIMEOFDAY '" + this.hours + ":" + this.minutes + ":" + this.seconds;
        if (this.milliseconds != 0) {
            string = string + "." + this.milliseconds;
        }
        string = string + "'";
        return string;
    }
}

