/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.render;

import org.apache.commons.lang.StringEscapeUtils;

public class EscapeUtil {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private EscapeUtil() {
    }

    public static String jsonEscape(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int j = str.length();
        block14: for (int i = 0; i < j; ++i) {
            char current = str.charAt(i);
            switch (current) {
                case '\'': {
                    sb.append("\\u0027");
                    continue block14;
                }
                case '\"': {
                    sb.append("\\u0022");
                    continue block14;
                }
                case '\\': {
                    sb.append('\\');
                    sb.append(current);
                    continue block14;
                }
                case '<': {
                    sb.append("\\u003c");
                    continue block14;
                }
                case '>': {
                    sb.append("\\u003e");
                    continue block14;
                }
                default: {
                    if (current < ' ' || current >= '\u0080' && current < '\u00a0' || current >= '\u2000' && current < '\u2100') {
                        sb.append('\\');
                        switch (current) {
                            case '\b': {
                                sb.append('b');
                                continue block14;
                            }
                            case '\t': {
                                sb.append('t');
                                continue block14;
                            }
                            case '\n': {
                                sb.append('n');
                                continue block14;
                            }
                            case '\f': {
                                sb.append('f');
                                continue block14;
                            }
                            case '\r': {
                                sb.append('r');
                                continue block14;
                            }
                        }
                        sb.append('u');
                        sb.append(HEX_DIGITS[current >> 12 & 0xF]);
                        sb.append(HEX_DIGITS[current >> 8 & 0xF]);
                        sb.append(HEX_DIGITS[current >> 4 & 0xF]);
                        sb.append(HEX_DIGITS[current & 0xF]);
                        continue block14;
                    }
                    sb.append(current);
                }
            }
        }
        return sb.toString();
    }

    public static String htmlEscape(String str) {
        return StringEscapeUtils.escapeHtml((String)str);
    }
}

