/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.scalarfunction;

import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.datatable.value.TextValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.scalarfunction.ScalarFunction;
import java.util.List;

public class Lower
implements ScalarFunction {
    private static final String FUNCTION_NAME = "lower";
    private static final Lower INSTANCE = new Lower();

    private Lower() {
    }

    public static Lower getInstance() {
        return INSTANCE;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    public Value evaluate(List<Value> values) {
        return new TextValue(((TextValue)values.get(0)).getValue().toLowerCase());
    }

    @Override
    public ValueType getReturnType(List<ValueType> types) {
        return ValueType.TEXT;
    }

    @Override
    public void validateParameters(List<ValueType> types) throws InvalidQueryException {
        if (types.size() != 1) {
            throw new InvalidQueryException("lower requires 1 parmaeter");
        }
        if (types.get(0) != ValueType.TEXT) {
            throw new InvalidQueryException("lower takes a text parameter");
        }
    }

    @Override
    public String toQueryString(List<String> argumentsQueryStrings) {
        return "lower(" + argumentsQueryStrings.get(0) + ")";
    }
}

