/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.scalarfunction;

import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.datatable.value.DateTimeValue;
import com.google.visualization.datasource.datatable.value.DateValue;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.scalarfunction.ScalarFunction;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;
import java.util.Date;
import java.util.List;

public class DateDiff
implements ScalarFunction {
    private static final String FUNCTION_NAME = "dateDiff";
    private static final DateDiff INSTANCE = new DateDiff();

    private DateDiff() {
    }

    public static DateDiff getInstance() {
        return INSTANCE;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    public Value evaluate(List<Value> values) {
        Value firstValue = values.get(0);
        Value secondValue = values.get(1);
        if (firstValue.isNull() || secondValue.isNull()) {
            return NumberValue.getNullValue();
        }
        Date firstDate = this.getDateFromValue(firstValue);
        Date secondDate = this.getDateFromValue(secondValue);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone((String)"GMT"));
        calendar.setTime(secondDate);
        return new NumberValue(calendar.fieldDifference(firstDate, 5));
    }

    private Date getDateFromValue(Value value) {
        Calendar calendar = value.getType() == ValueType.DATE ? ((DateValue)value).getObjectToFormat() : ((DateTimeValue)value).getObjectToFormat();
        return calendar.getTime();
    }

    @Override
    public ValueType getReturnType(List<ValueType> types) {
        return ValueType.NUMBER;
    }

    @Override
    public void validateParameters(List<ValueType> types) throws InvalidQueryException {
        if (types.size() != 2) {
            throw new InvalidQueryException("Number of parameters for the dateDiff function is wrong: " + types.size());
        }
        if (!this.isDateOrDateTimeValue(types.get(0)) || !this.isDateOrDateTimeValue(types.get(1))) {
            throw new InvalidQueryException("Can't perform the function 'dateDiff' on values that are not a Date or a DateTime values");
        }
    }

    private boolean isDateOrDateTimeValue(ValueType type) {
        return type == ValueType.DATE || type == ValueType.DATETIME;
    }

    @Override
    public String toQueryString(List<String> argumentsQueryStrings) {
        return "dateDiff(" + argumentsQueryStrings.get(0) + ", " + argumentsQueryStrings.get(1) + ")";
    }
}

