/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.parser;

import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.query.Query;
import com.google.visualization.datasource.query.parser.ParseException;
import com.google.visualization.datasource.query.parser.QueryParser;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryBuilder {
    private static final Log log = LogFactory.getLog((String)QueryBuilder.class.getName());
    private static final QueryBuilder SINGLETON = new QueryBuilder();

    public static QueryBuilder getInstance() {
        return SINGLETON;
    }

    private QueryBuilder() {
    }

    public Query parseQuery(String tqValue) throws InvalidQueryException {
        Query query;
        if (StringUtils.isEmpty((String)tqValue)) {
            query = new Query();
        } else {
            try {
                query = QueryParser.parseString(tqValue);
            }
            catch (ParseException ex) {
                String messageToUserAndLog = ex.getMessage();
                log.error((Object)("Parsing error: " + messageToUserAndLog));
                throw new InvalidQueryException("Query error: " + messageToUserAndLog);
            }
            query.validate();
        }
        return query;
    }
}

