/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.engine;

import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.AggregationType;
import java.util.List;
import org.apache.commons.lang.text.StrBuilder;

class ColumnTitle {
    private List<Value> values;
    public AggregationColumn aggregation;
    private boolean isMultiAggregationQuery;
    public static final String PIVOT_COLUMNS_SEPARATOR = ",";
    public static final String PIVOT_AGGREGATION_SEPARATOR = " ";

    public ColumnTitle(List<Value> values, AggregationColumn aggregationColumn, boolean isMultiAggregationQuery) {
        this.values = values;
        this.aggregation = aggregationColumn;
        this.isMultiAggregationQuery = isMultiAggregationQuery;
    }

    public List<Value> getValues() {
        return this.values;
    }

    public ColumnDescription createColumnDescription(DataTable originalTable) {
        ColumnDescription colDesc = originalTable.getColumnDescription(this.aggregation.getAggregatedColumn().getId());
        return this.createAggregationColumnDescription(colDesc);
    }

    private String createIdPivotPrefix() {
        if (!this.isPivot()) {
            return "";
        }
        return new StrBuilder().appendWithSeparators(this.values, PIVOT_COLUMNS_SEPARATOR).append(PIVOT_AGGREGATION_SEPARATOR).toString();
    }

    private String createLabelPivotPart() {
        if (!this.isPivot()) {
            return "";
        }
        return new StrBuilder().appendWithSeparators(this.values, PIVOT_COLUMNS_SEPARATOR).toString();
    }

    private boolean isPivot() {
        return !this.values.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnTitle)) {
            return false;
        }
        ColumnTitle other = (ColumnTitle)o;
        return ((Object)this.values).equals(other.values) && this.aggregation.equals(other.aggregation);
    }

    public int hashCode() {
        int hash = 1279;
        hash = hash * 17 + ((Object)this.values).hashCode();
        hash = hash * 17 + this.aggregation.hashCode();
        return hash;
    }

    ColumnDescription createAggregationColumnDescription(ColumnDescription originalColumnDescription) {
        AggregationType aggregationType = this.aggregation.getAggregationType();
        String columnId = this.createIdPivotPrefix() + this.aggregation.getId();
        ValueType type = originalColumnDescription.getType();
        String aggregationLabelPart = this.aggregation.getAggregationType().getCode() + PIVOT_AGGREGATION_SEPARATOR + originalColumnDescription.getLabel();
        String pivotLabelPart = this.createLabelPivotPart();
        String label = this.isPivot() ? (this.isMultiAggregationQuery ? pivotLabelPart + PIVOT_AGGREGATION_SEPARATOR + aggregationLabelPart : pivotLabelPart) : aggregationLabelPart;
        ColumnDescription result = this.canUseSameTypeForAggregation(type, aggregationType) ? new ColumnDescription(columnId, type, label) : new ColumnDescription(columnId, ValueType.NUMBER, label);
        return result;
    }

    private boolean canUseSameTypeForAggregation(ValueType valueType, AggregationType aggregationType) {
        boolean ans;
        if (valueType == ValueType.NUMBER) {
            ans = true;
        } else {
            switch (aggregationType) {
                case MIN: 
                case MAX: {
                    ans = true;
                    break;
                }
                case SUM: 
                case AVG: 
                case COUNT: {
                    ans = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return ans;
    }
}

