/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.engine;

import com.google.common.collect.Maps;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.query.AggregationType;
import com.google.visualization.datasource.query.engine.ValueAggregator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class AggregationNode {
    private AggregationNode parent;
    private Value value;
    private Map<String, ValueAggregator> columnAggregators = Maps.newHashMap();
    private Map<Value, AggregationNode> children = Maps.newHashMap();

    public AggregationNode(Set<String> columnsToAggregate, DataTable table) {
        for (String columnId : columnsToAggregate) {
            this.columnAggregators.put(columnId, new ValueAggregator(table.getColumnDescription(columnId).getType()));
        }
    }

    public void aggregate(Map<String, Value> valuesByColumn) {
        for (String columnId : valuesByColumn.keySet()) {
            this.columnAggregators.get(columnId).aggregate(valuesByColumn.get(columnId));
        }
    }

    public Value getAggregationValue(String columnId, AggregationType type) {
        ValueAggregator valuesAggregator = this.columnAggregators.get(columnId);
        if (valuesAggregator == null) {
            throw new IllegalArgumentException("Column " + columnId + " is not aggregated");
        }
        return valuesAggregator.getValue(type);
    }

    public AggregationNode getChild(Value v) {
        AggregationNode result = this.children.get(v);
        if (result == null) {
            throw new NoSuchElementException("Value " + v + " is not a child.");
        }
        return result;
    }

    public boolean containsChild(Value v) {
        return this.children.containsKey(v);
    }

    public void addChild(Value key, Set<String> columnsToAggregate, DataTable table) {
        if (this.children.containsKey(key)) {
            throw new IllegalArgumentException("A child with key: " + key + " already exists.");
        }
        AggregationNode node = new AggregationNode(columnsToAggregate, table);
        node.parent = this;
        node.value = key;
        this.children.put(key, node);
    }

    public Map<Value, AggregationNode> getChildren() {
        return Maps.newHashMap(this.children);
    }

    protected Value getValue() {
        return this.value;
    }

    protected AggregationNode getParent() {
        return this.parent;
    }
}

