/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.Sets;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.ComparisonFilter;
import com.google.visualization.datasource.query.DataTableColumnLookup;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import java.util.List;
import java.util.Set;

public class ColumnValueFilter
extends ComparisonFilter {
    private AbstractColumn column;
    private Value value;
    private boolean isComparisonOrderReversed;

    public ColumnValueFilter(AbstractColumn column, Value value, ComparisonFilter.Operator operator, boolean isComparisonOrderReversed) {
        super(operator);
        this.column = column;
        this.value = value;
        this.isComparisonOrderReversed = isComparisonOrderReversed;
    }

    public ColumnValueFilter(AbstractColumn column, Value value, ComparisonFilter.Operator operator) {
        this(column, value, operator, false);
    }

    @Override
    public boolean isMatch(DataTable table, TableRow row) {
        DataTableColumnLookup lookup = new DataTableColumnLookup(table);
        Value columnValue = this.column.getValue(lookup, row);
        return this.isComparisonOrderReversed ? this.isOperatorMatch(this.value, columnValue) : this.isOperatorMatch(columnValue, this.value);
    }

    @Override
    public Set<String> getAllColumnIds() {
        return Sets.newHashSet(this.column.getAllSimpleColumnIds());
    }

    @Override
    public List<ScalarFunctionColumn> getScalarFunctionColumns() {
        return this.column.getAllScalarFunctionColumns();
    }

    @Override
    protected List<AggregationColumn> getAggregationColumns() {
        return this.column.getAllAggregationColumns();
    }

    public AbstractColumn getColumn() {
        return this.column;
    }

    public Value getValue() {
        return this.value;
    }

    public boolean isComparisonOrderReversed() {
        return this.isComparisonOrderReversed;
    }

    @Override
    public String toQueryString() {
        if (this.isComparisonOrderReversed) {
            return this.value.toQueryString() + " " + this.operator.toQueryString() + " " + this.column.toQueryString();
        }
        return this.column.toQueryString() + " " + this.operator.toQueryString() + " " + this.value.toQueryString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.column == null ? 0 : this.column.hashCode());
        result = 31 * result + (this.isComparisonOrderReversed ? 1231 : 1237);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnValueFilter other = (ColumnValueFilter)obj;
        if (this.column == null ? other.column != null : !this.column.equals(other.column)) {
            return false;
        }
        if (this.isComparisonOrderReversed != other.isComparisonOrderReversed) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

