/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.Maps;
import java.util.Map;

public enum AggregationType {
    SUM("sum"),
    COUNT("count"),
    MIN("min"),
    MAX("max"),
    AVG("avg");

    private String code;
    private static Map<String, AggregationType> codeToAggregationType;

    private AggregationType(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static AggregationType getByCode(String code) {
        return codeToAggregationType.get(code);
    }

    static {
        codeToAggregationType = Maps.newHashMap();
        for (AggregationType type : AggregationType.values()) {
            codeToAggregationType.put(type.code, type);
        }
    }
}

