/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable.value;

import com.google.visualization.datasource.datatable.value.NullValueException;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;

public class DateValue
extends Value {
    private static final DateValue NULL_VALUE = new DateValue();
    private int year;
    private int month;
    private int dayOfMonth;
    private Integer hashCode = null;

    public static DateValue getNullValue() {
        return NULL_VALUE;
    }

    private DateValue() {
        this.hashCode = 0;
    }

    public DateValue(int year, int month, int dayOfMonth) {
        GregorianCalendar calendar = new GregorianCalendar(year, month, dayOfMonth);
        if (calendar.get(1) != year || calendar.get(2) != month || calendar.get(5) != dayOfMonth) {
            throw new IllegalArgumentException("Invalid java date (yyyy-MM-dd): " + year + '-' + month + '-' + dayOfMonth);
        }
        this.year = year;
        this.month = month;
        this.dayOfMonth = dayOfMonth;
    }

    public DateValue(GregorianCalendar calendar) {
        if (!calendar.getTimeZone().equals((Object)TimeZone.getTimeZone((String)"GMT"))) {
            throw new IllegalArgumentException();
        }
        this.year = calendar.get(1);
        this.month = calendar.get(2);
        this.dayOfMonth = calendar.get(5);
    }

    @Override
    public ValueType getType() {
        return ValueType.DATE;
    }

    public String toString() {
        if (this == NULL_VALUE) {
            return "null";
        }
        return String.format("%1$d-%2$02d-%3$02d", this.year, this.month + 1, this.dayOfMonth);
    }

    @Override
    public boolean isNull() {
        return this == NULL_VALUE;
    }

    @Override
    public int compareTo(Value other) {
        if (this == other) {
            return 0;
        }
        DateValue otherDate = (DateValue)other;
        if (this.isNull()) {
            return -1;
        }
        if (otherDate.isNull()) {
            return 1;
        }
        if (this.year > otherDate.year) {
            return 1;
        }
        if (this.year < otherDate.year) {
            return -1;
        }
        if (this.month > otherDate.month) {
            return 1;
        }
        if (this.month < otherDate.month) {
            return -1;
        }
        if (this.dayOfMonth > otherDate.dayOfMonth) {
            return 1;
        }
        if (this.dayOfMonth < otherDate.dayOfMonth) {
            return -1;
        }
        return 0;
    }

    @Override
    public int hashCode() {
        if (null != this.hashCode) {
            return this.hashCode;
        }
        int hash = 1279;
        hash = hash * 17 + this.year;
        hash = hash * 17 + this.month;
        hash = hash * 17 + this.dayOfMonth;
        this.hashCode = hash;
        return this.hashCode;
    }

    public Calendar getObjectToFormat() {
        if (this.isNull()) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar(this.year, this.month, this.dayOfMonth);
        cal.setTimeZone(TimeZone.getTimeZone((String)"GMT"));
        return cal;
    }

    public int getYear() {
        if (this.isNull()) {
            throw new NullValueException("This object is null");
        }
        return this.year;
    }

    public int getMonth() {
        if (this.isNull()) {
            throw new NullValueException("This object is null");
        }
        return this.month;
    }

    public int getDayOfMonth() {
        if (this.isNull()) {
            throw new NullValueException("This object is null");
        }
        return this.dayOfMonth;
    }

    @Override
    protected String innerToQueryString() {
        return "DATE '" + this.year + "-" + (this.month + 1) + "-" + this.dayOfMonth + "'";
    }
}

