/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable;

import com.google.common.collect.Maps;
import com.google.visualization.datasource.base.BooleanFormat;
import com.google.visualization.datasource.base.LocaleUtil;
import com.google.visualization.datasource.base.TextFormat;
import com.google.visualization.datasource.datatable.value.BooleanValue;
import com.google.visualization.datasource.datatable.value.DateTimeValue;
import com.google.visualization.datasource.datatable.value.DateValue;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.TextValue;
import com.google.visualization.datasource.datatable.value.TimeOfDayValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UFormat;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ValueFormatter {
    private UFormat uFormat;
    private String pattern;
    private ULocale locale;
    private ValueType type;
    private static final String DEFAULT_TEXT_DUMMY_PATTERN = "dummy";
    private static final String DEFAULT_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String DEFAULT_DATE_PATTERNS = "yyyy-MM-dd";
    private static final String DEFAULT_TIMEOFDAY_PATTERN = "HH:mm:ss";
    private static final String DEFAULT_BOOLEAN_PATTERN = "true:false";
    private static final String DEFAULT_NUMBER_PATTERN = "";

    private ValueFormatter(String pattern, UFormat uFormat, ValueType type, ULocale locale) {
        this.pattern = pattern;
        this.uFormat = uFormat;
        this.type = type;
        this.locale = locale;
    }

    public static ValueFormatter createFromPattern(ValueType type, String pattern, ULocale locale) {
        UFormat uFormat = null;
        if (pattern == null) {
            pattern = ValueFormatter.getDefaultPatternByType(type);
        }
        if (locale == null) {
            locale = LocaleUtil.getDefaultLocale();
        }
        try {
            switch (type) {
                case BOOLEAN: {
                    uFormat = new BooleanFormat(pattern);
                    uFormat.format((Object)BooleanValue.TRUE.getObjectToFormat());
                    break;
                }
                case TEXT: {
                    uFormat = new TextFormat();
                    break;
                }
                case DATE: {
                    uFormat = new SimpleDateFormat(pattern, locale);
                    ((SimpleDateFormat)uFormat).setTimeZone(TimeZone.getTimeZone((String)"GMT"));
                    uFormat.format((Object)new DateValue(1995, 7, 3).getObjectToFormat());
                    break;
                }
                case TIMEOFDAY: {
                    uFormat = new SimpleDateFormat(pattern, locale);
                    ((SimpleDateFormat)uFormat).setTimeZone(TimeZone.getTimeZone((String)"GMT"));
                    uFormat.format((Object)new TimeOfDayValue(2, 59, 12, 123).getObjectToFormat());
                    break;
                }
                case DATETIME: {
                    uFormat = new SimpleDateFormat(pattern, locale);
                    ((SimpleDateFormat)uFormat).setTimeZone(TimeZone.getTimeZone((String)"GMT"));
                    uFormat.format((Object)new DateTimeValue(1995, 7, 3, 2, 59, 12, 123).getObjectToFormat());
                    break;
                }
                case NUMBER: {
                    DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
                    uFormat = new DecimalFormat(pattern, symbols);
                    uFormat.format((Object)new NumberValue(-12.3).getObjectToFormat());
                }
            }
        }
        catch (RuntimeException e) {
            return null;
        }
        return new ValueFormatter(pattern, uFormat, type, locale);
    }

    public static ValueFormatter createDefault(ValueType type, ULocale locale) {
        String pattern = ValueFormatter.getDefaultPatternByType(type);
        return ValueFormatter.createFromPattern(type, pattern, locale);
    }

    public static Map<ValueType, ValueFormatter> createDefaultFormatters(ULocale locale) {
        HashMap foramtters = Maps.newHashMap();
        for (ValueType type : ValueType.values()) {
            foramtters.put(type, ValueFormatter.createDefault(type, locale));
        }
        return foramtters;
    }

    public String format(Value value) {
        if (value.isNull()) {
            return DEFAULT_NUMBER_PATTERN;
        }
        return this.uFormat.format(value.getObjectToFormat());
    }

    public Value parse(String val) {
        Value value = null;
        try {
            switch (this.type) {
                case DATE: {
                    value = this.parseDate(val);
                    break;
                }
                case TIMEOFDAY: {
                    value = this.parseTimeOfDay(val);
                    break;
                }
                case DATETIME: {
                    value = this.parseDateTime(val);
                    break;
                }
                case NUMBER: {
                    value = this.parseNumber(val);
                    break;
                }
                case BOOLEAN: {
                    value = this.parseBoolean(val);
                    break;
                }
                case TEXT: {
                    value = new TextValue(val);
                }
            }
        }
        catch (ParseException pe) {
            value = Value.getNullValueFromValueType(this.type);
        }
        return value;
    }

    private static String getDefaultPatternByType(ValueType type) {
        String defaultPattern;
        switch (type) {
            case TEXT: {
                defaultPattern = DEFAULT_TEXT_DUMMY_PATTERN;
                break;
            }
            case DATE: {
                defaultPattern = DEFAULT_DATE_PATTERNS;
                break;
            }
            case DATETIME: {
                defaultPattern = DEFAULT_DATETIME_PATTERN;
                break;
            }
            case TIMEOFDAY: {
                defaultPattern = DEFAULT_TIMEOFDAY_PATTERN;
                break;
            }
            case BOOLEAN: {
                defaultPattern = DEFAULT_BOOLEAN_PATTERN;
                break;
            }
            case NUMBER: {
                defaultPattern = DEFAULT_NUMBER_PATTERN;
                break;
            }
            default: {
                defaultPattern = null;
            }
        }
        return defaultPattern;
    }

    private BooleanValue parseBoolean(String val) throws ParseException {
        Boolean bool = ((BooleanFormat)this.uFormat).parse(val);
        return BooleanValue.getInstance(bool);
    }

    private NumberValue parseNumber(String val) throws ParseException {
        Number n = ((NumberFormat)this.uFormat).parse(val);
        return new NumberValue(n.doubleValue());
    }

    private DateTimeValue parseDateTime(String val) throws ParseException {
        Date date = ((SimpleDateFormat)this.uFormat).parse(val);
        GregorianCalendar gc = new GregorianCalendar(TimeZone.getTimeZone((String)"GMT"));
        gc.setTime(date);
        return new DateTimeValue(gc);
    }

    private DateValue parseDate(String val) throws ParseException {
        Date date = ((SimpleDateFormat)this.uFormat).parse(val);
        GregorianCalendar gc = new GregorianCalendar(TimeZone.getTimeZone((String)"GMT"));
        gc.setTime(date);
        return new DateValue(gc);
    }

    private TimeOfDayValue parseTimeOfDay(String val) throws ParseException {
        Date date = ((SimpleDateFormat)this.uFormat).parse(val);
        GregorianCalendar gc = new GregorianCalendar(TimeZone.getTimeZone((String)"GMT"));
        gc.setTime(date);
        return new TimeOfDayValue(gc);
    }

    public UFormat getUFormat() {
        return this.uFormat;
    }

    public String getPattern() {
        return this.pattern;
    }

    public ULocale getLocale() {
        return this.locale;
    }

    public ValueType getType() {
        return this.type;
    }
}

