/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource;

import com.google.visualization.datasource.base.DataSourceParameters;
import com.google.visualization.datasource.base.OutputType;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class ResponseWriter {
    private static final byte[] UTF_16LE_BOM = new byte[]{-1, -2};

    private ResponseWriter() {
    }

    public static void setServletResponse(String responseMessage, DataSourceParameters dataSourceParameters, HttpServletResponse res) throws IOException {
        OutputType type = dataSourceParameters.getOutputType();
        switch (type) {
            case CSV: {
                ResponseWriter.setServletResponseCSV(responseMessage, dataSourceParameters, res);
                break;
            }
            case TSV_EXCEL: {
                ResponseWriter.setServletResponseTSVExcel(responseMessage, dataSourceParameters, res);
                break;
            }
            case HTML: {
                ResponseWriter.setServletResponseHTML(responseMessage, res);
                break;
            }
            case JSONP: 
            case JSON: {
                ResponseWriter.setServletResponseJSON(responseMessage, res);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled output type.");
            }
        }
    }

    private static void setServletResponseCSV(String responseMessage, DataSourceParameters dataSourceParameters, HttpServletResponse res) throws IOException {
        res.setContentType("text/csv; charset=UTF-8");
        String outFileName = dataSourceParameters.getOutFileName();
        if (!outFileName.toLowerCase().endsWith(".csv")) {
            outFileName = outFileName + ".csv";
        }
        res.setHeader("content-disposition", "attachment; filename=" + outFileName);
        ResponseWriter.writeServletResponse(responseMessage, res);
    }

    private static void setServletResponseTSVExcel(String responseMessage, DataSourceParameters dsParams, HttpServletResponse res) throws IOException {
        res.setContentType("text/csv; charset=UTF-16LE");
        String outFileName = dsParams.getOutFileName();
        res.setHeader("Content-Disposition", "attachment; filename=" + outFileName);
        ResponseWriter.writeServletResponse(responseMessage, res, "UTF-16LE", UTF_16LE_BOM);
    }

    private static void setServletResponseHTML(String responseMessage, HttpServletResponse res) throws IOException {
        res.setContentType("text/html; charset=UTF-8");
        ResponseWriter.writeServletResponse(responseMessage, res);
    }

    private static void setServletResponseJSON(String responseMessage, HttpServletResponse res) throws IOException {
        res.setContentType("text/plain; charset=UTF-8");
        ResponseWriter.writeServletResponse(responseMessage, res);
    }

    private static void writeServletResponse(CharSequence responseMessage, HttpServletResponse res) throws IOException {
        ResponseWriter.writeServletResponse(responseMessage, res, "UTF-8", null);
    }

    private static void writeServletResponse(CharSequence charSequence, HttpServletResponse res, String charset, byte[] byteOrderMark) throws IOException {
        ServletOutputStream outputStream = res.getOutputStream();
        if (byteOrderMark != null) {
            outputStream.write(byteOrderMark);
        }
        outputStream.write(((Object)charSequence).toString().getBytes(charset));
    }
}

