/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource;

import com.google.visualization.datasource.DataSourceHelper;
import com.google.visualization.datasource.base.DataSourceException;
import com.google.visualization.datasource.base.DataSourceParameters;
import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.base.OutputType;
import com.google.visualization.datasource.query.Query;
import com.ibm.icu.util.ULocale;
import javax.servlet.http.HttpServletRequest;

public class DataSourceRequest {
    private Query query;
    private DataSourceParameters dsParams;
    private ULocale userLocale;
    private boolean sameOrigin;
    public static final String SAME_ORIGIN_HEADER = "X-DataSource-Auth";
    public static final String QUERY_REQUEST_PARAMETER = "tq";
    public static final String DATASOURCE_REQUEST_PARAMETER = "tqx";

    private DataSourceRequest() {
    }

    public DataSourceRequest(Query query, DataSourceParameters dsParams, ULocale userLocale) {
        this.setUserLocale(userLocale);
        this.dsParams = dsParams;
        this.query = query;
    }

    public DataSourceRequest(HttpServletRequest req) throws DataSourceException {
        this.inferLocaleFromRequest(req);
        this.sameOrigin = DataSourceRequest.determineSameOrigin(req);
        this.createDataSourceParametersFromRequest(req);
        this.createQueryFromRequest(req);
    }

    public static DataSourceRequest getDefaultDataSourceRequest(HttpServletRequest req) {
        DataSourceRequest dataSourceRequest;
        block5: {
            dataSourceRequest = new DataSourceRequest();
            dataSourceRequest.inferLocaleFromRequest(req);
            dataSourceRequest.sameOrigin = DataSourceRequest.determineSameOrigin(req);
            try {
                dataSourceRequest.createDataSourceParametersFromRequest(req);
            }
            catch (DataSourceException e) {
                if (dataSourceRequest.dsParams == null) {
                    dataSourceRequest.dsParams = DataSourceParameters.getDefaultDataSourceParameters();
                }
                if (dataSourceRequest.dsParams.getOutputType() != OutputType.JSON || dataSourceRequest.sameOrigin) break block5;
                dataSourceRequest.dsParams.setOutputType(OutputType.JSONP);
            }
        }
        try {
            dataSourceRequest.createQueryFromRequest(req);
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
        return dataSourceRequest;
    }

    public static boolean determineSameOrigin(HttpServletRequest req) {
        return req.getHeader(SAME_ORIGIN_HEADER) != null;
    }

    private void createQueryFromRequest(HttpServletRequest req) throws InvalidQueryException {
        String queryString = req.getParameter(QUERY_REQUEST_PARAMETER);
        this.query = DataSourceHelper.parseQuery(queryString);
    }

    private void createDataSourceParametersFromRequest(HttpServletRequest req) throws DataSourceException {
        String dataSourceParamsString = req.getParameter(DATASOURCE_REQUEST_PARAMETER);
        this.dsParams = new DataSourceParameters(dataSourceParamsString);
        if (this.dsParams.getOutputType() == OutputType.JSON && !this.sameOrigin) {
            this.dsParams.setOutputType(OutputType.JSONP);
        }
    }

    private void inferLocaleFromRequest(HttpServletRequest req) {
        this.userLocale = DataSourceHelper.getLocaleFromRequest(req);
    }

    public Query getQuery() {
        return this.query;
    }

    public DataSourceParameters getDataSourceParameters() {
        return this.dsParams;
    }

    public void setUserLocale(ULocale userLocale) {
        this.userLocale = userLocale;
    }

    public ULocale getUserLocale() {
        return this.userLocale;
    }

    public boolean isSameOrigin() {
        return this.sameOrigin;
    }
}

