/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.re2j;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import com.google.re2j.Pattern;

public final class Re2jSubjects {
    public static Subject.Factory<Re2jStringSubject, String> re2jString() {
        return Re2jStringSubject.FACTORY;
    }

    private Re2jSubjects() {
    }

    public static final class Re2jStringSubject
    extends Subject {
        private static final Subject.Factory<Re2jStringSubject, String> FACTORY = new Subject.Factory<Re2jStringSubject, String>(){

            public Re2jStringSubject createSubject(FailureMetadata failureMetadata, String target) {
                return new Re2jStringSubject(failureMetadata, target);
            }
        };
        private final String actual;

        private Re2jStringSubject(FailureMetadata failureMetadata, String subject) {
            super(failureMetadata, (Object)subject);
            this.actual = subject;
        }

        protected String actualCustomStringRepresentation() {
            return Re2jStringSubject.quote(this.actual);
        }

        public void matches(String regex) {
            if (!Pattern.matches((String)regex, (CharSequence)this.actual)) {
                this.failWithActual("expected to match ", regex);
            }
        }

        @GwtIncompatible(value="com.google.re2j.Pattern")
        public void matches(Pattern regex) {
            if (!regex.matcher((CharSequence)this.actual).matches()) {
                this.failWithActual("expected to match ", regex);
            }
        }

        public void doesNotMatch(String regex) {
            if (Pattern.matches((String)regex, (CharSequence)this.actual)) {
                this.failWithActual("expected to fail to match", regex);
            }
        }

        @GwtIncompatible(value="com.google.re2j.Pattern")
        public void doesNotMatch(Pattern regex) {
            if (regex.matcher((CharSequence)this.actual).matches()) {
                this.failWithActual("expected to fail to match", regex);
            }
        }

        @GwtIncompatible(value="com.google.re2j.Pattern")
        public void containsMatch(Pattern pattern) {
            if (!pattern.matcher((CharSequence)this.actual).find()) {
                this.failWithActual("expected to contain a match for", pattern);
            }
        }

        public void containsMatch(String regex) {
            if (!Re2jStringSubject.doContainsMatch(this.actual, regex)) {
                this.failWithActual("expected to contain a match for", regex);
            }
        }

        @GwtIncompatible(value="com.google.re2j.Pattern")
        public void doesNotContainMatch(Pattern pattern) {
            if (pattern.matcher((CharSequence)this.actual).find()) {
                this.failWithActual("expected not to contain a match for", pattern);
            }
        }

        public void doesNotContainMatch(String regex) {
            if (Re2jStringSubject.doContainsMatch(this.actual, regex)) {
                this.failWithActual("expected not to contain a match for", regex);
            }
        }

        private static String quote(CharSequence toBeWrapped) {
            String string = String.valueOf(toBeWrapped);
            return new StringBuilder(2 + String.valueOf(string).length()).append("\"").append(string).append("\"").toString();
        }

        private static boolean doContainsMatch(String subject, String regex) {
            return Pattern.compile((String)regex).matcher((CharSequence)subject).find();
        }
    }
}

