/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.re2j;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import com.google.re2j.Pattern;

public final class Re2jSubjects {
    public static Subject.Factory<Re2jStringSubject, String> re2jString() {
        return Re2jStringSubject.FACTORY;
    }

    private Re2jSubjects() {
    }

    public static final class Re2jStringSubject
    extends Subject<Re2jStringSubject, String> {
        private static final Subject.Factory<Re2jStringSubject, String> FACTORY = new Subject.Factory<Re2jStringSubject, String>(){

            public Re2jStringSubject createSubject(FailureMetadata failureMetadata, String target) {
                return new Re2jStringSubject(failureMetadata, target);
            }
        };

        private Re2jStringSubject(FailureMetadata failureMetadata, String subject) {
            super(failureMetadata, (Object)subject);
        }

        protected String actualCustomStringRepresentation() {
            return Re2jStringSubject.quote((CharSequence)this.actual());
        }

        public void matches(String regex) {
            if (!Pattern.matches((String)regex, (CharSequence)((CharSequence)this.actual()))) {
                this.fail("matches", regex);
            }
        }

        @GwtIncompatible(value="com.google.re2j.Pattern")
        public void matches(Pattern regex) {
            if (!regex.matcher((CharSequence)this.actual()).matches()) {
                this.fail("matches", regex);
            }
        }

        public void doesNotMatch(String regex) {
            if (Pattern.matches((String)regex, (CharSequence)((CharSequence)this.actual()))) {
                this.fail("fails to match", regex);
            }
        }

        @GwtIncompatible(value="com.google.re2j.Pattern")
        public void doesNotMatch(Pattern regex) {
            if (regex.matcher((CharSequence)this.actual()).matches()) {
                this.fail("fails to match", regex);
            }
        }

        @GwtIncompatible(value="com.google.re2j.Pattern")
        public void containsMatch(Pattern pattern) {
            if (!pattern.matcher((CharSequence)this.actual()).find()) {
                this.failWithRawMessage("%s should have contained a match for <%s>", new Object[]{this.actualAsString(), pattern});
            }
        }

        public void containsMatch(String regex) {
            if (!Re2jStringSubject.containsMatch((String)this.actual(), regex)) {
                this.failWithRawMessage("%s should have contained a match for <%s>", new Object[]{this.actualAsString(), regex});
            }
        }

        @GwtIncompatible(value="com.google.re2j.Pattern")
        public void doesNotContainMatch(Pattern pattern) {
            if (pattern.matcher((CharSequence)this.actual()).find()) {
                this.failWithRawMessage("%s should not have contained a match for <%s>", new Object[]{this.actualAsString(), pattern});
            }
        }

        public void doesNotContainMatch(String regex) {
            if (Re2jStringSubject.containsMatch((String)this.actual(), regex)) {
                this.failWithRawMessage("%s should not have contained a match for <%s>", new Object[]{this.actualAsString(), regex});
            }
        }

        private static String quote(CharSequence toBeWrapped) {
            return "\"" + toBeWrapped + "\"";
        }

        private static boolean containsMatch(String subject, String regex) {
            return Pattern.compile((String)regex).matcher((CharSequence)subject).find();
        }
    }
}

