/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.re2j;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import com.google.re2j.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Re2jSubjects {
    public static SubjectFactory<Re2jStringSubject, String> re2jString() {
        return Re2jStringSubject.FACTORY;
    }

    private Re2jSubjects() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Re2jStringSubject
    extends Subject<Re2jStringSubject, String> {
        private static final SubjectFactory<Re2jStringSubject, String> FACTORY = new SubjectFactory<Re2jStringSubject, String>(){

            public Re2jStringSubject getSubject(FailureStrategy fs, String target) {
                return new Re2jStringSubject(fs, target);
            }
        };

        private Re2jStringSubject(FailureStrategy failureStrategy, String subject) {
            super(failureStrategy, (Object)subject);
        }

        protected String getDisplaySubject() {
            if (this.internalCustomName() != null) {
                String string = String.valueOf(this.internalCustomName());
                String string2 = Re2jStringSubject.quote((CharSequence)this.getSubject());
                return new StringBuilder(5 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" (<").append(string2).append(">)").toString();
            }
            String string = Re2jStringSubject.quote((CharSequence)this.getSubject());
            return new StringBuilder(2 + String.valueOf(string).length()).append("<").append(string).append(">").toString();
        }

        public void matches(String regex) {
            if (!Pattern.matches((String)regex, (CharSequence)((CharSequence)this.getSubject()))) {
                this.fail("matches", regex);
            }
        }

        @GwtIncompatible(value="com.google.re2j.Pattern")
        public void matches(Pattern regex) {
            if (!regex.matcher((CharSequence)this.getSubject()).matches()) {
                this.fail("matches", regex);
            }
        }

        public void doesNotMatch(String regex) {
            if (Pattern.matches((String)regex, (CharSequence)((CharSequence)this.getSubject()))) {
                this.fail("fails to match", regex);
            }
        }

        @GwtIncompatible(value="com.google.re2j.Pattern")
        public void doesNotMatch(Pattern regex) {
            if (regex.matcher((CharSequence)this.getSubject()).matches()) {
                this.fail("fails to match", regex);
            }
        }

        @GwtIncompatible(value="com.google.re2j.Pattern")
        public void containsMatch(Pattern pattern) {
            if (!pattern.matcher((CharSequence)this.getSubject()).find()) {
                this.failWithRawMessage("%s should have contained a match for <%s>", new Object[]{this.getDisplaySubject(), pattern});
            }
        }

        public void containsMatch(String regex) {
            if (!Re2jStringSubject.containsMatch((String)this.getSubject(), regex)) {
                this.failWithRawMessage("%s should have contained a match for <%s>", new Object[]{this.getDisplaySubject(), regex});
            }
        }

        @GwtIncompatible(value="com.google.re2j.Pattern")
        public void doesNotContainMatch(Pattern pattern) {
            if (pattern.matcher((CharSequence)this.getSubject()).find()) {
                this.failWithRawMessage("%s should not have contained a match for <%s>", new Object[]{this.getDisplaySubject(), pattern});
            }
        }

        public void doesNotContainMatch(String regex) {
            if (Re2jStringSubject.containsMatch((String)this.getSubject(), regex)) {
                this.failWithRawMessage("%s should not have contained a match for <%s>", new Object[]{this.getDisplaySubject(), regex});
            }
        }

        private static String quote(CharSequence toBeWrapped) {
            String string = String.valueOf(toBeWrapped);
            return new StringBuilder(2 + String.valueOf(string).length()).append("\"").append(string).append("\"").toString();
        }

        private static boolean containsMatch(String subject, String regex) {
            return Pattern.compile((String)regex).matcher((CharSequence)subject).find();
        }
    }
}

