/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.truth.Correspondence;
import com.google.common.truth.extensions.proto.AnyUtils;
import com.google.common.truth.extensions.proto.DiffResult;
import com.google.common.truth.extensions.proto.FieldDescriptorValidator;
import com.google.common.truth.extensions.proto.FieldScopeResult;
import com.google.common.truth.extensions.proto.FluentEqualityConfig;
import com.google.common.truth.extensions.proto.RecursableDiffEntity;
import com.google.common.truth.extensions.proto.SubScopeId;
import com.google.common.truth.extensions.proto.UnknownFieldDescriptor;
import com.google.protobuf.Any;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ProtoTruthMessageDifferencer {
    private final FluentEqualityConfig rootConfig;
    private final Descriptors.Descriptor rootDescriptor;
    private final TextFormat.Printer protoPrinter;

    private ProtoTruthMessageDifferencer(FluentEqualityConfig rootConfig, Descriptors.Descriptor descriptor) {
        rootConfig.validate(descriptor, FieldDescriptorValidator.ALLOW_ALL);
        this.rootConfig = rootConfig;
        this.rootDescriptor = descriptor;
        this.protoPrinter = TextFormat.printer().usingTypeRegistry(rootConfig.useTypeRegistry());
    }

    static ProtoTruthMessageDifferencer create(FluentEqualityConfig rootConfig, Descriptors.Descriptor descriptor) {
        return new ProtoTruthMessageDifferencer(rootConfig, descriptor);
    }

    DiffResult diffMessages(Message actual, Message expected) {
        Preconditions.checkNotNull((Object)actual);
        Preconditions.checkNotNull((Object)expected);
        Preconditions.checkArgument((actual.getDescriptorForType() == expected.getDescriptorForType() ? 1 : 0) != 0, (String)"The actual [%s] and expected [%s] message descriptors do not match.", (Object)actual.getDescriptorForType(), (Object)expected.getDescriptorForType());
        return this.diffMessages(actual, expected, this.rootConfig);
    }

    private DiffResult diffMessages(Message actual, Message expected, FluentEqualityConfig config) {
        if (actual.getDescriptorForType().equals(Any.getDescriptor())) {
            return this.diffAnyMessages(actual, expected, config);
        }
        DiffResult.Builder builder = DiffResult.newBuilder().setActual(actual).setExpected(expected);
        Map actualFields = actual.getAllFields();
        Map expectedFields = expected.getAllFields();
        for (Descriptors.FieldDescriptor fieldDescriptor : Sets.union(actualFields.keySet(), expectedFields.keySet())) {
            SubScopeId subScopeId = SubScopeId.of(fieldDescriptor);
            FieldScopeResult shouldCompare = config.compareFieldsScope().policyFor(this.rootDescriptor, subScopeId);
            if (shouldCompare == FieldScopeResult.EXCLUDED_RECURSIVELY) {
                builder.addSingularField(fieldDescriptor.getNumber(), DiffResult.SingularField.ignored(ProtoTruthMessageDifferencer.name(fieldDescriptor)));
                continue;
            }
            if (fieldDescriptor.isRepeated()) {
                if (fieldDescriptor.isMapField()) {
                    ImmutableMap<Object, Object> actualMap = ProtoTruthMessageDifferencer.toProtoMap(actualFields.get(fieldDescriptor));
                    ImmutableMap<Object, Object> expectedMap = ProtoTruthMessageDifferencer.toProtoMap(expectedFields.get(fieldDescriptor));
                    ImmutableSet actualAndExpectedKeys = Sets.union(actualMap.keySet(), expectedMap.keySet()).immutableCopy();
                    builder.addAllSingularFields(fieldDescriptor.getNumber(), this.compareMapFieldsByKey((Map<Object, Object>)actualMap, (Map<Object, Object>)expectedMap, (Set<Object>)actualAndExpectedKeys, fieldDescriptor, config.subScope(this.rootDescriptor, subScopeId)));
                    continue;
                }
                List<?> actualList = ProtoTruthMessageDifferencer.toProtoList(actualFields.get(fieldDescriptor));
                List<?> expectedList = ProtoTruthMessageDifferencer.toProtoList(expectedFields.get(fieldDescriptor));
                boolean ignoreRepeatedFieldOrder = config.ignoreRepeatedFieldOrderScope().contains(this.rootDescriptor, subScopeId);
                boolean ignoreExtraRepeatedFieldElements = config.ignoreExtraRepeatedFieldElementsScope().contains(this.rootDescriptor, subScopeId);
                if (ignoreRepeatedFieldOrder) {
                    builder.addRepeatedField(fieldDescriptor.getNumber(), this.compareRepeatedFieldIgnoringOrder(actualList, expectedList, shouldCompare == FieldScopeResult.EXCLUDED_NONRECURSIVELY, fieldDescriptor, ignoreExtraRepeatedFieldElements, config.subScope(this.rootDescriptor, subScopeId)));
                    continue;
                }
                if (ignoreExtraRepeatedFieldElements && !expectedList.isEmpty()) {
                    builder.addRepeatedField(fieldDescriptor.getNumber(), this.compareRepeatedFieldExpectingSubsequence(actualList, expectedList, shouldCompare == FieldScopeResult.EXCLUDED_NONRECURSIVELY, fieldDescriptor, config.subScope(this.rootDescriptor, subScopeId)));
                    continue;
                }
                builder.addAllSingularFields(fieldDescriptor.getNumber(), this.compareRepeatedFieldByIndices(actualList, expectedList, shouldCompare == FieldScopeResult.EXCLUDED_NONRECURSIVELY, fieldDescriptor, config.subScope(this.rootDescriptor, subScopeId)));
                continue;
            }
            builder.addSingularField(fieldDescriptor.getNumber(), this.compareSingularValue(actualFields.get(fieldDescriptor), expectedFields.get(fieldDescriptor), actual.getDefaultInstanceForType().getField(fieldDescriptor), shouldCompare == FieldScopeResult.EXCLUDED_NONRECURSIVELY, fieldDescriptor, ProtoTruthMessageDifferencer.name(fieldDescriptor), config.subScope(this.rootDescriptor, subScopeId)));
        }
        if (!config.ignoreFieldAbsenceScope().isAll()) {
            DiffResult.UnknownFieldSetDiff diff = this.diffUnknowns(actual.getUnknownFields(), expected.getUnknownFields(), config);
            builder.setUnknownFields(diff);
        }
        return builder.build();
    }

    private DiffResult diffAnyMessages(Message actual, Message expected, FluentEqualityConfig config) {
        DiffResult.SingularField valueDiffResult;
        DiffResult.Builder builder = DiffResult.newBuilder().setActual(actual).setExpected(expected);
        FieldScopeResult shouldCompareTypeUrl = config.compareFieldsScope().policyFor(this.rootDescriptor, AnyUtils.typeUrlSubScopeId());
        DiffResult.SingularField typeUrlDiffResult = !shouldCompareTypeUrl.included() ? DiffResult.SingularField.ignored(ProtoTruthMessageDifferencer.name(AnyUtils.typeUrlFieldDescriptor())) : this.compareSingularPrimitive(actual.getField(AnyUtils.typeUrlFieldDescriptor()), expected.getField(AnyUtils.typeUrlFieldDescriptor()), "", AnyUtils.typeUrlFieldDescriptor(), ProtoTruthMessageDifferencer.name(AnyUtils.typeUrlFieldDescriptor()), config.subScope(this.rootDescriptor, AnyUtils.typeUrlSubScopeId()));
        builder.addSingularField(1, typeUrlDiffResult);
        FieldScopeResult shouldCompareValue = config.compareFieldsScope().policyFor(this.rootDescriptor, AnyUtils.valueSubScopeId());
        if (shouldCompareValue == FieldScopeResult.EXCLUDED_RECURSIVELY) {
            valueDiffResult = DiffResult.SingularField.ignored(ProtoTruthMessageDifferencer.name(AnyUtils.valueFieldDescriptor()));
        } else {
            Optional<Message> unpackedActual = AnyUtils.unpack(actual, config.useTypeRegistry(), config.useExtensionRegistry());
            Optional<Message> unpackedExpected = AnyUtils.unpack(expected, config.useTypeRegistry(), config.useExtensionRegistry());
            if (unpackedActual.isPresent() && unpackedExpected.isPresent() && ProtoTruthMessageDifferencer.descriptorsMatch((Message)unpackedActual.get(), (Message)unpackedExpected.get())) {
                Message defaultMessage = ((Message)unpackedActual.get()).getDefaultInstanceForType();
                valueDiffResult = this.compareSingularMessage((Message)unpackedActual.get(), (Message)unpackedExpected.get(), defaultMessage, shouldCompareValue == FieldScopeResult.EXCLUDED_NONRECURSIVELY, AnyUtils.valueFieldDescriptor(), ProtoTruthMessageDifferencer.name(AnyUtils.valueFieldDescriptor()), config.subScope(this.rootDescriptor, SubScopeId.ofUnpackedAnyValueType(((Message)unpackedActual.get()).getDescriptorForType())));
            } else {
                valueDiffResult = this.compareSingularValue(actual.getField(AnyUtils.valueFieldDescriptor()), expected.getField(AnyUtils.valueFieldDescriptor()), AnyUtils.valueFieldDescriptor().getDefaultValue(), shouldCompareValue == FieldScopeResult.EXCLUDED_NONRECURSIVELY, AnyUtils.valueFieldDescriptor(), ProtoTruthMessageDifferencer.name(AnyUtils.valueFieldDescriptor()), config.subScope(this.rootDescriptor, AnyUtils.valueSubScopeId()));
            }
        }
        builder.addSingularField(2, valueDiffResult);
        if (!config.ignoreFieldAbsenceScope().isAll()) {
            DiffResult.UnknownFieldSetDiff diff = this.diffUnknowns(actual.getUnknownFields(), expected.getUnknownFields(), config);
            builder.setUnknownFields(diff);
        }
        return builder.build();
    }

    private static boolean descriptorsMatch(Message actual, Message expected) {
        return actual.getDescriptorForType().equals(expected.getDescriptorForType());
    }

    private static ImmutableMap<Object, Object> toProtoMap(@Nullable Object container) {
        if (container == null) {
            return ImmutableMap.of();
        }
        List entryMessages = (List)container;
        HashMap retVal = Maps.newHashMap();
        for (Object entry : entryMessages) {
            Message message = (Message)entry;
            retVal.put(ProtoTruthMessageDifferencer.valueAtFieldNumber(message, 1), ProtoTruthMessageDifferencer.valueAtFieldNumber(message, 2));
        }
        return ImmutableMap.copyOf((Map)retVal);
    }

    private static Object valueAtFieldNumber(Message message, int fieldNumber) {
        Descriptors.FieldDescriptor field = message.getDescriptorForType().findFieldByNumber(fieldNumber);
        Object value = message.getAllFields().get(field);
        return value != null ? value : field.getDefaultValue();
    }

    private static List<?> toProtoList(@Nullable Object container) {
        if (container == null) {
            return Collections.emptyList();
        }
        return (List)container;
    }

    private List<DiffResult.SingularField> compareMapFieldsByKey(Map<Object, Object> actualMap, Map<Object, Object> expectedMap, Set<Object> actualAndExpectedKeys, Descriptors.FieldDescriptor mapFieldDescriptor, FluentEqualityConfig mapConfig) {
        Descriptors.FieldDescriptor keyFieldDescriptor = mapFieldDescriptor.getMessageType().findFieldByNumber(1);
        Descriptors.FieldDescriptor valueFieldDescriptor = mapFieldDescriptor.getMessageType().findFieldByNumber(2);
        SubScopeId valueSubScopeId = SubScopeId.of(valueFieldDescriptor);
        FieldScopeResult compareValues = mapConfig.compareFieldsScope().policyFor(this.rootDescriptor, valueSubScopeId);
        if (compareValues == FieldScopeResult.EXCLUDED_RECURSIVELY) {
            return ImmutableList.of((Object)DiffResult.SingularField.ignored(ProtoTruthMessageDifferencer.name(mapFieldDescriptor)));
        }
        boolean ignoreExtraRepeatedFieldElements = mapConfig.ignoreExtraRepeatedFieldElementsScope().contains(this.rootDescriptor, SubScopeId.of(mapFieldDescriptor));
        FluentEqualityConfig valuesConfig = mapConfig.subScope(this.rootDescriptor, valueSubScopeId);
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)actualAndExpectedKeys.size());
        for (Object key : actualAndExpectedKeys) {
            @Nullable Object actualValue = actualMap.get(key);
            @Nullable Object expectedValue = expectedMap.get(key);
            if (ignoreExtraRepeatedFieldElements && !expectedMap.isEmpty() && expectedValue == null) {
                builder.add((Object)DiffResult.SingularField.ignored(ProtoTruthMessageDifferencer.indexedName(mapFieldDescriptor, key, keyFieldDescriptor)));
                continue;
            }
            builder.add((Object)this.compareSingularValue(actualValue, expectedValue, null, compareValues == FieldScopeResult.EXCLUDED_NONRECURSIVELY, valueFieldDescriptor, ProtoTruthMessageDifferencer.indexedName(mapFieldDescriptor, key, keyFieldDescriptor), valuesConfig));
        }
        return builder.build();
    }

    private DiffResult.RepeatedField compareRepeatedFieldIgnoringOrder(List<?> actualList, List<?> expectedList, boolean excludeNonRecursive, Descriptors.FieldDescriptor fieldDescriptor, boolean ignoreExtraRepeatedFieldElements, FluentEqualityConfig config) {
        DiffResult.RepeatedField.Builder builder = DiffResult.RepeatedField.newBuilder().setFieldDescriptor(fieldDescriptor).setActual(actualList).setExpected(expectedList);
        Set<Integer> unmatchedActual = ProtoTruthMessageDifferencer.setForRange(actualList.size());
        Set<Integer> unmatchedExpected = ProtoTruthMessageDifferencer.setForRange(expectedList.size());
        block0: for (int i = 0; i < actualList.size(); ++i) {
            Object actual = actualList.get(i);
            for (int j : unmatchedExpected) {
                Object expected = expectedList.get(j);
                DiffResult.RepeatedField.PairResult pairResult = this.compareRepeatedFieldElementPair(actual, expected, excludeNonRecursive, fieldDescriptor, i, j, config);
                if (!pairResult.isMatched()) continue;
                builder.addPairResult(pairResult);
                unmatchedActual.remove(i);
                unmatchedExpected.remove(j);
                continue block0;
            }
        }
        for (int i : unmatchedActual) {
            if (ignoreExtraRepeatedFieldElements && !expectedList.isEmpty()) {
                builder.addPairResult(DiffResult.RepeatedField.PairResult.newBuilder().setResult(RecursableDiffEntity.WithResultCode.Result.IGNORED).setActual(actualList.get(i)).setActualFieldIndex(i).setFieldDescriptor(fieldDescriptor).setProtoPrinter(this.protoPrinter).build());
                continue;
            }
            builder.addPairResult(this.compareRepeatedFieldElementPair(actualList.get(i), null, excludeNonRecursive, fieldDescriptor, i, null, config));
        }
        for (int j : unmatchedExpected) {
            builder.addPairResult(this.compareRepeatedFieldElementPair(null, expectedList.get(j), excludeNonRecursive, fieldDescriptor, null, j, config));
        }
        return builder.build();
    }

    private DiffResult.RepeatedField compareRepeatedFieldExpectingSubsequence(List<?> actualList, List<?> expectedList, boolean excludeNonRecursive, Descriptors.FieldDescriptor fieldDescriptor, FluentEqualityConfig config) {
        DiffResult.RepeatedField.Builder builder = DiffResult.RepeatedField.newBuilder().setFieldDescriptor(fieldDescriptor).setActual(actualList).setExpected(expectedList);
        ArrayDeque<Integer> actualIndices = new ArrayDeque<Integer>();
        for (int i = 0; i < actualList.size(); ++i) {
            actualIndices.addLast(i);
        }
        ArrayDeque<Integer> actualNotInOrder = new ArrayDeque<Integer>();
        for (int expectedIndex = 0; expectedIndex < expectedList.size(); ++expectedIndex) {
            Object expected = expectedList.get(expectedIndex);
            DiffResult.RepeatedField.PairResult matchingResult = this.findMatchingPairResult(actualIndices, actualList, expectedIndex, expected, excludeNonRecursive, fieldDescriptor, config);
            if (matchingResult != null) {
                while (!actualIndices.isEmpty() && (Integer)actualIndices.getFirst() < (Integer)matchingResult.actualFieldIndex().get()) {
                    actualNotInOrder.add((Integer)actualIndices.removeFirst());
                }
                builder.addPairResult(matchingResult);
                continue;
            }
            matchingResult = this.findMatchingPairResult(actualNotInOrder, actualList, expectedIndex, expected, excludeNonRecursive, fieldDescriptor, config);
            if (matchingResult != null) {
                matchingResult = matchingResult.toBuilder().setResult(RecursableDiffEntity.WithResultCode.Result.MOVED_OUT_OF_ORDER).build();
                builder.addPairResult(matchingResult);
                continue;
            }
            builder.addPairResult(DiffResult.RepeatedField.PairResult.newBuilder().setResult(RecursableDiffEntity.WithResultCode.Result.REMOVED).setFieldDescriptor(fieldDescriptor).setExpected(expected).setExpectedFieldIndex(expectedIndex).setProtoPrinter(this.protoPrinter).build());
        }
        Iterator iterator = actualNotInOrder.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            builder.addPairResult(DiffResult.RepeatedField.PairResult.newBuilder().setResult(RecursableDiffEntity.WithResultCode.Result.IGNORED).setFieldDescriptor(fieldDescriptor).setActual(actualList.get(index)).setActualFieldIndex(index).setProtoPrinter(this.protoPrinter).build());
        }
        return builder.build();
    }

    private @Nullable DiffResult.RepeatedField.PairResult findMatchingPairResult(Deque<Integer> actualIndices, List<?> actualValues, int expectedIndex, Object expectedValue, boolean excludeNonRecursive, Descriptors.FieldDescriptor fieldDescriptor, FluentEqualityConfig config) {
        Iterator<Integer> actualIndexIter = actualIndices.iterator();
        while (actualIndexIter.hasNext()) {
            int actualIndex = actualIndexIter.next();
            DiffResult.RepeatedField.PairResult pairResult = this.compareRepeatedFieldElementPair(actualValues.get(actualIndex), expectedValue, excludeNonRecursive, fieldDescriptor, actualIndex, expectedIndex, config);
            if (!pairResult.isMatched()) continue;
            actualIndexIter.remove();
            return pairResult;
        }
        return null;
    }

    private DiffResult.RepeatedField.PairResult compareRepeatedFieldElementPair(@Nullable Object actual, @Nullable Object expected, boolean excludeNonRecursive, Descriptors.FieldDescriptor fieldDescriptor, @Nullable Integer actualFieldIndex, @Nullable Integer expectedFieldIndex, FluentEqualityConfig config) {
        DiffResult.SingularField comparison = this.compareSingularValue(actual, expected, null, excludeNonRecursive, fieldDescriptor, "<no field path>", config);
        DiffResult.RepeatedField.PairResult.Builder pairResultBuilder = DiffResult.RepeatedField.PairResult.newBuilder().setResult(comparison.result()).setFieldDescriptor(fieldDescriptor).setProtoPrinter(this.protoPrinter);
        if (actual != null) {
            pairResultBuilder.setActual(actual).setActualFieldIndex(actualFieldIndex);
        }
        if (expected != null) {
            pairResultBuilder.setExpected(expected).setExpectedFieldIndex(expectedFieldIndex);
        }
        if (comparison.breakdown().isPresent()) {
            pairResultBuilder.setBreakdown((DiffResult)comparison.breakdown().get());
        }
        return pairResultBuilder.build();
    }

    private static Set<Integer> setForRange(int max) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (int i = 0; i < max; ++i) {
            set.add(i);
        }
        return set;
    }

    private List<DiffResult.SingularField> compareRepeatedFieldByIndices(List<?> actualList, List<?> expectedList, boolean excludeNonRecursive, Descriptors.FieldDescriptor fieldDescriptor, FluentEqualityConfig config) {
        int maxSize = Math.max(actualList.size(), expectedList.size());
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)maxSize);
        for (int i = 0; i < maxSize; ++i) {
            Object actual = actualList.size() > i ? actualList.get(i) : null;
            Object expected = expectedList.size() > i ? expectedList.get(i) : null;
            builder.add((Object)this.compareSingularValue(actual, expected, null, excludeNonRecursive, fieldDescriptor, ProtoTruthMessageDifferencer.indexedName(fieldDescriptor, i), config));
        }
        return builder.build();
    }

    private DiffResult.SingularField compareSingularValue(@Nullable Object actual, @Nullable Object expected, @Nullable Object defaultValue, boolean excludeNonRecursive, Descriptors.FieldDescriptor fieldDescriptor, String fieldName, FluentEqualityConfig config) {
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            return this.compareSingularMessage((Message)actual, (Message)expected, (Message)defaultValue, excludeNonRecursive, fieldDescriptor, fieldName, config);
        }
        if (excludeNonRecursive) {
            return DiffResult.SingularField.ignored(fieldName);
        }
        return this.compareSingularPrimitive(actual, expected, defaultValue, fieldDescriptor, fieldName, config);
    }

    private <T> T orIfIgnoringFieldAbsence(@Nullable T input, @Nullable T defaultValue, boolean ignoreFieldAbsence) {
        return input == null && ignoreFieldAbsence ? defaultValue : input;
    }

    private static Message orDefaultForType(@Nullable Message input, @Nullable Message other) {
        return input != null ? input : other.getDefaultInstanceForType();
    }

    private DiffResult.SingularField compareSingularMessage(@Nullable Message actual, @Nullable Message expected, @Nullable Message defaultValue, boolean excludeNonRecursive, Descriptors.FieldDescriptor fieldDescriptor, String fieldName, FluentEqualityConfig config) {
        RecursableDiffEntity.WithResultCode.Result.Builder result = RecursableDiffEntity.WithResultCode.Result.builder();
        boolean ignoreFieldAbsence = config.ignoreFieldAbsenceScope().contains(this.rootDescriptor, SubScopeId.of(fieldDescriptor));
        actual = this.orIfIgnoringFieldAbsence(actual, defaultValue, ignoreFieldAbsence);
        expected = this.orIfIgnoringFieldAbsence(expected, defaultValue, ignoreFieldAbsence);
        result.markRemovedIf(actual == null);
        result.markAddedIf(expected == null);
        DiffResult breakdown = null;
        if (result.build() == RecursableDiffEntity.WithResultCode.Result.MATCHED || excludeNonRecursive) {
            breakdown = this.diffMessages(actual = ProtoTruthMessageDifferencer.orDefaultForType(actual, expected), expected = ProtoTruthMessageDifferencer.orDefaultForType(expected, actual), config);
            if (breakdown.isIgnored() && excludeNonRecursive) {
                return DiffResult.SingularField.ignored(fieldName);
            }
            result.markModifiedIf(!breakdown.isMatched());
        }
        DiffResult.SingularField.Builder singularFieldBuilder = DiffResult.SingularField.newBuilder().setSubScopeId(SubScopeId.of(fieldDescriptor)).setFieldName(fieldName).setResult(result.build()).setProtoPrinter(this.protoPrinter);
        if (actual != null) {
            singularFieldBuilder.setActual(actual);
        }
        if (expected != null) {
            singularFieldBuilder.setExpected(expected);
        }
        if (breakdown != null) {
            singularFieldBuilder.setBreakdown(breakdown);
        }
        return singularFieldBuilder.build();
    }

    private DiffResult.SingularField compareSingularPrimitive(@Nullable Object actual, @Nullable Object expected, @Nullable Object defaultValue, Descriptors.FieldDescriptor fieldDescriptor, String fieldName, FluentEqualityConfig config) {
        RecursableDiffEntity.WithResultCode.Result.Builder result = RecursableDiffEntity.WithResultCode.Result.builder();
        SubScopeId subScopeId = SubScopeId.of(fieldDescriptor);
        boolean hasPresence = fieldDescriptor.isRepeated() || fieldDescriptor.hasPresence();
        boolean ignoreFieldAbsence = !hasPresence || config.ignoreFieldAbsenceScope().contains(this.rootDescriptor, subScopeId);
        actual = this.orIfIgnoringFieldAbsence(actual, defaultValue, ignoreFieldAbsence);
        expected = this.orIfIgnoringFieldAbsence(expected, defaultValue, ignoreFieldAbsence);
        result.markRemovedIf(actual == null);
        result.markAddedIf(expected == null);
        if (actual != null && expected != null) {
            if (actual instanceof Double) {
                result.markModifiedIf(!this.doublesEqual((Double)actual, (Double)expected, config.doubleCorrespondenceMap().get(this.rootDescriptor, subScopeId)));
            } else if (actual instanceof Float) {
                result.markModifiedIf(!this.floatsEqual(((Float)actual).floatValue(), ((Float)expected).floatValue(), config.floatCorrespondenceMap().get(this.rootDescriptor, subScopeId)));
            } else {
                result.markModifiedIf(!Objects.equal((Object)actual, (Object)expected));
            }
        }
        DiffResult.SingularField.Builder singularFieldBuilder = DiffResult.SingularField.newBuilder().setSubScopeId(SubScopeId.of(fieldDescriptor)).setFieldName(fieldName).setResult(result.build()).setProtoPrinter(this.protoPrinter);
        if (actual != null) {
            singularFieldBuilder.setActual(actual);
        }
        if (expected != null) {
            singularFieldBuilder.setExpected(expected);
        }
        return singularFieldBuilder.build();
    }

    private boolean doublesEqual(double x, double y, Optional<Correspondence<Number, Number>> correspondence) {
        if (correspondence.isPresent()) {
            return ((Correspondence)correspondence.get()).compare((Object)x, (Object)y);
        }
        return Double.compare(x, y) == 0;
    }

    private boolean floatsEqual(float x, float y, Optional<Correspondence<Number, Number>> correspondence) {
        if (correspondence.isPresent()) {
            return ((Correspondence)correspondence.get()).compare((Object)Float.valueOf(x), (Object)Float.valueOf(y));
        }
        return Float.compare(x, y) == 0;
    }

    private DiffResult.UnknownFieldSetDiff diffUnknowns(UnknownFieldSet actual, UnknownFieldSet expected, FluentEqualityConfig config) {
        DiffResult.UnknownFieldSetDiff.Builder builder = DiffResult.UnknownFieldSetDiff.newBuilder();
        Map actualFields = actual.asMap();
        Map expectedFields = expected.asMap();
        UnmodifiableIterator unmodifiableIterator = Sets.union(actualFields.keySet(), expectedFields.keySet()).iterator();
        while (unmodifiableIterator.hasNext()) {
            int fieldNumber = (Integer)unmodifiableIterator.next();
            UnknownFieldSet.Field actualField = (UnknownFieldSet.Field)actualFields.get(fieldNumber);
            UnknownFieldSet.Field expectedField = (UnknownFieldSet.Field)expectedFields.get(fieldNumber);
            for (UnknownFieldDescriptor.Type type : UnknownFieldDescriptor.Type.all()) {
                List expectedValues;
                List actualValues = actualField != null ? type.getValues(actualField) : Collections.emptyList();
                List<Object> list = expectedValues = expectedField != null ? type.getValues(expectedField) : Collections.emptyList();
                if (actualValues.isEmpty() && expectedValues.isEmpty()) continue;
                UnknownFieldDescriptor unknownFieldDescriptor = UnknownFieldDescriptor.create(fieldNumber, type);
                SubScopeId subScopeId = SubScopeId.of(unknownFieldDescriptor);
                FieldScopeResult compareFields = config.compareFieldsScope().policyFor(this.rootDescriptor, subScopeId);
                if (compareFields == FieldScopeResult.EXCLUDED_RECURSIVELY) {
                    builder.addSingularField(fieldNumber, DiffResult.SingularField.ignored(ProtoTruthMessageDifferencer.name(unknownFieldDescriptor)));
                    continue;
                }
                builder.addAllSingularFields(fieldNumber, this.compareUnknownFieldList(actualValues, expectedValues, compareFields == FieldScopeResult.EXCLUDED_NONRECURSIVELY, unknownFieldDescriptor, config.subScope(this.rootDescriptor, subScopeId)));
            }
        }
        return builder.build();
    }

    private List<DiffResult.SingularField> compareUnknownFieldList(List<?> actualValues, List<?> expectedValues, boolean excludeNonRecursive, UnknownFieldDescriptor unknownFieldDescriptor, FluentEqualityConfig config) {
        int maxSize = Math.max(actualValues.size(), expectedValues.size());
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)maxSize);
        for (int i = 0; i < maxSize; ++i) {
            Object actual = actualValues.size() > i ? actualValues.get(i) : null;
            Object expected = expectedValues.size() > i ? expectedValues.get(i) : null;
            builder.add((Object)this.compareUnknownFieldValue(actual, expected, excludeNonRecursive, unknownFieldDescriptor, ProtoTruthMessageDifferencer.indexedName(unknownFieldDescriptor, i), config));
        }
        return builder.build();
    }

    private DiffResult.SingularField compareUnknownFieldValue(@Nullable Object actual, @Nullable Object expected, boolean excludeNonRecursive, UnknownFieldDescriptor unknownFieldDescriptor, String fieldName, FluentEqualityConfig config) {
        if (unknownFieldDescriptor.type() == UnknownFieldDescriptor.Type.GROUP) {
            return this.compareUnknownFieldSet((UnknownFieldSet)actual, (UnknownFieldSet)expected, excludeNonRecursive, unknownFieldDescriptor, fieldName, config);
        }
        Preconditions.checkState((!excludeNonRecursive ? 1 : 0) != 0, (Object)"excludeNonRecursive is not a valid for primitives.");
        return this.compareUnknownPrimitive(actual, expected, unknownFieldDescriptor, fieldName);
    }

    private DiffResult.SingularField compareUnknownFieldSet(@Nullable UnknownFieldSet actual, @Nullable UnknownFieldSet expected, boolean excludeNonRecursive, UnknownFieldDescriptor unknownFieldDescriptor, String fieldName, FluentEqualityConfig config) {
        RecursableDiffEntity.WithResultCode.Result.Builder result = RecursableDiffEntity.WithResultCode.Result.builder();
        result.markRemovedIf(actual == null);
        result.markAddedIf(expected == null);
        DiffResult.UnknownFieldSetDiff unknownsBreakdown = null;
        if (result.build() == RecursableDiffEntity.WithResultCode.Result.MATCHED || excludeNonRecursive) {
            unknownsBreakdown = this.diffUnknowns(actual = (UnknownFieldSet)MoreObjects.firstNonNull((Object)actual, (Object)UnknownFieldSet.getDefaultInstance()), expected = (UnknownFieldSet)MoreObjects.firstNonNull((Object)expected, (Object)UnknownFieldSet.getDefaultInstance()), config);
            if (unknownsBreakdown.isIgnored() && excludeNonRecursive) {
                return DiffResult.SingularField.ignored(fieldName);
            }
            result.markModifiedIf(!unknownsBreakdown.isMatched());
        }
        DiffResult.SingularField.Builder singularFieldBuilder = DiffResult.SingularField.newBuilder().setSubScopeId(SubScopeId.of(unknownFieldDescriptor)).setFieldName(fieldName).setResult(result.build()).setProtoPrinter(this.protoPrinter);
        if (actual != null) {
            singularFieldBuilder.setActual(actual);
        }
        if (expected != null) {
            singularFieldBuilder.setExpected(expected);
        }
        if (unknownsBreakdown != null) {
            singularFieldBuilder.setUnknownsBreakdown(unknownsBreakdown);
        }
        return singularFieldBuilder.build();
    }

    private DiffResult.SingularField compareUnknownPrimitive(@Nullable Object actual, @Nullable Object expected, UnknownFieldDescriptor unknownFieldDescriptor, String fieldName) {
        RecursableDiffEntity.WithResultCode.Result.Builder result = RecursableDiffEntity.WithResultCode.Result.builder();
        result.markRemovedIf(actual == null);
        result.markAddedIf(expected == null);
        result.markModifiedIf(!Objects.equal((Object)actual, (Object)expected));
        DiffResult.SingularField.Builder singularFieldBuilder = DiffResult.SingularField.newBuilder().setSubScopeId(SubScopeId.of(unknownFieldDescriptor)).setFieldName(fieldName).setResult(result.build()).setProtoPrinter(this.protoPrinter);
        if (actual != null) {
            singularFieldBuilder.setActual(actual);
        }
        if (expected != null) {
            singularFieldBuilder.setExpected(expected);
        }
        return singularFieldBuilder.build();
    }

    private static String name(Descriptors.FieldDescriptor fieldDescriptor) {
        return fieldDescriptor.isExtension() ? "[" + fieldDescriptor + "]" : fieldDescriptor.getName();
    }

    private static String name(UnknownFieldDescriptor unknownFieldDescriptor) {
        return String.valueOf(unknownFieldDescriptor.fieldNumber());
    }

    private static String indexedName(Descriptors.FieldDescriptor fieldDescriptor, Object key, Descriptors.FieldDescriptor keyFieldDescriptor) {
        StringBuilder sb = new StringBuilder();
        try {
            TextFormat.printFieldValue((Descriptors.FieldDescriptor)keyFieldDescriptor, (Object)key, (Appendable)sb);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
        return ProtoTruthMessageDifferencer.name(fieldDescriptor) + "[" + sb + "]";
    }

    private static String indexedName(Descriptors.FieldDescriptor fieldDescriptor, int index) {
        return ProtoTruthMessageDifferencer.name(fieldDescriptor) + "[" + index + "]";
    }

    private static String indexedName(UnknownFieldDescriptor unknownFieldDescriptor, int index) {
        return ProtoTruthMessageDifferencer.name(unknownFieldDescriptor) + "[" + index + "]";
    }
}

