/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.common.collect.Lists;
import com.google.common.truth.extensions.proto.AnyUtils;
import com.google.common.truth.extensions.proto.FieldScope;
import com.google.common.truth.extensions.proto.FieldScopeImpl;
import com.google.common.truth.extensions.proto.FieldScopeUtil;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;

public final class FieldScopes {
    public static FieldScope fromSetFields(Message message) {
        return FieldScopes.fromSetFields(message, AnyUtils.defaultTypeRegistry(), AnyUtils.defaultExtensionRegistry());
    }

    public static FieldScope fromSetFields(Message message, TypeRegistry typeRegistry, ExtensionRegistry extensionRegistry) {
        return FieldScopeImpl.createFromSetFields(message, typeRegistry, extensionRegistry);
    }

    public static FieldScope fromSetFields(Message firstMessage, Message secondMessage, Message ... rest) {
        return FieldScopes.fromSetFields(Lists.asList((Object)firstMessage, (Object)secondMessage, (Object[])rest));
    }

    public static FieldScope fromSetFields(Iterable<? extends Message> messages) {
        return FieldScopes.fromSetFields(messages, AnyUtils.defaultTypeRegistry(), AnyUtils.defaultExtensionRegistry());
    }

    public static FieldScope fromSetFields(Iterable<? extends Message> messages, TypeRegistry typeRegistry, ExtensionRegistry extensionRegistry) {
        return FieldScopeImpl.createFromSetFields(messages, typeRegistry, extensionRegistry);
    }

    public static FieldScope ignoringFields(int firstFieldNumber, int ... rest) {
        return FieldScopeImpl.createIgnoringFields(FieldScopeUtil.asList(firstFieldNumber, rest));
    }

    public static FieldScope ignoringFields(Iterable<Integer> fieldNumbers) {
        return FieldScopeImpl.createIgnoringFields(fieldNumbers);
    }

    public static FieldScope ignoringFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return FieldScopeImpl.createIgnoringFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest));
    }

    public static FieldScope ignoringFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return FieldScopeImpl.createIgnoringFieldDescriptors(fieldDescriptors);
    }

    public static FieldScope allowingFields(int firstFieldNumber, int ... rest) {
        return FieldScopeImpl.createAllowingFields(FieldScopeUtil.asList(firstFieldNumber, rest));
    }

    public static FieldScope allowingFields(Iterable<Integer> fieldNumbers) {
        return FieldScopeImpl.createAllowingFields(fieldNumbers);
    }

    public static FieldScope allowingFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return FieldScopeImpl.createAllowingFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest));
    }

    public static FieldScope allowingFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return FieldScopeImpl.createAllowingFieldDescriptors(fieldDescriptors);
    }

    public static FieldScope all() {
        return FieldScopeImpl.all();
    }

    public static FieldScope none() {
        return FieldScopeImpl.none();
    }

    private FieldScopes() {
    }
}

