/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import com.google.common.truth.extensions.proto.DiffResult;
import com.google.common.truth.extensions.proto.FieldScope;
import com.google.common.truth.extensions.proto.FieldScopeUtil;
import com.google.common.truth.extensions.proto.FluentEqualityConfig;
import com.google.common.truth.extensions.proto.LiteProtoSubject;
import com.google.common.truth.extensions.proto.ProtoFluentAssertion;
import com.google.common.truth.extensions.proto.ProtoTruthMessageDifferencer;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Arrays;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class ProtoSubject<S extends ProtoSubject<S, M>, M extends Message>
extends LiteProtoSubject<S, M>
implements ProtoFluentAssertion {
    private final FluentEqualityConfig config;

    protected ProtoSubject(FailureMetadata failureMetadata, @NullableDecl M message) {
        this(failureMetadata, FluentEqualityConfig.defaultInstance(), message);
    }

    ProtoSubject(FailureMetadata failureMetadata, FluentEqualityConfig config, @NullableDecl M message) {
        super(failureMetadata, message);
        this.config = config;
    }

    ProtoSubject<?, Message> usingConfig(FluentEqualityConfig newConfig) {
        MessageSubject newSubject = (MessageSubject)this.check().about(MessageSubject.messages(newConfig)).that(this.actual());
        if (this.internalCustomName() != null) {
            newSubject = (MessageSubject)newSubject.named(this.internalCustomName(), new Object[0]);
        }
        return newSubject;
    }

    @Override
    public ProtoFluentAssertion ignoringFieldAbsence() {
        return this.usingConfig(this.config.ignoringFieldAbsence());
    }

    @Override
    public ProtoFluentAssertion ignoringRepeatedFieldOrder() {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrder());
    }

    @Override
    public ProtoFluentAssertion ignoringExtraRepeatedFieldElements() {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElements());
    }

    @Override
    public ProtoFluentAssertion usingDoubleTolerance(double tolerance) {
        return this.usingConfig(this.config.usingDoubleTolerance(tolerance));
    }

    @Override
    public ProtoFluentAssertion usingFloatTolerance(float tolerance) {
        return this.usingConfig(this.config.usingFloatTolerance(tolerance));
    }

    @Override
    public ProtoFluentAssertion comparingExpectedFieldsOnly() {
        return this.usingConfig(this.config.comparingExpectedFieldsOnly());
    }

    @Override
    public ProtoFluentAssertion withPartialScope(FieldScope fieldScope) {
        return this.usingConfig(this.config.withPartialScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    @Override
    public ProtoFluentAssertion ignoringFields(int firstFieldNumber, int ... rest) {
        return this.ignoringFields(FieldScopeUtil.asList(firstFieldNumber, rest));
    }

    @Override
    public ProtoFluentAssertion ignoringFields(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringFields(fieldNumbers));
    }

    @Override
    public ProtoFluentAssertion ignoringFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.ignoringFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest));
    }

    @Override
    public ProtoFluentAssertion ignoringFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringFieldDescriptors(fieldDescriptors));
    }

    @Override
    public ProtoFluentAssertion ignoringFieldScope(FieldScope fieldScope) {
        return this.usingConfig(this.config.ignoringFieldScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    @Override
    public ProtoFluentAssertion reportingMismatchesOnly() {
        return this.usingConfig(this.config.reportingMismatchesOnly());
    }

    private static boolean notMessagesWithSameDescriptor(@NullableDecl Message actual, @NullableDecl Object expected) {
        if (actual != null && expected instanceof Message) {
            return actual.getDescriptorForType() != ((Message)expected).getDescriptorForType();
        }
        return true;
    }

    @Override
    public void isEqualTo(@NullableDecl Object expected) {
        if (ProtoSubject.notMessagesWithSameDescriptor((Message)this.actual(), expected)) {
            super.isEqualTo(expected);
        } else {
            DiffResult diffResult = this.makeDifferencer((Message)expected).diffMessages((Message)this.actual(), (Message)expected);
            if (!diffResult.isMatched()) {
                this.failWithRawMessage(this.failureMessage(true) + "\n" + diffResult.printToString(this.config.reportMismatchesOnly()), new Object[0]);
            }
        }
    }

    boolean testIsEqualTo(@NullableDecl Object expected) {
        if (ProtoSubject.notMessagesWithSameDescriptor((Message)this.actual(), expected)) {
            return Objects.equal((Object)this.actual(), (Object)expected);
        }
        return this.makeDifferencer((Message)expected).diffMessages((Message)this.actual(), (Message)expected).isMatched();
    }

    @Override
    public void isNotEqualTo(@NullableDecl Object expected) {
        if (ProtoSubject.notMessagesWithSameDescriptor((Message)this.actual(), expected)) {
            super.isNotEqualTo(expected);
        } else {
            DiffResult diffResult = this.makeDifferencer((Message)expected).diffMessages((Message)this.actual(), (Message)expected);
            if (diffResult.isMatched()) {
                this.failWithRawMessage(this.failureMessage(false) + "\n" + diffResult.printToString(this.config.reportMismatchesOnly()), new Object[0]);
            }
        }
    }

    public void hasAllRequiredFields() {
        if (!((Message)this.actual()).isInitialized()) {
            this.failWithRawMessage("Not true that %s has all required fields set. Missing: %s", new Object[]{this.actualAsString(), ((Message)this.actual()).findInitializationErrors()});
        }
    }

    private ProtoTruthMessageDifferencer makeDifferencer(Message expected) {
        return this.config.withExpectedMessages(Arrays.asList(expected)).toMessageDifferencer(((Message)this.actual()).getDescriptorForType());
    }

    private String failureMessage(boolean expectedEqual) {
        StringBuilder rawMessage = new StringBuilder();
        rawMessage.append("Not true that ");
        if (this.internalCustomName() != null) {
            rawMessage.append(this.internalCustomName()).append(" compares ").append(expectedEqual ? "" : "not ").append("equal. ");
        } else {
            rawMessage.append("messages compare ").append(expectedEqual ? "" : "not ").append("equal. ");
        }
        return rawMessage.toString();
    }

    static final class MessageSubject
    extends ProtoSubject<MessageSubject, Message> {
        static Subject.Factory<MessageSubject, Message> messages(final FluentEqualityConfig config) {
            return new Subject.Factory<MessageSubject, Message>(){

                public MessageSubject createSubject(FailureMetadata failureMetadata, Message actual) {
                    return new MessageSubject(failureMetadata, config, actual);
                }
            };
        }

        MessageSubject(FailureMetadata failureMetadata, @NullableDecl Message message) {
            super(failureMetadata, message);
        }

        private MessageSubject(FailureMetadata failureMetadata, FluentEqualityConfig config, @NullableDecl Message message) {
            super(failureMetadata, config, message);
        }
    }
}

