/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.truth.Correspondence;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.MultimapSubject;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.common.truth.extensions.proto.FieldScope;
import com.google.common.truth.extensions.proto.FieldScopeUtil;
import com.google.common.truth.extensions.proto.FluentEqualityConfig;
import com.google.common.truth.extensions.proto.IterableOfProtosSubject;
import com.google.common.truth.extensions.proto.MultimapWithProtoValuesFluentAssertion;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class MultimapWithProtoValuesSubject<S extends MultimapWithProtoValuesSubject<S, K, M, C>, K, M extends Message, C extends Multimap<K, M>>
extends Subject<S, C> {
    private final FluentEqualityConfig config;

    private static <K, M extends Message> Subject.Factory<MultimapWithMessageValuesSubject<K, M>, Multimap<K, M>> multimapWithMessageValues(final FluentEqualityConfig config) {
        return new Subject.Factory<MultimapWithMessageValuesSubject<K, M>, Multimap<K, M>>(){

            public MultimapWithMessageValuesSubject<K, M> createSubject(FailureMetadata metadata, Multimap<K, M> actual) {
                return new MultimapWithMessageValuesSubject(metadata, config, actual);
            }
        };
    }

    protected MultimapWithProtoValuesSubject(FailureMetadata failureMetadata, @NullableDecl C multimap) {
        this(failureMetadata, FluentEqualityConfig.defaultInstance(), multimap);
    }

    MultimapWithProtoValuesSubject(FailureMetadata failureMetadata, FluentEqualityConfig config, @NullableDecl C multimap) {
        super(failureMetadata, multimap);
        this.config = config;
    }

    private final MultimapSubject delegate() {
        MultimapSubject delegate = this.check().that((Multimap)this.actual());
        if (this.internalCustomName() != null) {
            delegate = (MultimapSubject)delegate.named(this.internalCustomName(), new Object[0]);
        }
        return delegate;
    }

    public void isEmpty() {
        this.delegate().isEmpty();
    }

    public void isNotEmpty() {
        this.delegate().isNotEmpty();
    }

    public void hasSize(int expectedSize) {
        this.delegate().hasSize(expectedSize);
    }

    public void containsKey(@NullableDecl Object key) {
        this.delegate().containsKey(key);
    }

    public void doesNotContainKey(@NullableDecl Object key) {
        this.delegate().doesNotContainKey(key);
    }

    public void containsEntry(@NullableDecl Object key, @NullableDecl Object value) {
        this.delegate().containsEntry(key, value);
    }

    public void doesNotContainEntry(@NullableDecl Object key, @NullableDecl Object value) {
        this.delegate().doesNotContainEntry(key, value);
    }

    static <M extends Message> Subject.Factory<IterableValuesForKey<M>, Iterable<M>> iterableOfProtos(final String stringRepresentation) {
        return new Subject.Factory<IterableValuesForKey<M>, Iterable<M>>(){

            public IterableValuesForKey<M> createSubject(FailureMetadata metadata, Iterable<M> actual) {
                return new IterableValuesForKey(metadata, actual, stringRepresentation);
            }
        };
    }

    public IterableOfProtosSubject<?, M, Iterable<M>> valuesForKey(@NullableDecl Object key) {
        Subject.Factory<IterableValuesForKey<M>, Iterable<M>> factory = MultimapWithProtoValuesSubject.iterableOfProtos("Values for key <" + key + "> (<" + this.actual() + ">) in " + this.actualAsString());
        return (IterableOfProtosSubject)this.check().about(factory).that((Object)((Multimap)this.actual()).get(key));
    }

    @CanIgnoreReturnValue
    public Ordered containsExactlyEntriesIn(Multimap<?, ?> expectedMultimap) {
        return this.delegate().containsExactlyEntriesIn(expectedMultimap);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly(@NullableDecl Object k0, @NullableDecl Object v0, Object ... rest) {
        return this.delegate().containsExactly(k0, v0, rest);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly() {
        return this.delegate().containsExactly();
    }

    public <A, E> MultimapSubject.UsingCorrespondence<A, E> comparingValuesUsing(Correspondence<A, E> correspondence) {
        return this.delegate().comparingValuesUsing(correspondence);
    }

    MultimapWithProtoValuesFluentAssertion<M> usingConfig(FluentEqualityConfig newConfig) {
        Subject.Factory<MultimapWithMessageValuesSubject<K, M>, Multimap<K, M>> factory = MultimapWithProtoValuesSubject.multimapWithMessageValues(newConfig);
        MultimapWithMessageValuesSubject newSubject = (MultimapWithMessageValuesSubject)this.check().about(factory).that(this.actual());
        if (this.internalCustomName() != null) {
            newSubject = (MultimapWithMessageValuesSubject)newSubject.named(this.internalCustomName(), new Object[0]);
        }
        return new MultimapWithProtoValuesFluentAssertionImpl(newSubject);
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceForValues() {
        return this.usingConfig(this.config.ignoringFieldAbsence());
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderForValues() {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrder());
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsForValues() {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElements());
    }

    public MultimapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForValues(double tolerance) {
        return this.usingConfig(this.config.usingDoubleTolerance(tolerance));
    }

    public MultimapWithProtoValuesFluentAssertion<M> usingFloatToleranceForValues(float tolerance) {
        return this.usingConfig(this.config.usingFloatTolerance(tolerance));
    }

    public MultimapWithProtoValuesFluentAssertion<M> comparingExpectedFieldsOnlyForValues() {
        return this.usingConfig(this.config.comparingExpectedFieldsOnly());
    }

    public MultimapWithProtoValuesFluentAssertion<M> withPartialScopeForValues(FieldScope fieldScope) {
        return this.usingConfig(this.config.withPartialScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(int firstFieldNumber, int ... rest) {
        return this.ignoringFieldsForValues(FieldScopeUtil.asList(firstFieldNumber, rest));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringFields(fieldNumbers));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.ignoringFieldDescriptorsForValues(Lists.asList((Object)firstFieldDescriptor, (Object[])rest));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringFieldDescriptors(fieldDescriptors));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldScopeForValues(FieldScope fieldScope) {
        return this.usingConfig(this.config.ignoringFieldScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    public MultimapWithProtoValuesFluentAssertion<M> reportingMismatchesOnlyForValues() {
        return this.usingConfig(this.config.reportingMismatchesOnly());
    }

    private MultimapSubject.UsingCorrespondence<M, M> usingCorrespondence(Iterable<? extends M> expectedValues) {
        return this.comparingValuesUsing(this.config.withExpectedMessages(expectedValues).toCorrespondence(FieldScopeUtil.getSingleDescriptor(((Multimap)this.actual()).values())));
    }

    private static final class MultimapWithProtoValuesFluentAssertionImpl<M extends Message>
    implements MultimapWithProtoValuesFluentAssertion<M> {
        private final MultimapWithProtoValuesSubject<?, ?, M, ?> subject;

        MultimapWithProtoValuesFluentAssertionImpl(MultimapWithProtoValuesSubject<?, ?, M, ?> subject) {
            this.subject = subject;
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceForValues() {
            return this.subject.ignoringFieldAbsenceForValues();
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderForValues() {
            return this.subject.ignoringRepeatedFieldOrderForValues();
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsForValues() {
            return this.subject.ignoringExtraRepeatedFieldElementsForValues();
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForValues(double tolerance) {
            return this.subject.usingDoubleToleranceForValues(tolerance);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> usingFloatToleranceForValues(float tolerance) {
            return this.subject.usingFloatToleranceForValues(tolerance);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> comparingExpectedFieldsOnlyForValues() {
            return this.subject.comparingExpectedFieldsOnlyForValues();
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> withPartialScopeForValues(FieldScope fieldScope) {
            return this.subject.withPartialScopeForValues(fieldScope);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(int firstFieldNumber, int ... rest) {
            return this.subject.ignoringFieldsForValues(firstFieldNumber, rest);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(Iterable<Integer> fieldNumbers) {
            return this.subject.ignoringFieldsForValues(fieldNumbers);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.ignoringFieldDescriptorsForValues(firstFieldDescriptor, rest);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.ignoringFieldDescriptorsForValues(fieldDescriptors);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldScopeForValues(FieldScope fieldScope) {
            return this.subject.ignoringFieldScopeForValues(fieldScope);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> reportingMismatchesOnlyForValues() {
            return this.subject.reportingMismatchesOnlyForValues();
        }

        @Override
        public void containsEntry(@NullableDecl Object expectedKey, @NullableDecl M expectedValue) {
            ((MultimapWithProtoValuesSubject)this.subject).usingCorrespondence(Arrays.asList(expectedValue)).containsEntry(expectedKey, expectedValue);
        }

        @Override
        public void doesNotContainEntry(@NullableDecl Object excludedKey, @NullableDecl M excludedValue) {
            ((MultimapWithProtoValuesSubject)this.subject).usingCorrespondence(Arrays.asList(excludedValue)).doesNotContainEntry(excludedKey, excludedValue);
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsExactlyEntriesIn(Multimap<?, ? extends M> expectedMap) {
            return ((MultimapWithProtoValuesSubject)this.subject).usingCorrespondence(expectedMap.values()).containsExactlyEntriesIn(expectedMap);
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsExactly() {
            return ((MultimapWithProtoValuesSubject)this.subject).usingCorrespondence(Collections.emptyList()).containsExactly();
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsExactly(@NullableDecl Object k0, @NullableDecl M v0, Object ... rest) {
            ArrayList<Object> expectedValues = new ArrayList<Object>();
            expectedValues.add(v0);
            for (int i = 1; i < rest.length; i += 2) {
                expectedValues.add((Message)rest[i]);
            }
            return ((MultimapWithProtoValuesSubject)this.subject).usingCorrespondence(expectedValues).containsExactly(k0, v0, rest);
        }

        @Override
        @Deprecated
        public boolean equals(Object o) {
            return this.subject.equals(o);
        }

        @Override
        @Deprecated
        public int hashCode() {
            return this.subject.hashCode();
        }
    }

    private static class IterableValuesForKey<M extends Message>
    extends IterableOfProtosSubject<IterableValuesForKey<M>, M, Iterable<M>> {
        private final String stringRepresentation;

        IterableValuesForKey(FailureMetadata failureMetadata, Iterable<M> actual, String stringRepresentation) {
            super(failureMetadata, actual);
            this.stringRepresentation = stringRepresentation;
        }

        protected String actualCustomStringRepresentation() {
            return this.stringRepresentation;
        }
    }

    public static class MultimapWithMessageValuesSubject<K, M extends Message>
    extends MultimapWithProtoValuesSubject<MultimapWithMessageValuesSubject<K, M>, K, M, Multimap<K, M>> {
        MultimapWithMessageValuesSubject(FailureMetadata failureMetadata, @NullableDecl Multimap<K, M> multimap) {
            super(failureMetadata, multimap);
        }

        private MultimapWithMessageValuesSubject(FailureMetadata failureMetadata, FluentEqualityConfig config, @NullableDecl Multimap<K, M> multimap) {
            super(failureMetadata, config, multimap);
        }
    }
}

