/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.truth.Correspondence;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.MapSubject;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.common.truth.extensions.proto.FieldScope;
import com.google.common.truth.extensions.proto.FieldScopeUtil;
import com.google.common.truth.extensions.proto.FluentEqualityConfig;
import com.google.common.truth.extensions.proto.MapWithProtoValuesFluentAssertion;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class MapWithProtoValuesSubject<S extends MapWithProtoValuesSubject<S, K, M, C>, K, M extends Message, C extends Map<K, M>>
extends Subject<S, C> {
    private final FluentEqualityConfig config;

    protected MapWithProtoValuesSubject(FailureMetadata failureMetadata, @NullableDecl C map) {
        this(failureMetadata, FluentEqualityConfig.defaultInstance(), map);
    }

    MapWithProtoValuesSubject(FailureMetadata failureMetadata, FluentEqualityConfig config, @NullableDecl C map) {
        super(failureMetadata, map);
        this.config = config;
    }

    private static <M extends Message, K> Subject.Factory<MapWithMessageValuesSubject<K, M>, Map<K, M>> mapWithProtoValues(final FluentEqualityConfig config) {
        return new Subject.Factory<MapWithMessageValuesSubject<K, M>, Map<K, M>>(){

            public MapWithMessageValuesSubject<K, M> createSubject(FailureMetadata metadata, Map<K, M> actual) {
                return new MapWithMessageValuesSubject(metadata, config, actual);
            }
        };
    }

    private final MapSubject delegate() {
        MapSubject delegate = this.check().that((Map)this.actual());
        if (this.internalCustomName() != null) {
            delegate = (MapSubject)delegate.named(this.internalCustomName(), new Object[0]);
        }
        return delegate;
    }

    public void isEqualTo(@NullableDecl Object other) {
        this.delegate().isEqualTo(other);
    }

    public void isEmpty() {
        this.delegate().isEmpty();
    }

    public void isNotEmpty() {
        this.delegate().isNotEmpty();
    }

    public void hasSize(int expectedSize) {
        this.delegate().hasSize(expectedSize);
    }

    public void containsKey(@NullableDecl Object key) {
        this.delegate().containsKey(key);
    }

    public void doesNotContainKey(@NullableDecl Object key) {
        this.delegate().doesNotContainKey(key);
    }

    public void containsEntry(@NullableDecl Object key, @NullableDecl Object value) {
        this.delegate().containsEntry(key, value);
    }

    public void doesNotContainEntry(@NullableDecl Object key, @NullableDecl Object value) {
        this.delegate().doesNotContainEntry(key, value);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly() {
        return this.delegate().containsExactly();
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly(@NullableDecl Object k0, @NullableDecl Object v0, Object ... rest) {
        return this.delegate().containsExactly(k0, v0, rest);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactlyEntriesIn(Map<?, ?> expectedMap) {
        return this.delegate().containsExactlyEntriesIn(expectedMap);
    }

    public <A, E> MapSubject.UsingCorrespondence<A, E> comparingValuesUsing(Correspondence<A, E> correspondence) {
        return this.delegate().comparingValuesUsing(correspondence);
    }

    MapWithProtoValuesFluentAssertion<M> usingConfig(FluentEqualityConfig newConfig) {
        Subject.Factory<MapWithMessageValuesSubject<K, M>, Map<K, M>> factory = MapWithProtoValuesSubject.mapWithProtoValues(newConfig);
        MapWithMessageValuesSubject newSubject = (MapWithMessageValuesSubject)this.check().about(factory).that(this.actual());
        if (this.internalCustomName() != null) {
            newSubject = (MapWithMessageValuesSubject)newSubject.named(this.internalCustomName(), new Object[0]);
        }
        return new MapWithProtoValuesFluentAssertionImpl(newSubject);
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceForValues() {
        return this.usingConfig(this.config.ignoringFieldAbsence());
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderForValues() {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrder());
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsForValues() {
        return this.usingConfig(this.config.ignoringExtraRepeatedFieldElements());
    }

    public MapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForValues(double tolerance) {
        return this.usingConfig(this.config.usingDoubleTolerance(tolerance));
    }

    public MapWithProtoValuesFluentAssertion<M> usingFloatToleranceForValues(float tolerance) {
        return this.usingConfig(this.config.usingFloatTolerance(tolerance));
    }

    public MapWithProtoValuesFluentAssertion<M> comparingExpectedFieldsOnlyForValues() {
        return this.usingConfig(this.config.comparingExpectedFieldsOnly());
    }

    public MapWithProtoValuesFluentAssertion<M> withPartialScopeForValues(FieldScope fieldScope) {
        return this.usingConfig(this.config.withPartialScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(int firstFieldNumber, int ... rest) {
        return this.ignoringFieldsForValues(FieldScopeUtil.asList(firstFieldNumber, rest));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringFields(fieldNumbers));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.ignoringFieldDescriptorsForValues(Lists.asList((Object)firstFieldDescriptor, (Object[])rest));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringFieldDescriptors(fieldDescriptors));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldScopeForValues(FieldScope fieldScope) {
        return this.usingConfig(this.config.ignoringFieldScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    public MapWithProtoValuesFluentAssertion<M> reportingMismatchesOnlyForValues() {
        return this.usingConfig(this.config.reportingMismatchesOnly());
    }

    private MapSubject.UsingCorrespondence<M, M> usingCorrespondence(Iterable<? extends M> expectedValues) {
        return this.comparingValuesUsing(this.config.withExpectedMessages(expectedValues).toCorrespondence(FieldScopeUtil.getSingleDescriptor(((Map)this.actual()).values())));
    }

    private static final class MapWithProtoValuesFluentAssertionImpl<M extends Message>
    implements MapWithProtoValuesFluentAssertion<M> {
        private final MapWithProtoValuesSubject<?, ?, M, ?> subject;

        MapWithProtoValuesFluentAssertionImpl(MapWithProtoValuesSubject<?, ?, M, ?> subject) {
            this.subject = subject;
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceForValues() {
            return this.subject.ignoringFieldAbsenceForValues();
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderForValues() {
            return this.subject.ignoringRepeatedFieldOrderForValues();
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringExtraRepeatedFieldElementsForValues() {
            return this.subject.ignoringExtraRepeatedFieldElementsForValues();
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> usingDoubleToleranceForValues(double tolerance) {
            return this.subject.usingDoubleToleranceForValues(tolerance);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> comparingExpectedFieldsOnlyForValues() {
            return this.subject.comparingExpectedFieldsOnlyForValues();
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> usingFloatToleranceForValues(float tolerance) {
            return this.subject.usingFloatToleranceForValues(tolerance);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> withPartialScopeForValues(FieldScope fieldScope) {
            return this.subject.withPartialScopeForValues(fieldScope);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(int firstFieldNumber, int ... rest) {
            return this.subject.ignoringFieldsForValues(firstFieldNumber, rest);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(Iterable<Integer> fieldNumbers) {
            return this.subject.ignoringFieldsForValues(fieldNumbers);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.ignoringFieldDescriptorsForValues(firstFieldDescriptor, rest);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.ignoringFieldDescriptorsForValues(fieldDescriptors);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldScopeForValues(FieldScope fieldScope) {
            return this.subject.ignoringFieldScopeForValues(fieldScope);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> reportingMismatchesOnlyForValues() {
            return this.subject.reportingMismatchesOnlyForValues();
        }

        @Override
        public void containsEntry(@NullableDecl Object expectedKey, @NullableDecl M expectedValue) {
            ((MapWithProtoValuesSubject)this.subject).usingCorrespondence(Arrays.asList(expectedValue)).containsEntry(expectedKey, expectedValue);
        }

        @Override
        public void doesNotContainEntry(@NullableDecl Object excludedKey, @NullableDecl M excludedValue) {
            ((MapWithProtoValuesSubject)this.subject).usingCorrespondence(Arrays.asList(excludedValue)).doesNotContainEntry(excludedKey, excludedValue);
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsExactly(@NullableDecl Object k0, @NullableDecl M v0, Object ... rest) {
            ArrayList<Object> expectedValues = new ArrayList<Object>();
            expectedValues.add(v0);
            for (int i = 1; i < rest.length; i += 2) {
                expectedValues.add((Message)rest[i]);
            }
            return ((MapWithProtoValuesSubject)this.subject).usingCorrespondence(expectedValues).containsExactly(k0, v0, rest);
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsExactlyEntriesIn(Map<?, ? extends M> expectedMap) {
            return ((MapWithProtoValuesSubject)this.subject).usingCorrespondence(expectedMap.values()).containsExactlyEntriesIn(expectedMap);
        }

        @Override
        @Deprecated
        public boolean equals(Object o) {
            return this.subject.equals(o);
        }

        @Override
        @Deprecated
        public int hashCode() {
            return this.subject.hashCode();
        }
    }

    public static final class MapWithMessageValuesSubject<K, M extends Message>
    extends MapWithProtoValuesSubject<MapWithMessageValuesSubject<K, M>, K, M, Map<K, M>> {
        MapWithMessageValuesSubject(FailureMetadata failureMetadata, @NullableDecl Map<K, M> map) {
            super(failureMetadata, map);
        }

        private MapWithMessageValuesSubject(FailureMetadata failureMetadata, FluentEqualityConfig config, @NullableDecl Map<K, M> map) {
            super(failureMetadata, config, map);
        }
    }
}

