/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.auto.value.AutoValue;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Correspondence;
import com.google.common.truth.extensions.proto.AutoValue_FluentEqualityConfig;
import com.google.common.truth.extensions.proto.FieldScope;
import com.google.common.truth.extensions.proto.FieldScopeLogic;
import com.google.common.truth.extensions.proto.FieldScopeUtil;
import com.google.common.truth.extensions.proto.FieldScopes;
import com.google.common.truth.extensions.proto.ProtoTruth;
import com.google.common.truth.extensions.proto.ProtoTruthMessageDifferencer;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@AutoValue
abstract class FluentEqualityConfig {
    private static final FluentEqualityConfig DEFAULT_INSTANCE = new AutoValue_FluentEqualityConfig.Builder().setIgnoreFieldAbsence(false).setIgnoreRepeatedFieldOrder(false).setIgnoreExtraRepeatedFieldElements(false).setCompareExpectedFieldsOnly(false).setFieldScopeLogic(FieldScopeLogic.all()).setReportMismatchesOnly(false).setUsingCorrespondenceStringFunction((Function<? super Optional<Descriptors.Descriptor>, String>)Functions.constant((Object)"")).build();
    private final LoadingCache<Descriptors.Descriptor, ProtoTruthMessageDifferencer> messageDifferencers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Descriptors.Descriptor, ProtoTruthMessageDifferencer>(){

        public ProtoTruthMessageDifferencer load(Descriptors.Descriptor descriptor) {
            return ProtoTruthMessageDifferencer.create(FluentEqualityConfig.this, descriptor);
        }
    });

    FluentEqualityConfig() {
    }

    static FluentEqualityConfig defaultInstance() {
        return DEFAULT_INSTANCE;
    }

    abstract boolean ignoreFieldAbsence();

    abstract boolean ignoreRepeatedFieldOrder();

    abstract boolean ignoreExtraRepeatedFieldElements();

    abstract Optional<Correspondence<Number, Number>> doubleCorrespondence();

    abstract Optional<Correspondence<Number, Number>> floatCorrespondence();

    abstract boolean compareExpectedFieldsOnly();

    abstract Optional<ImmutableList<Message>> expectedMessages();

    abstract FieldScopeLogic fieldScopeLogic();

    abstract boolean reportMismatchesOnly();

    abstract Function<? super Optional<Descriptors.Descriptor>, String> usingCorrespondenceStringFunction();

    final String usingCorrespondenceString(Optional<Descriptors.Descriptor> descriptor) {
        return (String)this.usingCorrespondenceStringFunction().apply(descriptor);
    }

    final FluentEqualityConfig ignoringFieldAbsence() {
        return this.toBuilder().setIgnoreFieldAbsence(true).addUsingCorrespondenceString(".ignoringFieldAbsence()").build();
    }

    final FluentEqualityConfig ignoringRepeatedFieldOrder() {
        return this.toBuilder().setIgnoreRepeatedFieldOrder(true).addUsingCorrespondenceString(".ignoringRepeatedFieldOrder()").build();
    }

    final FluentEqualityConfig ignoringExtraRepeatedFieldElements() {
        return this.toBuilder().setIgnoreExtraRepeatedFieldElements(true).addUsingCorrespondenceString(".ignoringExtraRepeatedFieldElements()").build();
    }

    final FluentEqualityConfig usingDoubleTolerance(double tolerance) {
        return this.toBuilder().setDoubleCorrespondence((Correspondence<Number, Number>)Correspondence.tolerance((double)tolerance)).addUsingCorrespondenceString(".usingDoubleTolerance(" + tolerance + ")").build();
    }

    final FluentEqualityConfig usingFloatTolerance(float tolerance) {
        return this.toBuilder().setFloatCorrespondence((Correspondence<Number, Number>)Correspondence.tolerance((double)tolerance)).addUsingCorrespondenceString(".usingFloatTolerance(" + tolerance + ")").build();
    }

    final FluentEqualityConfig comparingExpectedFieldsOnly() {
        return this.toBuilder().setCompareExpectedFieldsOnly(true).addUsingCorrespondenceString(".comparingExpectedFieldsOnly()").build();
    }

    final FluentEqualityConfig withExpectedMessages(Iterable<? extends Message> messages) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (Message message : messages) {
            if (message == null) continue;
            listBuilder.add((Object)message);
        }
        Builder builder = this.toBuilder().setExpectedMessages((ImmutableList<Message>)listBuilder.build());
        if (this.compareExpectedFieldsOnly()) {
            builder.setFieldScopeLogic(FieldScopeLogic.and(this.fieldScopeLogic(), FieldScopes.fromSetFields(messages).logic()));
        }
        return builder.build();
    }

    final FluentEqualityConfig withPartialScope(FieldScope partialScope) {
        return this.toBuilder().setFieldScopeLogic(FieldScopeLogic.and(this.fieldScopeLogic(), partialScope.logic())).addUsingCorrespondenceFieldScopeString(".withPartialScope(%s)", partialScope).build();
    }

    final FluentEqualityConfig ignoringFields(Iterable<Integer> fieldNumbers) {
        return this.toBuilder().setFieldScopeLogic(this.fieldScopeLogic().ignoringFields(fieldNumbers)).addUsingCorrespondenceFieldNumbersString(".ignoringFields(%s)", fieldNumbers).build();
    }

    final FluentEqualityConfig ignoringFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.toBuilder().setFieldScopeLogic(this.fieldScopeLogic().ignoringFieldDescriptors(fieldDescriptors)).addUsingCorrespondenceFieldDescriptorsString(".ignoringFieldDescriptors(%s)", fieldDescriptors).build();
    }

    final FluentEqualityConfig ignoringFieldScope(FieldScope fieldScope) {
        return this.toBuilder().setFieldScopeLogic(FieldScopeLogic.and(this.fieldScopeLogic(), FieldScopeLogic.not(fieldScope.logic()))).addUsingCorrespondenceFieldScopeString(".ignoringFieldScope(%s)", fieldScope).build();
    }

    final FluentEqualityConfig reportingMismatchesOnly() {
        return this.toBuilder().setReportMismatchesOnly(true).addUsingCorrespondenceString(".reportingMismatchesOnly()").build();
    }

    final ProtoTruthMessageDifferencer toMessageDifferencer(Descriptors.Descriptor descriptor) {
        Preconditions.checkState((boolean)this.expectedMessages().isPresent(), (Object)"expectedMessages() not set");
        return (ProtoTruthMessageDifferencer)this.messageDifferencers.getUnchecked((Object)descriptor);
    }

    final <M extends Message> Correspondence<M, M> toCorrespondence(final Optional<Descriptors.Descriptor> optDescriptor) {
        Preconditions.checkState((boolean)this.expectedMessages().isPresent(), (Object)"expectedMessages() not set");
        return new Correspondence<M, M>(){

            public final boolean compare(@NullableDecl M actual, @NullableDecl M expected) {
                return ProtoTruth.assertThat(actual).usingConfig(FluentEqualityConfig.this).testIsEqualTo(expected);
            }

            public final String formatDiff(@NullableDecl M actual, @NullableDecl M expected) {
                if (actual == null || expected == null) {
                    return "";
                }
                return FluentEqualityConfig.this.toMessageDifferencer(actual.getDescriptorForType()).diffMessages((Message)actual, (Message)expected).printToString(FluentEqualityConfig.this.reportMismatchesOnly());
            }

            public final String toString() {
                return "is equivalent according to assertThat(proto)" + FluentEqualityConfig.this.usingCorrespondenceString((Optional<Descriptors.Descriptor>)optDescriptor) + ".isEqualTo(target) to";
            }
        };
    }

    abstract Builder toBuilder();

    @CanIgnoreReturnValue
    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setIgnoreFieldAbsence(boolean var1);

        abstract Builder setIgnoreRepeatedFieldOrder(boolean var1);

        abstract Builder setIgnoreExtraRepeatedFieldElements(boolean var1);

        abstract Builder setDoubleCorrespondence(Correspondence<Number, Number> var1);

        abstract Builder setFloatCorrespondence(Correspondence<Number, Number> var1);

        abstract Builder setCompareExpectedFieldsOnly(boolean var1);

        abstract Builder setExpectedMessages(ImmutableList<Message> var1);

        abstract Builder setFieldScopeLogic(FieldScopeLogic var1);

        abstract Builder setReportMismatchesOnly(boolean var1);

        @CheckReturnValue
        abstract Function<? super Optional<Descriptors.Descriptor>, String> usingCorrespondenceStringFunction();

        abstract Builder setUsingCorrespondenceStringFunction(Function<? super Optional<Descriptors.Descriptor>, String> var1);

        abstract FluentEqualityConfig build();

        final Builder addUsingCorrespondenceString(String string) {
            return this.setUsingCorrespondenceStringFunction(FieldScopeUtil.concat(this.usingCorrespondenceStringFunction(), (Function<? super Optional<Descriptors.Descriptor>, String>)Functions.constant((Object)string)));
        }

        final Builder addUsingCorrespondenceFieldNumbersString(String fmt, Iterable<Integer> fieldNumbers) {
            return this.setUsingCorrespondenceStringFunction(FieldScopeUtil.concat(this.usingCorrespondenceStringFunction(), FieldScopeUtil.fieldNumbersFunction(fmt, fieldNumbers)));
        }

        final Builder addUsingCorrespondenceFieldDescriptorsString(String fmt, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.setUsingCorrespondenceStringFunction(FieldScopeUtil.concat(this.usingCorrespondenceStringFunction(), (Function<? super Optional<Descriptors.Descriptor>, String>)Functions.constant((Object)String.format(fmt, FieldScopeUtil.join(fieldDescriptors)))));
        }

        final Builder addUsingCorrespondenceFieldScopeString(String fmt, FieldScope fieldScope) {
            return this.setUsingCorrespondenceStringFunction(FieldScopeUtil.concat(this.usingCorrespondenceStringFunction(), FieldScopeUtil.fieldScopeFunction(fmt, fieldScope)));
        }
    }
}

