/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.truth.extensions.proto.FieldDescriptorOrUnknown;
import com.google.common.truth.extensions.proto.FieldNumberTree;
import com.google.common.truth.extensions.proto.FieldScopeUtil;
import com.google.common.truth.extensions.proto.ProtoTruthMessageDifferencer;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.List;

abstract class FieldScopeLogic {
    private static final FieldScopeLogic ALL = new FieldScopeLogic(){

        @Override
        public String toString() {
            return "FieldScopes.all()";
        }

        @Override
        final ProtoTruthMessageDifferencer.ShouldIgnore shouldIgnore(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            return ProtoTruthMessageDifferencer.ShouldIgnore.NO_RECURSIVE;
        }
    };
    private static final FieldScopeLogic NONE = new FieldScopeLogic(){

        @Override
        public String toString() {
            return "FieldScopes.none()";
        }

        @Override
        final ProtoTruthMessageDifferencer.ShouldIgnore shouldIgnore(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            return ProtoTruthMessageDifferencer.ShouldIgnore.YES_RECURSIVE;
        }
    };

    FieldScopeLogic() {
    }

    abstract ProtoTruthMessageDifferencer.ShouldIgnore shouldIgnore(Descriptors.Descriptor var1, FieldDescriptorOrUnknown var2);

    final FieldScopeLogic subLogic(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
        ProtoTruthMessageDifferencer.ShouldIgnore shouldIgnore = this.shouldIgnore(rootDescriptor, fieldDescriptorOrUnknown);
        if (shouldIgnore.recursive()) {
            return shouldIgnore.shouldIgnore() ? FieldScopeLogic.none() : FieldScopeLogic.all();
        }
        return this.subLogicImpl(rootDescriptor, fieldDescriptorOrUnknown);
    }

    FieldScopeLogic subLogicImpl(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
        throw new UnsupportedOperationException("subLogicImpl not implemented for " + this.getClass());
    }

    public abstract String toString();

    void validate(Descriptors.Descriptor descriptor) {
    }

    private static boolean isEmpty(Iterable<?> container) {
        boolean isEmpty = true;
        for (Object element : container) {
            Preconditions.checkNotNull(element);
            isEmpty = false;
        }
        return isEmpty;
    }

    FieldScopeLogic ignoringFields(Iterable<Integer> fieldNumbers) {
        if (FieldScopeLogic.isEmpty(fieldNumbers)) {
            return this;
        }
        return FieldScopeLogic.and(this, new NegationFieldScopeLogic(new FieldNumbersLogic(fieldNumbers)));
    }

    FieldScopeLogic ignoringFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        if (FieldScopeLogic.isEmpty(fieldDescriptors)) {
            return this;
        }
        return FieldScopeLogic.and(this, new NegationFieldScopeLogic(new FieldDescriptorsLogic(fieldDescriptors)));
    }

    FieldScopeLogic allowingFields(Iterable<Integer> fieldNumbers) {
        if (FieldScopeLogic.isEmpty(fieldNumbers)) {
            return this;
        }
        return FieldScopeLogic.or(this, new FieldNumbersLogic(fieldNumbers));
    }

    FieldScopeLogic allowingFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        if (FieldScopeLogic.isEmpty(fieldDescriptors)) {
            return this;
        }
        return FieldScopeLogic.or(this, new FieldDescriptorsLogic(fieldDescriptors));
    }

    static FieldScopeLogic all() {
        return ALL;
    }

    static FieldScopeLogic none() {
        return NONE;
    }

    static FieldScopeLogic partialScope(Message message) {
        return new RootPartialScopeLogic(message);
    }

    static FieldScopeLogic and(FieldScopeLogic fieldScopeLogic1, FieldScopeLogic fieldScopeLogic2) {
        return new IntersectionFieldScopeLogic(fieldScopeLogic1, fieldScopeLogic2);
    }

    static FieldScopeLogic or(FieldScopeLogic fieldScopeLogic1, FieldScopeLogic fieldScopeLogic2) {
        return new UnionFieldScopeLogic(fieldScopeLogic1, fieldScopeLogic2);
    }

    static FieldScopeLogic not(FieldScopeLogic fieldScopeLogic) {
        return new NegationFieldScopeLogic(fieldScopeLogic);
    }

    private static final class NegationFieldScopeLogic
    extends CompoundFieldScopeLogic<NegationFieldScopeLogic> {
        NegationFieldScopeLogic(FieldScopeLogic subject) {
            super(subject);
        }

        @Override
        NegationFieldScopeLogic newLogicOfSameType(List<FieldScopeLogic> newElements) {
            Preconditions.checkArgument((newElements.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 element: %s", newElements);
            return new NegationFieldScopeLogic(newElements.get(0));
        }

        @Override
        ProtoTruthMessageDifferencer.ShouldIgnore shouldIgnore(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            ProtoTruthMessageDifferencer.ShouldIgnore op = ((FieldScopeLogic)this.elements.get(0)).shouldIgnore(rootDescriptor, fieldDescriptorOrUnknown);
            return ProtoTruthMessageDifferencer.ShouldIgnore.of(!op.shouldIgnore(), op.recursive());
        }

        @Override
        public String toString() {
            return String.format("!(%s)", this.elements.get(0));
        }
    }

    private static final class UnionFieldScopeLogic
    extends CompoundFieldScopeLogic<UnionFieldScopeLogic> {
        UnionFieldScopeLogic(FieldScopeLogic subject1, FieldScopeLogic subject2) {
            super(subject1, subject2);
        }

        @Override
        UnionFieldScopeLogic newLogicOfSameType(List<FieldScopeLogic> newElements) {
            Preconditions.checkArgument((newElements.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 elements: %s", newElements);
            return new UnionFieldScopeLogic(newElements.get(0), newElements.get(1));
        }

        @Override
        ProtoTruthMessageDifferencer.ShouldIgnore shouldIgnore(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            return UnionFieldScopeLogic.union(((FieldScopeLogic)this.elements.get(0)).shouldIgnore(rootDescriptor, fieldDescriptorOrUnknown), ((FieldScopeLogic)this.elements.get(1)).shouldIgnore(rootDescriptor, fieldDescriptorOrUnknown));
        }

        private static ProtoTruthMessageDifferencer.ShouldIgnore union(ProtoTruthMessageDifferencer.ShouldIgnore op1, ProtoTruthMessageDifferencer.ShouldIgnore op2) {
            if (op1 == ProtoTruthMessageDifferencer.ShouldIgnore.NO_RECURSIVE || op2 == ProtoTruthMessageDifferencer.ShouldIgnore.NO_RECURSIVE) {
                return ProtoTruthMessageDifferencer.ShouldIgnore.NO_RECURSIVE;
            }
            if (!op1.shouldIgnore() || !op2.shouldIgnore()) {
                return ProtoTruthMessageDifferencer.ShouldIgnore.NO_NONRECURSIVE;
            }
            if (op1.recursive() && op2.recursive()) {
                return ProtoTruthMessageDifferencer.ShouldIgnore.YES_RECURSIVE;
            }
            return ProtoTruthMessageDifferencer.ShouldIgnore.YES_NONRECURSIVE;
        }

        @Override
        public String toString() {
            return String.format("(%s || %s)", this.elements.get(0), this.elements.get(1));
        }
    }

    private static final class IntersectionFieldScopeLogic
    extends CompoundFieldScopeLogic<IntersectionFieldScopeLogic> {
        IntersectionFieldScopeLogic(FieldScopeLogic subject1, FieldScopeLogic subject2) {
            super(subject1, subject2);
        }

        @Override
        IntersectionFieldScopeLogic newLogicOfSameType(List<FieldScopeLogic> newElements) {
            Preconditions.checkArgument((newElements.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 elements: %s", newElements);
            return new IntersectionFieldScopeLogic(newElements.get(0), newElements.get(1));
        }

        @Override
        ProtoTruthMessageDifferencer.ShouldIgnore shouldIgnore(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            return IntersectionFieldScopeLogic.intersection(((FieldScopeLogic)this.elements.get(0)).shouldIgnore(rootDescriptor, fieldDescriptorOrUnknown), ((FieldScopeLogic)this.elements.get(1)).shouldIgnore(rootDescriptor, fieldDescriptorOrUnknown));
        }

        private static ProtoTruthMessageDifferencer.ShouldIgnore intersection(ProtoTruthMessageDifferencer.ShouldIgnore op1, ProtoTruthMessageDifferencer.ShouldIgnore op2) {
            if (op1 == ProtoTruthMessageDifferencer.ShouldIgnore.YES_RECURSIVE || op2 == ProtoTruthMessageDifferencer.ShouldIgnore.YES_RECURSIVE) {
                return ProtoTruthMessageDifferencer.ShouldIgnore.YES_RECURSIVE;
            }
            if (op1.shouldIgnore() || op2.shouldIgnore()) {
                return ProtoTruthMessageDifferencer.ShouldIgnore.YES_NONRECURSIVE;
            }
            if (op1.recursive() && op2.recursive()) {
                return ProtoTruthMessageDifferencer.ShouldIgnore.NO_RECURSIVE;
            }
            return ProtoTruthMessageDifferencer.ShouldIgnore.NO_NONRECURSIVE;
        }

        @Override
        public String toString() {
            return String.format("(%s && %s)", this.elements.get(0), this.elements.get(1));
        }
    }

    private static abstract class CompoundFieldScopeLogic<T extends CompoundFieldScopeLogic<T>>
    extends FieldScopeLogic {
        final ImmutableList<FieldScopeLogic> elements;

        CompoundFieldScopeLogic(FieldScopeLogic singleElem) {
            this.elements = ImmutableList.of((Object)singleElem);
        }

        CompoundFieldScopeLogic(FieldScopeLogic firstElem, FieldScopeLogic secondElem) {
            this.elements = ImmutableList.of((Object)firstElem, (Object)secondElem);
        }

        @Override
        final void validate(Descriptors.Descriptor descriptor) {
            for (FieldScopeLogic elem : this.elements) {
                elem.validate(descriptor);
            }
        }

        abstract T newLogicOfSameType(List<FieldScopeLogic> var1);

        @Override
        final FieldScopeLogic subLogicImpl(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.elements.size());
            for (FieldScopeLogic elem : this.elements) {
                builder.add((Object)elem.subLogic(rootDescriptor, fieldDescriptorOrUnknown));
            }
            return this.newLogicOfSameType((List<FieldScopeLogic>)builder.build());
        }
    }

    private static final class FieldDescriptorsLogic
    extends FieldMatcherLogicBase {
        private final ImmutableSet<Descriptors.FieldDescriptor> fieldDescriptors;

        FieldDescriptorsLogic(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            this.fieldDescriptors = ImmutableSet.copyOf(fieldDescriptors);
        }

        @Override
        boolean matchesFieldDescriptor(Descriptors.Descriptor descriptor, Descriptors.FieldDescriptor fieldDescriptor) {
            return this.fieldDescriptors.contains((Object)fieldDescriptor);
        }

        @Override
        public String toString() {
            return String.format("FieldScopes.allowingFieldDescriptors(%s)", FieldScopeUtil.join(this.fieldDescriptors));
        }
    }

    private static final class FieldNumbersLogic
    extends FieldMatcherLogicBase {
        private final ImmutableSet<Integer> fieldNumbers;

        FieldNumbersLogic(Iterable<Integer> fieldNumbers) {
            this.fieldNumbers = ImmutableSet.copyOf(fieldNumbers);
        }

        @Override
        void validate(Descriptors.Descriptor descriptor) {
            super.validate(descriptor);
            UnmodifiableIterator unmodifiableIterator = this.fieldNumbers.iterator();
            while (unmodifiableIterator.hasNext()) {
                int fieldNumber = (Integer)unmodifiableIterator.next();
                Preconditions.checkArgument((descriptor.findFieldByNumber(fieldNumber) != null ? 1 : 0) != 0, (String)"Message type %s has no field with number %s.", (Object)descriptor.getFullName(), (int)fieldNumber);
            }
        }

        @Override
        boolean matchesFieldDescriptor(Descriptors.Descriptor descriptor, Descriptors.FieldDescriptor fieldDescriptor) {
            return fieldDescriptor.getContainingType() == descriptor && this.fieldNumbers.contains((Object)fieldDescriptor.getNumber());
        }

        @Override
        public String toString() {
            return String.format("FieldScopes.allowingFields(%s)", FieldScopeUtil.join(this.fieldNumbers));
        }
    }

    private static abstract class FieldMatcherLogicBase
    extends FieldScopeLogic {
        private FieldMatcherLogicBase() {
        }

        abstract boolean matchesFieldDescriptor(Descriptors.Descriptor var1, Descriptors.FieldDescriptor var2);

        @Override
        final ProtoTruthMessageDifferencer.ShouldIgnore shouldIgnore(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            if (fieldDescriptorOrUnknown.unknownFieldDescriptor().isPresent()) {
                return ProtoTruthMessageDifferencer.ShouldIgnore.YES_RECURSIVE;
            }
            Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)fieldDescriptorOrUnknown.fieldDescriptor().get();
            if (this.matchesFieldDescriptor(rootDescriptor, fieldDescriptor)) {
                return ProtoTruthMessageDifferencer.ShouldIgnore.NO_RECURSIVE;
            }
            return ProtoTruthMessageDifferencer.ShouldIgnore.YES_NONRECURSIVE;
        }

        @Override
        final FieldScopeLogic subLogicImpl(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            return this;
        }
    }

    private static final class RootPartialScopeLogic
    extends PartialScopeLogic {
        private final Message message;
        private final Descriptors.Descriptor expectedDescriptor;

        RootPartialScopeLogic(Message message) {
            super(FieldNumberTree.fromMessage(message));
            this.message = message;
            this.expectedDescriptor = message.getDescriptorForType();
        }

        @Override
        void validate(Descriptors.Descriptor descriptor) {
            Preconditions.checkArgument((boolean)this.expectedDescriptor.equals(descriptor), (String)"Message given to FieldScopes.fromSetFields() does not have the same descriptor as the message being tested. Expected %s, got %s.", (Object)this.expectedDescriptor.getFullName(), (Object)descriptor.getFullName());
        }

        @Override
        public String toString() {
            return String.format("FieldScopes.fromSetFields(%s)", this.message);
        }
    }

    private static class PartialScopeLogic
    extends FieldScopeLogic {
        private static final PartialScopeLogic EMPTY = new PartialScopeLogic(FieldNumberTree.empty());
        private final FieldNumberTree fieldNumberTree;

        PartialScopeLogic(FieldNumberTree fieldNumberTree) {
            this.fieldNumberTree = fieldNumberTree;
        }

        @Override
        public String toString() {
            return String.format("PartialScopeLogic(%s)", this.fieldNumberTree);
        }

        @Override
        final ProtoTruthMessageDifferencer.ShouldIgnore shouldIgnore(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            return this.fieldNumberTree.hasChild(fieldDescriptorOrUnknown) ? ProtoTruthMessageDifferencer.ShouldIgnore.NO_NONRECURSIVE : ProtoTruthMessageDifferencer.ShouldIgnore.YES_RECURSIVE;
        }

        @Override
        final FieldScopeLogic subLogicImpl(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            return PartialScopeLogic.newPartialScopeLogic(this.fieldNumberTree.child(fieldDescriptorOrUnknown));
        }

        private static PartialScopeLogic newPartialScopeLogic(FieldNumberTree fieldNumberTree) {
            return fieldNumberTree.isEmpty() ? EMPTY : new PartialScopeLogic(fieldNumberTree);
        }
    }
}

