/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.truth.extensions.proto.AutoValue_ProtoTruthMessageDifferencer_FieldDescriptorOrUnknown;
import com.google.common.truth.extensions.proto.AutoValue_ProtoTruthMessageDifferencer_UnknownFieldDescriptor;
import com.google.common.truth.extensions.proto.DiffResult;
import com.google.common.truth.extensions.proto.FieldScopeLogic;
import com.google.common.truth.extensions.proto.FluentEqualityConfig;
import com.google.common.truth.extensions.proto.RecursableDiffEntity;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class ProtoTruthMessageDifferencer {
    private final FluentEqualityConfig config;
    private final Descriptors.Descriptor rootDescriptor;

    private ProtoTruthMessageDifferencer(FluentEqualityConfig config, Descriptors.Descriptor descriptor) {
        config.fieldScopeLogic().validate(descriptor);
        this.config = config;
        this.rootDescriptor = descriptor;
    }

    static ProtoTruthMessageDifferencer create(FluentEqualityConfig config, Descriptors.Descriptor descriptor) {
        return new ProtoTruthMessageDifferencer(config, descriptor);
    }

    DiffResult diffMessages(Message actual, Message expected) {
        Preconditions.checkNotNull((Object)actual);
        Preconditions.checkNotNull((Object)expected);
        Preconditions.checkArgument((actual.getDescriptorForType() == expected.getDescriptorForType() ? 1 : 0) != 0, (String)"The actual [%s] and expected [%s] message descriptors do not match.", (Object)actual.getDescriptorForType(), (Object)expected.getDescriptorForType());
        return this.diffMessages(actual, expected, this.config.fieldScopeLogic());
    }

    private DiffResult diffMessages(Message actual, Message expected, FieldScopeLogic fieldScopeLogic) {
        DiffResult.Builder builder = DiffResult.newBuilder().setActual(actual).setExpected(expected);
        Map actualFields = actual.getAllFields();
        Map expectedFields = expected.getAllFields();
        for (Descriptors.FieldDescriptor fieldDescriptor : Sets.union(actualFields.keySet(), expectedFields.keySet())) {
            FieldDescriptorOrUnknown fieldDescriptorOrUnknown = FieldDescriptorOrUnknown.fieldDescriptor(fieldDescriptor);
            ShouldIgnore shouldIgnore = fieldScopeLogic.shouldIgnore(this.rootDescriptor, fieldDescriptorOrUnknown);
            if (shouldIgnore == ShouldIgnore.YES) {
                builder.addSingularField(fieldDescriptor.getNumber(), DiffResult.SingularField.ignored(ProtoTruthMessageDifferencer.name(fieldDescriptor)));
                continue;
            }
            if (fieldDescriptor.isRepeated()) {
                if (fieldDescriptor.isMapField()) {
                    Map<Object, Object> actualMap = ProtoTruthMessageDifferencer.toProtoMap(actualFields.get(fieldDescriptor));
                    Map<Object, Object> expectedMap = ProtoTruthMessageDifferencer.toProtoMap(expectedFields.get(fieldDescriptor));
                    ImmutableSet keyOrder = Sets.union(actualMap.keySet(), expectedMap.keySet()).immutableCopy();
                    builder.addAllSingularFields(fieldDescriptor.getNumber(), this.compareMapFieldsByKey(actualMap, expectedMap, (Set<Object>)keyOrder, fieldDescriptor, fieldScopeLogic));
                    continue;
                }
                List<?> actualList = ProtoTruthMessageDifferencer.toProtoList(actualFields.get(fieldDescriptor));
                List<?> expectedList = ProtoTruthMessageDifferencer.toProtoList(expectedFields.get(fieldDescriptor));
                if (this.config.ignoreRepeatedFieldOrder()) {
                    builder.addRepeatedField(fieldDescriptor.getNumber(), this.compareRepeatedFieldIgnoringOrder(actualList, expectedList, shouldIgnore.shouldMaybeIgnore(), fieldDescriptor, fieldScopeLogic.subLogic(this.rootDescriptor, fieldDescriptorOrUnknown)));
                    continue;
                }
                builder.addAllSingularFields(fieldDescriptor.getNumber(), this.compareRepeatedFieldByIndices(actualList, expectedList, shouldIgnore.shouldMaybeIgnore(), fieldDescriptor, fieldScopeLogic.subLogic(this.rootDescriptor, fieldDescriptorOrUnknown)));
                continue;
            }
            builder.addSingularField(fieldDescriptor.getNumber(), this.compareSingularValue(actualFields.get(fieldDescriptor), expectedFields.get(fieldDescriptor), actual.getDefaultInstanceForType().getField(fieldDescriptor), shouldIgnore.shouldMaybeIgnore(), ProtoTruthMessageDifferencer.name(fieldDescriptor), fieldDescriptor, fieldScopeLogic.subLogic(this.rootDescriptor, fieldDescriptorOrUnknown)));
        }
        if (!this.config.ignoreFieldAbsence()) {
            DiffResult.UnknownFieldSetDiff diff = this.diffUnknowns(actual.getUnknownFields(), expected.getUnknownFields(), fieldScopeLogic);
            builder.setUnknownFields(diff);
        }
        return builder.build();
    }

    private static Map<Object, Object> toProtoMap(@Nullable Object container) {
        if (container == null) {
            return Collections.emptyMap();
        }
        List entryMessages = (List)container;
        HashMap retVal = Maps.newHashMap();
        for (Object entry : entryMessages) {
            Message message = (Message)entry;
            Object key = message.getAllFields().get(message.getDescriptorForType().findFieldByNumber(1));
            Object value = message.getAllFields().get(message.getDescriptorForType().findFieldByNumber(2));
            retVal.put(key, value);
        }
        return retVal;
    }

    private static List<?> toProtoList(@Nullable Object container) {
        if (container == null) {
            return Collections.emptyList();
        }
        return (List)container;
    }

    private List<DiffResult.SingularField> compareMapFieldsByKey(Map<Object, Object> actualMap, Map<Object, Object> expectedMap, Set<Object> keyOrder, Descriptors.FieldDescriptor mapFieldDescriptor, FieldScopeLogic mapFieldScopeLogic) {
        Descriptors.FieldDescriptor valueFieldDescriptor = mapFieldDescriptor.getMessageType().findFieldByNumber(2);
        FieldDescriptorOrUnknown valueFieldDescriptorOrUnknown = FieldDescriptorOrUnknown.fieldDescriptor(valueFieldDescriptor);
        FieldScopeLogic valueFieldScopeLogic = mapFieldScopeLogic.subLogic(this.rootDescriptor, valueFieldDescriptorOrUnknown);
        ShouldIgnore shouldIgnoreValue = valueFieldScopeLogic.shouldIgnore(this.rootDescriptor, valueFieldDescriptorOrUnknown);
        if (shouldIgnoreValue == ShouldIgnore.YES) {
            return ImmutableList.of((Object)DiffResult.SingularField.ignored(ProtoTruthMessageDifferencer.name(mapFieldDescriptor)));
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)keyOrder.size());
        for (Object key : keyOrder) {
            Object actualValue = actualMap.get(key);
            Object expectedValue = expectedMap.get(key);
            builder.add((Object)this.compareSingularValue(actualValue, expectedValue, null, shouldIgnoreValue.shouldMaybeIgnore(), ProtoTruthMessageDifferencer.indexedName(mapFieldDescriptor, key), valueFieldDescriptor, valueFieldScopeLogic));
        }
        return builder.build();
    }

    private DiffResult.RepeatedField compareRepeatedFieldIgnoringOrder(List<?> actualList, List<?> expectedList, boolean shouldMaybeIgnore, Descriptors.FieldDescriptor fieldDescriptor, FieldScopeLogic fieldScopeLogic) {
        DiffResult.RepeatedField.Builder builder = DiffResult.RepeatedField.newBuilder().setFieldName(ProtoTruthMessageDifferencer.name(fieldDescriptor)).setActual(actualList).setExpected(expectedList);
        Set<Integer> unmatchedActual = ProtoTruthMessageDifferencer.setForRange(actualList.size());
        Set<Integer> unmatchedExpected = ProtoTruthMessageDifferencer.setForRange(expectedList.size());
        block0: for (int i = 0; i < actualList.size(); ++i) {
            Object actual = actualList.get(i);
            for (int j : unmatchedExpected) {
                Object expected = expectedList.get(j);
                DiffResult.RepeatedField.PairResult pairResult = this.compareRepeatedFieldElementPair(actual, expected, shouldMaybeIgnore, fieldDescriptor, i, j, fieldScopeLogic);
                if (!pairResult.isMatched()) continue;
                builder.addPairResult(pairResult);
                unmatchedActual.remove(i);
                unmatchedExpected.remove(j);
                continue block0;
            }
        }
        for (int i : unmatchedActual) {
            builder.addPairResult(this.compareRepeatedFieldElementPair(actualList.get(i), null, shouldMaybeIgnore, fieldDescriptor, i, null, fieldScopeLogic));
        }
        for (int j : unmatchedExpected) {
            builder.addPairResult(this.compareRepeatedFieldElementPair(null, expectedList.get(j), shouldMaybeIgnore, fieldDescriptor, null, j, fieldScopeLogic));
        }
        return builder.build();
    }

    private DiffResult.RepeatedField.PairResult compareRepeatedFieldElementPair(@Nullable Object actual, @Nullable Object expected, boolean shouldMaybeIgnore, Descriptors.FieldDescriptor fieldDescriptor, @Nullable Integer actualFieldIndex, @Nullable Integer expectedFieldIndex, FieldScopeLogic fieldScopeLogic) {
        DiffResult.SingularField comparison = this.compareSingularValue(actual, expected, null, shouldMaybeIgnore, "<no field path>", fieldDescriptor, fieldScopeLogic);
        DiffResult.RepeatedField.PairResult.Builder pairResultBuilder = DiffResult.RepeatedField.PairResult.newBuilder().setResult(comparison.result());
        if (actual != null) {
            pairResultBuilder.setActual(actual).setActualFieldIndex(actualFieldIndex);
        }
        if (expected != null) {
            pairResultBuilder.setExpected(expected).setExpectedFieldIndex(expectedFieldIndex);
        }
        if (comparison.breakdown().isPresent()) {
            pairResultBuilder.setBreakdown((DiffResult)comparison.breakdown().get());
        }
        return pairResultBuilder.build();
    }

    private static Set<Integer> setForRange(int max) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (int i = 0; i < max; ++i) {
            set.add(i);
        }
        return set;
    }

    private List<DiffResult.SingularField> compareRepeatedFieldByIndices(List<?> actualList, List<?> expectedList, boolean shouldMaybeIgnore, Descriptors.FieldDescriptor fieldDescriptor, FieldScopeLogic fieldScopeLogic) {
        int maxSize = Math.max(actualList.size(), expectedList.size());
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)maxSize);
        for (int i = 0; i < maxSize; ++i) {
            Object actual = actualList.size() > i ? actualList.get(i) : null;
            Object expected = expectedList.size() > i ? expectedList.get(i) : null;
            builder.add((Object)this.compareSingularValue(actual, expected, null, shouldMaybeIgnore, ProtoTruthMessageDifferencer.indexedName(fieldDescriptor, (Object)i), fieldDescriptor, fieldScopeLogic));
        }
        return builder.build();
    }

    private DiffResult.SingularField compareSingularValue(@Nullable Object actual, @Nullable Object expected, @Nullable Object defaultValue, boolean shouldMaybeIgnore, String fieldName, Descriptors.FieldDescriptor fieldDescriptor, FieldScopeLogic fieldScopeLogic) {
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            return this.compareSingularMessage((Message)actual, (Message)expected, (Message)defaultValue, shouldMaybeIgnore, fieldName, fieldScopeLogic);
        }
        Preconditions.checkState((!shouldMaybeIgnore ? 1 : 0) != 0, (Object)"MAYBE is not a valid ShouldIgnore for primitives.");
        return this.compareSingularPrimitive(actual, expected, defaultValue, fieldName);
    }

    private <T> T orIfIgnoringFieldAbsence(@Nullable T input, @Nullable T defaultValue) {
        return input == null && this.config.ignoreFieldAbsence() ? defaultValue : input;
    }

    private static Message orDefaultForType(@Nullable Message input, @Nullable Message other) {
        return input != null ? input : other.getDefaultInstanceForType();
    }

    private DiffResult.SingularField compareSingularMessage(@Nullable Message actual, @Nullable Message expected, @Nullable Message defaultValue, boolean shouldMaybeIgnore, String fieldName, FieldScopeLogic fieldScopeLogic) {
        RecursableDiffEntity.WithResultCode.Result.Builder result = RecursableDiffEntity.WithResultCode.Result.builder();
        actual = this.orIfIgnoringFieldAbsence(actual, defaultValue);
        expected = this.orIfIgnoringFieldAbsence(expected, defaultValue);
        result.markRemovedIf(actual == null);
        result.markAddedIf(expected == null);
        DiffResult breakdown = null;
        if (result.build() == RecursableDiffEntity.WithResultCode.Result.MATCHED || shouldMaybeIgnore) {
            breakdown = this.diffMessages(actual = ProtoTruthMessageDifferencer.orDefaultForType(actual, expected), expected = ProtoTruthMessageDifferencer.orDefaultForType(expected, actual), fieldScopeLogic);
            if (breakdown.isIgnored() && shouldMaybeIgnore) {
                return DiffResult.SingularField.ignored(fieldName);
            }
            result.markModifiedIf(!breakdown.isMatched());
        }
        DiffResult.SingularField.Builder singularFieldBuilder = DiffResult.SingularField.newBuilder().setFieldName(fieldName).setResult(result.build());
        if (actual != null) {
            singularFieldBuilder.setActual(actual);
        }
        if (expected != null) {
            singularFieldBuilder.setExpected(expected);
        }
        if (breakdown != null) {
            singularFieldBuilder.setBreakdown(breakdown);
        }
        return singularFieldBuilder.build();
    }

    private DiffResult.SingularField compareSingularPrimitive(@Nullable Object actual, @Nullable Object expected, @Nullable Object defaultValue, String fieldName) {
        RecursableDiffEntity.WithResultCode.Result.Builder result = RecursableDiffEntity.WithResultCode.Result.builder();
        actual = this.orIfIgnoringFieldAbsence(actual, defaultValue);
        expected = this.orIfIgnoringFieldAbsence(expected, defaultValue);
        result.markRemovedIf(actual == null);
        result.markAddedIf(expected == null);
        result.markModifiedIf(!Objects.equal((Object)actual, (Object)expected));
        DiffResult.SingularField.Builder singularFieldBuilder = DiffResult.SingularField.newBuilder().setFieldName(fieldName).setResult(result.build());
        if (actual != null) {
            singularFieldBuilder.setActual(actual);
        }
        if (expected != null) {
            singularFieldBuilder.setExpected(expected);
        }
        return singularFieldBuilder.build();
    }

    private DiffResult.UnknownFieldSetDiff diffUnknowns(UnknownFieldSet actual, UnknownFieldSet expected, FieldScopeLogic fieldScopeLogic) {
        DiffResult.UnknownFieldSetDiff.Builder builder = DiffResult.UnknownFieldSetDiff.newBuilder();
        Map actualFields = actual.asMap();
        Map expectedFields = expected.asMap();
        UnmodifiableIterator unmodifiableIterator = Sets.union(actualFields.keySet(), expectedFields.keySet()).iterator();
        while (unmodifiableIterator.hasNext()) {
            int fieldNumber = (Integer)unmodifiableIterator.next();
            UnknownFieldSet.Field actualField = (UnknownFieldSet.Field)actualFields.get(fieldNumber);
            UnknownFieldSet.Field expectedField = (UnknownFieldSet.Field)expectedFields.get(fieldNumber);
            for (UnknownFieldDescriptor.Type type : UnknownFieldDescriptor.Type.all()) {
                List expectedValues;
                List actualValues = actualField != null ? type.getValues(actualField) : Collections.emptyList();
                List<Object> list = expectedValues = expectedField != null ? type.getValues(expectedField) : Collections.emptyList();
                if (actualValues.isEmpty() && expectedValues.isEmpty()) continue;
                UnknownFieldDescriptor unknownFieldDescriptor = UnknownFieldDescriptor.create(fieldNumber, type);
                FieldDescriptorOrUnknown fieldDescriptorOrUnknown = FieldDescriptorOrUnknown.unknown(unknownFieldDescriptor);
                ShouldIgnore shouldIgnore = fieldScopeLogic.shouldIgnore(this.rootDescriptor, fieldDescriptorOrUnknown);
                if (shouldIgnore == ShouldIgnore.YES) {
                    builder.addSingularField(fieldNumber, DiffResult.SingularField.ignored(ProtoTruthMessageDifferencer.name(unknownFieldDescriptor)));
                    continue;
                }
                builder.addAllSingularFields(fieldNumber, this.compareUnknownFieldList(actualValues, expectedValues, shouldIgnore.shouldMaybeIgnore(), unknownFieldDescriptor, fieldScopeLogic.subLogic(this.rootDescriptor, fieldDescriptorOrUnknown)));
            }
        }
        return builder.build();
    }

    private List<DiffResult.SingularField> compareUnknownFieldList(List<?> actualValues, List<?> expectedValues, boolean shouldMaybeIgnore, UnknownFieldDescriptor unknownFieldDescriptor, FieldScopeLogic fieldScopeLogic) {
        int maxSize = Math.max(actualValues.size(), expectedValues.size());
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)maxSize);
        for (int i = 0; i < maxSize; ++i) {
            Object actual = actualValues.size() > i ? actualValues.get(i) : null;
            Object expected = expectedValues.size() > i ? expectedValues.get(i) : null;
            builder.add((Object)this.compareUnknownFieldValue(actual, expected, shouldMaybeIgnore, ProtoTruthMessageDifferencer.indexedName(unknownFieldDescriptor, i), unknownFieldDescriptor, fieldScopeLogic));
        }
        return builder.build();
    }

    private DiffResult.SingularField compareUnknownFieldValue(@Nullable Object actual, @Nullable Object expected, boolean shouldMaybeIgnore, String fieldName, UnknownFieldDescriptor unknownFieldDescriptor, FieldScopeLogic fieldScopeLogic) {
        if (unknownFieldDescriptor.type() == UnknownFieldDescriptor.Type.GROUP) {
            return this.compareUnknownFieldSet((UnknownFieldSet)actual, (UnknownFieldSet)expected, shouldMaybeIgnore, fieldName, fieldScopeLogic);
        }
        Preconditions.checkState((!shouldMaybeIgnore ? 1 : 0) != 0, (Object)"MAYBE is not a valid ShouldIgnore for primitives.");
        return this.compareUnknownPrimitive(actual, expected, fieldName);
    }

    private DiffResult.SingularField compareUnknownFieldSet(@Nullable UnknownFieldSet actual, @Nullable UnknownFieldSet expected, boolean shouldMaybeIgnore, String fieldName, FieldScopeLogic fieldScopeLogic) {
        RecursableDiffEntity.WithResultCode.Result.Builder result = RecursableDiffEntity.WithResultCode.Result.builder();
        result.markRemovedIf(actual == null);
        result.markAddedIf(expected == null);
        DiffResult.UnknownFieldSetDiff unknownsBreakdown = null;
        if (result.build() == RecursableDiffEntity.WithResultCode.Result.MATCHED || shouldMaybeIgnore) {
            unknownsBreakdown = this.diffUnknowns(actual = (UnknownFieldSet)MoreObjects.firstNonNull((Object)actual, (Object)UnknownFieldSet.getDefaultInstance()), expected = (UnknownFieldSet)MoreObjects.firstNonNull((Object)expected, (Object)UnknownFieldSet.getDefaultInstance()), fieldScopeLogic);
            if (unknownsBreakdown.isIgnored() && shouldMaybeIgnore) {
                return DiffResult.SingularField.ignored(fieldName);
            }
            result.markModifiedIf(!unknownsBreakdown.isMatched());
        }
        DiffResult.SingularField.Builder singularFieldBuilder = DiffResult.SingularField.newBuilder().setFieldName(fieldName).setResult(result.build());
        if (actual != null) {
            singularFieldBuilder.setActual(actual);
        }
        if (expected != null) {
            singularFieldBuilder.setExpected(expected);
        }
        if (unknownsBreakdown != null) {
            singularFieldBuilder.setUnknownsBreakdown(unknownsBreakdown);
        }
        return singularFieldBuilder.build();
    }

    private DiffResult.SingularField compareUnknownPrimitive(@Nullable Object actual, @Nullable Object expected, String fieldName) {
        RecursableDiffEntity.WithResultCode.Result.Builder result = RecursableDiffEntity.WithResultCode.Result.builder();
        result.markRemovedIf(actual == null);
        result.markAddedIf(expected == null);
        result.markModifiedIf(!Objects.equal((Object)actual, (Object)expected));
        DiffResult.SingularField.Builder singularFieldBuilder = DiffResult.SingularField.newBuilder().setFieldName(fieldName).setResult(result.build());
        if (actual != null) {
            singularFieldBuilder.setActual(actual);
        }
        if (expected != null) {
            singularFieldBuilder.setExpected(expected);
        }
        return singularFieldBuilder.build();
    }

    private static String name(Descriptors.FieldDescriptor fieldDescriptor) {
        return fieldDescriptor.isExtension() ? "[" + fieldDescriptor + "]" : fieldDescriptor.getName();
    }

    private static String indexedName(Descriptors.FieldDescriptor fieldDescriptor, Object key) {
        return ProtoTruthMessageDifferencer.name(fieldDescriptor) + "[" + key + "]";
    }

    private static String name(UnknownFieldDescriptor unknownFieldDescriptor) {
        return String.valueOf(unknownFieldDescriptor.fieldNumber());
    }

    private static String indexedName(UnknownFieldDescriptor unknownFieldDescriptor, int index) {
        return ProtoTruthMessageDifferencer.name(unknownFieldDescriptor) + "[" + index + "]";
    }

    @AutoValue
    static abstract class FieldDescriptorOrUnknown {
        FieldDescriptorOrUnknown() {
        }

        abstract Optional<Descriptors.FieldDescriptor> fieldDescriptor();

        abstract Optional<UnknownFieldDescriptor> unknownFieldDescriptor();

        static FieldDescriptorOrUnknown fieldDescriptor(Descriptors.FieldDescriptor fieldDescriptor) {
            return new AutoValue_ProtoTruthMessageDifferencer_FieldDescriptorOrUnknown((Optional<Descriptors.FieldDescriptor>)Optional.of((Object)fieldDescriptor), (Optional<UnknownFieldDescriptor>)Optional.absent());
        }

        static FieldDescriptorOrUnknown unknown(UnknownFieldDescriptor unknownFieldDescriptor) {
            return new AutoValue_ProtoTruthMessageDifferencer_FieldDescriptorOrUnknown((Optional<Descriptors.FieldDescriptor>)Optional.absent(), (Optional<UnknownFieldDescriptor>)Optional.of((Object)unknownFieldDescriptor));
        }
    }

    @AutoValue
    static abstract class UnknownFieldDescriptor {
        UnknownFieldDescriptor() {
        }

        abstract int fieldNumber();

        abstract Type type();

        static UnknownFieldDescriptor create(int fieldNumber, Type type) {
            return new AutoValue_ProtoTruthMessageDifferencer_UnknownFieldDescriptor(fieldNumber, type);
        }

        static ImmutableList<UnknownFieldDescriptor> descriptors(int fieldNumber, UnknownFieldSet.Field field) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Type type : Type.all()) {
                if (type.getValues(field).isEmpty()) continue;
                builder.add((Object)UnknownFieldDescriptor.create(fieldNumber, type));
            }
            return builder.build();
        }

        static enum Type {
            VARINT{

                @Override
                public List<?> getValues(UnknownFieldSet.Field field) {
                    return field.getVarintList();
                }
            }
            ,
            FIXED32{

                @Override
                public List<?> getValues(UnknownFieldSet.Field field) {
                    return field.getFixed32List();
                }
            }
            ,
            FIXED64{

                @Override
                public List<?> getValues(UnknownFieldSet.Field field) {
                    return field.getFixed64List();
                }
            }
            ,
            LENGTH_DELIMITED{

                @Override
                public List<?> getValues(UnknownFieldSet.Field field) {
                    return field.getLengthDelimitedList();
                }
            }
            ,
            GROUP{

                @Override
                public List<?> getValues(UnknownFieldSet.Field field) {
                    return field.getGroupList();
                }
            };

            private static final ImmutableList<Type> TYPES;

            static ImmutableList<Type> all() {
                return TYPES;
            }

            abstract List<?> getValues(UnknownFieldSet.Field var1);

            static {
                TYPES = ImmutableList.copyOf((Object[])Type.values());
            }
        }
    }

    static enum ShouldIgnore {
        YES,
        MAYBE,
        NO;


        boolean shouldMaybeIgnore() {
            switch (this) {
                case YES: {
                    throw new IllegalStateException("Should not have ShouldIgnore.YES here.");
                }
                case MAYBE: {
                    return true;
                }
                case NO: {
                    return false;
                }
            }
            throw new AssertionError((Object)("Impossible: " + (Object)((Object)this)));
        }
    }
}

