/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.truth.Correspondence;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.MapSubject;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.common.truth.extensions.proto.FieldScope;
import com.google.common.truth.extensions.proto.FieldScopeUtil;
import com.google.common.truth.extensions.proto.FluentEqualityConfig;
import com.google.common.truth.extensions.proto.MapWithProtoValuesFluentAssertion;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Map;
import javax.annotation.Nullable;

public class MapWithProtoValuesSubject<S extends MapWithProtoValuesSubject<S, K, M, C>, K, M extends Message, C extends Map<K, M>>
extends Subject<S, C> {
    private final FluentEqualityConfig config;

    protected MapWithProtoValuesSubject(FailureMetadata failureMetadata, @Nullable C map) {
        this(failureMetadata, FluentEqualityConfig.defaultInstance(), map);
    }

    MapWithProtoValuesSubject(FailureMetadata failureMetadata, FluentEqualityConfig config, @Nullable C map) {
        super(failureMetadata, map);
        this.config = config;
    }

    private static <M extends Message, K> Subject.Factory<MapWithMessageValuesSubject<K, M>, Map<K, M>> mapWithProtoValues(final FluentEqualityConfig config) {
        return new Subject.Factory<MapWithMessageValuesSubject<K, M>, Map<K, M>>(){

            public MapWithMessageValuesSubject<K, M> createSubject(FailureMetadata metadata, Map<K, M> actual) {
                return new MapWithMessageValuesSubject(metadata, config, actual);
            }
        };
    }

    private final MapSubject delegate() {
        MapSubject delegate = this.check().that((Map)this.actual());
        if (this.internalCustomName() != null) {
            delegate = (MapSubject)delegate.named(this.internalCustomName(), new Object[0]);
        }
        return delegate;
    }

    public void isEqualTo(@Nullable Object other) {
        this.delegate().isEqualTo(other);
    }

    public void isEmpty() {
        this.delegate().isEmpty();
    }

    public void isNotEmpty() {
        this.delegate().isNotEmpty();
    }

    public void hasSize(int expectedSize) {
        this.delegate().hasSize(expectedSize);
    }

    public void containsKey(@Nullable Object key) {
        this.delegate().containsKey(key);
    }

    public void doesNotContainKey(@Nullable Object key) {
        this.delegate().doesNotContainKey(key);
    }

    public void containsEntry(@Nullable Object key, @Nullable Object value) {
        this.delegate().containsEntry(key, value);
    }

    public void doesNotContainEntry(@Nullable Object key, @Nullable Object value) {
        this.delegate().doesNotContainEntry(key, value);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly() {
        return this.delegate().containsExactly();
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly(@Nullable Object k0, @Nullable Object v0, Object ... rest) {
        return this.delegate().containsExactly(k0, v0, rest);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactlyEntriesIn(Map<?, ?> expectedMap) {
        return this.delegate().containsExactlyEntriesIn(expectedMap);
    }

    public <A, E> MapSubject.UsingCorrespondence<A, E> comparingValuesUsing(Correspondence<A, E> correspondence) {
        return this.delegate().comparingValuesUsing(correspondence);
    }

    MapWithProtoValuesFluentAssertion<M> usingConfig(FluentEqualityConfig newConfig) {
        Subject.Factory<MapWithMessageValuesSubject<K, M>, Map<K, M>> factory = MapWithProtoValuesSubject.mapWithProtoValues(newConfig);
        MapWithMessageValuesSubject newSubject = (MapWithMessageValuesSubject)this.check().about(factory).that(this.actual());
        if (this.internalCustomName() != null) {
            newSubject = (MapWithMessageValuesSubject)newSubject.named(this.internalCustomName(), new Object[0]);
        }
        return new MapWithProtoValuesFluentAssertionImpl(newSubject);
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceForValues() {
        return this.usingConfig(this.config.ignoringFieldAbsence());
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderForValues() {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrder());
    }

    public MapWithProtoValuesFluentAssertion<M> withPartialScopeForValues(FieldScope fieldScope) {
        return this.usingConfig(this.config.withPartialScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(int firstFieldNumber, int ... rest) {
        return this.ignoringFieldsForValues(FieldScopeUtil.asList(firstFieldNumber, rest));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringFields(fieldNumbers));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.ignoringFieldDescriptorsForValues(Lists.asList((Object)firstFieldDescriptor, (Object[])rest));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringFieldDescriptors(fieldDescriptors));
    }

    public MapWithProtoValuesFluentAssertion<M> ignoringFieldScopeForValues(FieldScope fieldScope) {
        return this.usingConfig(this.config.ignoringFieldScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    public MapWithProtoValuesFluentAssertion<M> reportingMismatchesOnlyForValues() {
        return this.usingConfig(this.config.reportingMismatchesOnly());
    }

    private MapSubject.UsingCorrespondence<M, M> usingCorrespondence() {
        return this.comparingValuesUsing(this.config.toCorrespondence(FieldScopeUtil.getSingleDescriptor(((Map)this.actual()).values())));
    }

    private static final class MapWithProtoValuesFluentAssertionImpl<M extends Message>
    implements MapWithProtoValuesFluentAssertion<M> {
        private final MapWithProtoValuesSubject<?, ?, M, ?> subject;

        MapWithProtoValuesFluentAssertionImpl(MapWithProtoValuesSubject<?, ?, M, ?> subject) {
            this.subject = subject;
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceForValues() {
            return this.subject.ignoringFieldAbsenceForValues();
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderForValues() {
            return this.subject.ignoringRepeatedFieldOrderForValues();
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> withPartialScopeForValues(FieldScope fieldScope) {
            return this.subject.withPartialScopeForValues(fieldScope);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(int firstFieldNumber, int ... rest) {
            return this.subject.ignoringFieldsForValues(firstFieldNumber, rest);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(Iterable<Integer> fieldNumbers) {
            return this.subject.ignoringFieldsForValues(fieldNumbers);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.ignoringFieldDescriptorsForValues(firstFieldDescriptor, rest);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.ignoringFieldDescriptorsForValues(fieldDescriptors);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> ignoringFieldScopeForValues(FieldScope fieldScope) {
            return this.subject.ignoringFieldScopeForValues(fieldScope);
        }

        @Override
        public MapWithProtoValuesFluentAssertion<M> reportingMismatchesOnlyForValues() {
            return this.subject.reportingMismatchesOnlyForValues();
        }

        @Override
        public void containsEntry(@Nullable Object expectedKey, @Nullable M expectedValue) {
            this.usingCorrespondence().containsEntry(expectedKey, expectedValue);
        }

        @Override
        public void doesNotContainEntry(@Nullable Object excludedKey, @Nullable M excludedValue) {
            this.usingCorrespondence().doesNotContainEntry(excludedKey, excludedValue);
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsExactly(@Nullable Object k0, @Nullable M v0, Object ... rest) {
            return this.usingCorrespondence().containsExactly(k0, v0, rest);
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsExactlyEntriesIn(Map<?, ? extends M> expectedMap) {
            return this.usingCorrespondence().containsExactlyEntriesIn(expectedMap);
        }

        @Override
        @Deprecated
        public boolean equals(Object o) {
            return this.subject.equals(o);
        }

        @Override
        @Deprecated
        public int hashCode() {
            return this.subject.hashCode();
        }

        private final MapSubject.UsingCorrespondence<M, M> usingCorrespondence() {
            return ((MapWithProtoValuesSubject)this.subject).usingCorrespondence();
        }
    }

    public static final class MapWithMessageValuesSubject<K, M extends Message>
    extends MapWithProtoValuesSubject<MapWithMessageValuesSubject<K, M>, K, M, Map<K, M>> {
        MapWithMessageValuesSubject(FailureMetadata failureMetadata, @Nullable Map<K, M> map) {
            super(failureMetadata, map);
        }

        private MapWithMessageValuesSubject(FailureMetadata failureMetadata, FluentEqualityConfig config, @Nullable Map<K, M> map) {
            super(failureMetadata, config, map);
        }
    }
}

