/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.truth.Correspondence;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.common.truth.extensions.proto.FieldScope;
import com.google.common.truth.extensions.proto.FieldScopeUtil;
import com.google.common.truth.extensions.proto.FluentEqualityConfig;
import com.google.common.truth.extensions.proto.IterableOfProtosFluentAssertion;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Comparator;
import javax.annotation.Nullable;

public class IterableOfProtosSubject<S extends IterableOfProtosSubject<S, M, C>, M extends Message, C extends Iterable<M>>
extends Subject<S, C> {
    private final FluentEqualityConfig config;

    static <M extends Message> Subject.Factory<IterableOfMessagesSubject<M>, Iterable<M>> iterableOfMessages(final FluentEqualityConfig config) {
        return new Subject.Factory<IterableOfMessagesSubject<M>, Iterable<M>>(){

            public IterableOfMessagesSubject<M> createSubject(FailureMetadata metadata, Iterable<M> actual) {
                return new IterableOfMessagesSubject(metadata, config, actual);
            }
        };
    }

    protected IterableOfProtosSubject(FailureMetadata failureMetadata, @Nullable C messages) {
        this(failureMetadata, FluentEqualityConfig.defaultInstance(), messages);
    }

    IterableOfProtosSubject(FailureMetadata failureMetadata, FluentEqualityConfig config, @Nullable C messages) {
        super(failureMetadata, messages);
        this.config = config;
    }

    private final IterableSubject delegate() {
        IterableSubject delegate = this.check().that((Iterable)this.actual());
        if (this.internalCustomName() != null) {
            delegate = (IterableSubject)delegate.named(this.internalCustomName(), new Object[0]);
        }
        return delegate;
    }

    public void isEmpty() {
        this.delegate().isEmpty();
    }

    public void isNotEmpty() {
        this.delegate().isNotEmpty();
    }

    public void hasSize(int expectedSize) {
        this.delegate().hasSize(expectedSize);
    }

    public void contains(@Nullable Object element) {
        this.delegate().contains(element);
    }

    public void doesNotContain(@Nullable Object element) {
        this.delegate().doesNotContain(element);
    }

    public void containsNoDuplicates() {
        this.delegate().containsNoDuplicates();
    }

    public void containsAnyOf(@Nullable Object first, @Nullable Object second, Object ... rest) {
        this.delegate().containsAnyOf(first, second, rest);
    }

    public void containsAnyIn(Iterable<?> expected) {
        this.delegate().containsAnyIn(expected);
    }

    public void containsAnyIn(Object[] expected) {
        this.delegate().containsAnyIn(expected);
    }

    @CanIgnoreReturnValue
    public Ordered containsAllOf(@Nullable Object firstExpected, @Nullable Object secondExpected, Object ... restOfExpected) {
        return this.delegate().containsAllOf(firstExpected, secondExpected, restOfExpected);
    }

    @CanIgnoreReturnValue
    public Ordered containsAllIn(Iterable<?> expected) {
        return this.delegate().containsAllIn(expected);
    }

    @CanIgnoreReturnValue
    public Ordered containsAllIn(Object[] expected) {
        return this.delegate().containsAllIn(expected);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly(Object ... varargs) {
        return this.delegate().containsExactly(varargs);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactlyElementsIn(Iterable<?> expected) {
        return this.delegate().containsExactlyElementsIn(expected);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactlyElementsIn(Object[] expected) {
        return this.delegate().containsExactlyElementsIn(expected);
    }

    public void containsNoneOf(@Nullable Object firstExcluded, @Nullable Object secondExcluded, Object ... restOfExcluded) {
        this.delegate().containsNoneOf(firstExcluded, secondExcluded, restOfExcluded);
    }

    public void containsNoneIn(Iterable<?> excluded) {
        this.delegate().containsNoneIn(excluded);
    }

    public void containsNoneIn(Object[] excluded) {
        this.delegate().containsNoneIn(excluded);
    }

    public void isStrictlyOrdered(Comparator<?> comparator) {
        this.delegate().isStrictlyOrdered(comparator);
    }

    public void isOrdered(Comparator<?> comparator) {
        this.delegate().isOrdered(comparator);
    }

    public <A, E> IterableSubject.UsingCorrespondence<A, E> comparingElementsUsing(Correspondence<A, E> correspondence) {
        return this.delegate().comparingElementsUsing(correspondence);
    }

    IterableOfProtosFluentAssertion<M> usingConfig(FluentEqualityConfig newConfig) {
        Subject.Factory<IterableOfMessagesSubject<M>, Iterable<M>> factory = IterableOfProtosSubject.iterableOfMessages(newConfig);
        IterableOfMessagesSubject newSubject = (IterableOfMessagesSubject)this.check().about(factory).that(this.actual());
        if (this.internalCustomName() != null) {
            newSubject = (IterableOfMessagesSubject)newSubject.named(this.internalCustomName(), new Object[0]);
        }
        return new IterableOfProtosFluentAssertionImpl(newSubject);
    }

    public IterableOfProtosFluentAssertion<M> ignoringFieldAbsence() {
        return this.usingConfig(this.config.ignoringFieldAbsence());
    }

    public IterableOfProtosFluentAssertion<M> ignoringRepeatedFieldOrder() {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrder());
    }

    public IterableOfProtosFluentAssertion<M> withPartialScope(FieldScope fieldScope) {
        return this.usingConfig(this.config.withPartialScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    public IterableOfProtosFluentAssertion<M> ignoringFields(int firstFieldNumber, int ... rest) {
        return this.ignoringFields(FieldScopeUtil.asList(firstFieldNumber, rest));
    }

    public IterableOfProtosFluentAssertion<M> ignoringFields(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringFields(fieldNumbers));
    }

    public IterableOfProtosFluentAssertion<M> ignoringFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.ignoringFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest));
    }

    public IterableOfProtosFluentAssertion<M> ignoringFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringFieldDescriptors(fieldDescriptors));
    }

    public IterableOfProtosFluentAssertion<M> ignoringFieldScope(FieldScope fieldScope) {
        return this.usingConfig(this.config.ignoringFieldScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    public IterableOfProtosFluentAssertion<M> reportingMismatchesOnly() {
        return this.usingConfig(this.config.reportingMismatchesOnly());
    }

    private IterableSubject.UsingCorrespondence<M, M> usingCorrespondence() {
        return this.comparingElementsUsing(this.config.toCorrespondence(FieldScopeUtil.getSingleDescriptor((Iterable)this.actual())));
    }

    private static final class IterableOfProtosFluentAssertionImpl<M extends Message>
    implements IterableOfProtosFluentAssertion<M> {
        private final IterableOfProtosSubject<?, M, ?> subject;

        IterableOfProtosFluentAssertionImpl(IterableOfProtosSubject<?, M, ?> subject) {
            this.subject = subject;
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringFieldAbsence() {
            return this.subject.ignoringFieldAbsence();
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringRepeatedFieldOrder() {
            return this.subject.ignoringRepeatedFieldOrder();
        }

        @Override
        public IterableOfProtosFluentAssertion<M> withPartialScope(FieldScope fieldScope) {
            return this.subject.withPartialScope(fieldScope);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringFields(int firstFieldNumber, int ... rest) {
            return this.subject.ignoringFields(firstFieldNumber, rest);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringFields(Iterable<Integer> fieldNumbers) {
            return this.subject.ignoringFields(fieldNumbers);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.ignoringFieldDescriptors(firstFieldDescriptor, rest);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.ignoringFieldDescriptors(fieldDescriptors);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> ignoringFieldScope(FieldScope fieldScope) {
            return this.subject.ignoringFieldScope(fieldScope);
        }

        @Override
        public IterableOfProtosFluentAssertion<M> reportingMismatchesOnly() {
            return this.subject.reportingMismatchesOnly();
        }

        @Override
        public void contains(@Nullable M expected) {
            this.usingCorrespondence().contains(expected);
        }

        @Override
        public void doesNotContain(@Nullable M excluded) {
            this.usingCorrespondence().doesNotContain(excluded);
        }

        @Override
        public Ordered containsExactly(M ... expected) {
            return this.usingCorrespondence().containsExactly((Object[])expected);
        }

        @Override
        public Ordered containsExactlyElementsIn(Iterable<? extends M> expected) {
            return this.usingCorrespondence().containsExactlyElementsIn(expected);
        }

        @Override
        public Ordered containsExactlyElementsIn(M[] expected) {
            return this.usingCorrespondence().containsExactlyElementsIn((Object[])expected);
        }

        @Override
        public Ordered containsAllOf(@Nullable M first, @Nullable M second, M ... rest) {
            return this.usingCorrespondence().containsAllOf(first, second, (Object[])rest);
        }

        @Override
        public Ordered containsAllIn(Iterable<? extends M> expected) {
            return this.usingCorrespondence().containsAllIn(expected);
        }

        @Override
        public Ordered containsAllIn(M[] expected) {
            return this.usingCorrespondence().containsAllIn((Object[])expected);
        }

        @Override
        public void containsAnyOf(@Nullable M first, @Nullable M second, M ... rest) {
            this.usingCorrespondence().containsAnyOf(first, second, (Object[])rest);
        }

        @Override
        public void containsAnyIn(Iterable<? extends M> expected) {
            this.usingCorrespondence().containsAnyIn(expected);
        }

        @Override
        public void containsAnyIn(M[] expected) {
            this.usingCorrespondence().containsAnyIn((Object[])expected);
        }

        @Override
        public void containsNoneOf(@Nullable M firstExcluded, @Nullable M secondExcluded, M ... restOfExcluded) {
            this.usingCorrespondence().containsNoneOf(firstExcluded, secondExcluded, (Object[])restOfExcluded);
        }

        @Override
        public void containsNoneIn(Iterable<? extends M> excluded) {
            this.usingCorrespondence().containsNoneIn(excluded);
        }

        @Override
        public void containsNoneIn(M[] excluded) {
            this.usingCorrespondence().containsNoneIn((Object[])excluded);
        }

        @Override
        @Deprecated
        public boolean equals(Object o) {
            return this.subject.equals(o);
        }

        @Override
        @Deprecated
        public int hashCode() {
            return this.subject.hashCode();
        }

        private final IterableSubject.UsingCorrespondence<M, M> usingCorrespondence() {
            return ((IterableOfProtosSubject)this.subject).usingCorrespondence();
        }
    }

    public static final class IterableOfMessagesSubject<M extends Message>
    extends IterableOfProtosSubject<IterableOfMessagesSubject<M>, M, Iterable<M>> {
        IterableOfMessagesSubject(FailureMetadata failureMetadata, @Nullable Iterable<M> messages) {
            super(failureMetadata, messages);
        }

        private IterableOfMessagesSubject(FailureMetadata failureMetadata, FluentEqualityConfig config, @Nullable Iterable<M> messages) {
            super(failureMetadata, config, messages);
        }
    }
}

