/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.auto.value.AutoValue;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.truth.Correspondence;
import com.google.common.truth.extensions.proto.AutoValue_FluentEqualityConfig;
import com.google.common.truth.extensions.proto.FieldScope;
import com.google.common.truth.extensions.proto.FieldScopeLogic;
import com.google.common.truth.extensions.proto.FieldScopeUtil;
import com.google.common.truth.extensions.proto.MessageDifferencer;
import com.google.common.truth.extensions.proto.ProtoTruth;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import javax.annotation.Nullable;

@AutoValue
abstract class FluentEqualityConfig {
    private static final FluentEqualityConfig DEFAULT_INSTANCE = new AutoValue_FluentEqualityConfig.Builder().setIgnoreFieldAbsence(false).setIgnoreRepeatedFieldOrder(false).setReportMismatchesOnly(false).setFieldScopeLogic(FieldScopeLogic.all()).setUsingCorrespondenceStringFunction((Function<? super Optional<Descriptors.Descriptor>, String>)Functions.constant((Object)"")).build();
    private final LoadingCache<Descriptors.Descriptor, MessageDifferencer> messageDifferencers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Descriptors.Descriptor, MessageDifferencer>(){

        public MessageDifferencer load(Descriptors.Descriptor descriptor) {
            return FluentEqualityConfig.this.makeMessageDifferencer(descriptor);
        }
    });

    FluentEqualityConfig() {
    }

    static FluentEqualityConfig defaultInstance() {
        return DEFAULT_INSTANCE;
    }

    abstract boolean ignoreFieldAbsence();

    abstract boolean ignoreRepeatedFieldOrder();

    abstract boolean reportMismatchesOnly();

    abstract FieldScopeLogic fieldScopeLogic();

    abstract Function<? super Optional<Descriptors.Descriptor>, String> usingCorrespondenceStringFunction();

    final String usingCorrespondenceString(Optional<Descriptors.Descriptor> descriptor) {
        return (String)this.usingCorrespondenceStringFunction().apply(descriptor);
    }

    final FluentEqualityConfig ignoringFieldAbsence() {
        return this.toBuilder().setIgnoreFieldAbsence(true).addUsingCorrespondenceString(".ignoringFieldAbsence()").build();
    }

    final FluentEqualityConfig ignoringRepeatedFieldOrder() {
        return this.toBuilder().setIgnoreRepeatedFieldOrder(true).addUsingCorrespondenceString(".ignoringRepeatedFieldOrder()").build();
    }

    final FluentEqualityConfig reportingMismatchesOnly() {
        return this.toBuilder().setReportMismatchesOnly(true).addUsingCorrespondenceString(".reportingMismatchesOnly()").build();
    }

    final FluentEqualityConfig withPartialScope(FieldScope partialScope) {
        return this.toBuilder().setFieldScopeLogic(FieldScopeLogic.and(this.fieldScopeLogic(), partialScope.logic())).addUsingCorrespondenceFieldScopeString(".withPartialScope(%s)", partialScope).build();
    }

    final FluentEqualityConfig ignoringFields(Iterable<Integer> fieldNumbers) {
        return this.toBuilder().setFieldScopeLogic(this.fieldScopeLogic().ignoringFields(fieldNumbers)).addUsingCorrespondenceFieldNumbersString(".ignoringFields(%s)", fieldNumbers).build();
    }

    final FluentEqualityConfig ignoringFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.toBuilder().setFieldScopeLogic(this.fieldScopeLogic().ignoringFieldDescriptors(fieldDescriptors)).addUsingCorrespondenceFieldDescriptorsString(".ignoringFieldDescriptors(%s)", fieldDescriptors).build();
    }

    final FluentEqualityConfig ignoringFieldScope(FieldScope fieldScope) {
        return this.toBuilder().setFieldScopeLogic(FieldScopeLogic.and(this.fieldScopeLogic(), FieldScopeLogic.not(fieldScope.logic()))).addUsingCorrespondenceFieldScopeString(".ignoringFieldScope(%s)", fieldScope).build();
    }

    private MessageDifferencer makeMessageDifferencer(Descriptors.Descriptor descriptor) {
        return MessageDifferencer.newBuilder().setMessageFieldComparison(this.ignoreFieldAbsence() ? MessageDifferencer.MessageFieldComparison.EQUIVALENT : MessageDifferencer.MessageFieldComparison.EQUAL).setRepeatedFieldComparison(this.ignoreRepeatedFieldOrder() ? MessageDifferencer.RepeatedFieldComparison.AS_SET : MessageDifferencer.RepeatedFieldComparison.AS_LIST).setReportMatches(!this.reportMismatchesOnly()).addIgnoreCriteria(this.fieldScopeLogic().toIgnoreCriteria(descriptor)).build();
    }

    final MessageDifferencer toMessageDifferencer(Descriptors.Descriptor descriptor) {
        return (MessageDifferencer)this.messageDifferencers.getUnchecked((Object)descriptor);
    }

    final <M extends Message> Correspondence<M, M> toCorrespondence(final Optional<Descriptors.Descriptor> optDescriptor) {
        return new Correspondence<M, M>(){

            public final boolean compare(@Nullable M actual, @Nullable M expected) {
                return ProtoTruth.assertThat(actual).usingConfig(FluentEqualityConfig.this).testIsEqualTo(expected);
            }

            public final String toString() {
                return "is equivalent according to assertThat(proto)" + FluentEqualityConfig.this.usingCorrespondenceString((Optional<Descriptors.Descriptor>)optDescriptor) + ".isEqualTo(target) to";
            }
        };
    }

    abstract Builder toBuilder();

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setIgnoreFieldAbsence(boolean var1);

        abstract Builder setIgnoreRepeatedFieldOrder(boolean var1);

        abstract Builder setReportMismatchesOnly(boolean var1);

        abstract Builder setFieldScopeLogic(FieldScopeLogic var1);

        abstract Function<? super Optional<Descriptors.Descriptor>, String> usingCorrespondenceStringFunction();

        abstract Builder setUsingCorrespondenceStringFunction(Function<? super Optional<Descriptors.Descriptor>, String> var1);

        abstract FluentEqualityConfig build();

        final Builder addUsingCorrespondenceString(String string) {
            return this.setUsingCorrespondenceStringFunction(FieldScopeUtil.concat(this.usingCorrespondenceStringFunction(), (Function<? super Optional<Descriptors.Descriptor>, String>)Functions.constant((Object)string)));
        }

        final Builder addUsingCorrespondenceFieldNumbersString(String fmt, Iterable<Integer> fieldNumbers) {
            return this.setUsingCorrespondenceStringFunction(FieldScopeUtil.concat(this.usingCorrespondenceStringFunction(), FieldScopeUtil.fieldNumbersFunction(fmt, fieldNumbers)));
        }

        final Builder addUsingCorrespondenceFieldDescriptorsString(String fmt, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.setUsingCorrespondenceStringFunction(FieldScopeUtil.concat(this.usingCorrespondenceStringFunction(), (Function<? super Optional<Descriptors.Descriptor>, String>)Functions.constant((Object)String.format(fmt, FieldScopeUtil.join(fieldDescriptors)))));
        }

        final Builder addUsingCorrespondenceFieldScopeString(String fmt, FieldScope fieldScope) {
            return this.setUsingCorrespondenceStringFunction(FieldScopeUtil.concat(this.usingCorrespondenceStringFunction(), FieldScopeUtil.fieldScopeFunction(fmt, fieldScope)));
        }
    }
}

