/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.auto.value.AutoValue;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.truth.extensions.proto.AutoValue_FieldScopeLogic_Context;
import com.google.common.truth.extensions.proto.FieldNumberTree;
import com.google.common.truth.extensions.proto.FieldScopeUtil;
import com.google.common.truth.extensions.proto.MessageDifferencer;
import com.google.common.truth.extensions.proto.ProtoTruthMessageDifferencer;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

abstract class FieldScopeLogic {
    private final Set<Descriptors.Descriptor> validatedDescriptors = Sets.newConcurrentHashSet();
    private static final FieldScopeLogic ALL = new FieldScopeLogic(){

        @Override
        boolean doMatchesFieldPath(Context context, Cache cache) {
            return true;
        }

        @Override
        public String toString() {
            return "FieldScopes.all()";
        }

        @Override
        final ProtoTruthMessageDifferencer.ShouldIgnore shouldIgnore(Descriptors.Descriptor rootDescriptor, ProtoTruthMessageDifferencer.FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            return ProtoTruthMessageDifferencer.ShouldIgnore.NO;
        }
    };
    private static final FieldScopeLogic NONE = new FieldScopeLogic(){

        @Override
        boolean doMatchesFieldPath(Context context, Cache cache) {
            return false;
        }

        @Override
        public String toString() {
            return "FieldScopes.none()";
        }

        @Override
        final ProtoTruthMessageDifferencer.ShouldIgnore shouldIgnore(Descriptors.Descriptor rootDescriptor, ProtoTruthMessageDifferencer.FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            return ProtoTruthMessageDifferencer.ShouldIgnore.YES;
        }
    };

    FieldScopeLogic() {
    }

    abstract ProtoTruthMessageDifferencer.ShouldIgnore shouldIgnore(Descriptors.Descriptor var1, ProtoTruthMessageDifferencer.FieldDescriptorOrUnknown var2);

    FieldScopeLogic subLogic(Descriptors.Descriptor rootDescriptor, ProtoTruthMessageDifferencer.FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
        return this;
    }

    boolean isRecursive() {
        return true;
    }

    final MessageDifferencer.IgnoreCriteria toIgnoreCriteria(final Descriptors.Descriptor descriptor) {
        if (!this.validatedDescriptors.contains(descriptor)) {
            this.validate(descriptor);
            this.validatedDescriptors.add(descriptor);
        }
        final Cache cache = new Cache();
        return new MessageDifferencer.IgnoreCriteria(){

            @Override
            public boolean isIgnored(Message message1, Message message2, @Nullable Descriptors.FieldDescriptor fieldDescriptor, List<MessageDifferencer.SpecificField> fieldPath) {
                ImmutableList.Builder subMessages = ImmutableList.builder();
                if (fieldDescriptor != null) {
                    FieldScopeLogic.addSubMessages(fieldDescriptor, message1, (ImmutableList.Builder<Message>)subMessages);
                    FieldScopeLogic.addSubMessages(fieldDescriptor, message2, (ImmutableList.Builder<Message>)subMessages);
                }
                Context context = Context.create(descriptor, fieldPath, fieldDescriptor, (ImmutableList.Builder<Message>)subMessages);
                cache.clearMethodCaches();
                return !FieldScopeLogic.this.matchesFieldPath(context, cache) && FieldScopeLogic.this.matchStateAppliesForAllSubPaths(context, cache);
            }
        };
    }

    private static void addSubMessages(Descriptors.FieldDescriptor fieldDescriptor, Message message, ImmutableList.Builder<Message> builder) {
        if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            return;
        }
        if (fieldDescriptor.isRepeated()) {
            for (int i = 0; i < message.getRepeatedFieldCount(fieldDescriptor); ++i) {
                builder.add((Object)((Message)message.getRepeatedField(fieldDescriptor, i)));
            }
        } else {
            builder.add((Object)((Message)message.getField(fieldDescriptor)));
        }
    }

    final boolean matchesFieldPath(Context context, Cache cache) {
        return cache.matchesFieldPath(this, context);
    }

    final boolean matchStateAppliesForAllSubPaths(Context context, Cache cache) {
        return cache.matchStateAppliesForAllSubPaths(this, context);
    }

    abstract boolean doMatchesFieldPath(Context var1, Cache var2);

    boolean doMatchStateAppliesForAllSubPaths(Context context, Cache cache) {
        return true;
    }

    public abstract String toString();

    void validate(Descriptors.Descriptor descriptor) {
    }

    private static boolean isEmpty(Iterable<?> container) {
        boolean isEmpty = true;
        for (Object element : container) {
            Preconditions.checkNotNull(element);
            isEmpty = false;
        }
        return isEmpty;
    }

    FieldScopeLogic ignoringFields(Iterable<Integer> fieldNumbers) {
        if (FieldScopeLogic.isEmpty(fieldNumbers)) {
            return this;
        }
        return FieldScopeLogic.and(this, new NegationFieldScopeLogic(new FieldNumbersLogic(fieldNumbers)));
    }

    FieldScopeLogic ignoringFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        if (FieldScopeLogic.isEmpty(fieldDescriptors)) {
            return this;
        }
        return FieldScopeLogic.and(this, new NegationFieldScopeLogic(new FieldDescriptorsLogic(fieldDescriptors)));
    }

    FieldScopeLogic allowingFields(Iterable<Integer> fieldNumbers) {
        if (FieldScopeLogic.isEmpty(fieldNumbers)) {
            return this;
        }
        return FieldScopeLogic.or(this, new FieldNumbersLogic(fieldNumbers));
    }

    FieldScopeLogic allowingFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        if (FieldScopeLogic.isEmpty(fieldDescriptors)) {
            return this;
        }
        return FieldScopeLogic.or(this, new FieldDescriptorsLogic(fieldDescriptors));
    }

    static FieldScopeLogic all() {
        return ALL;
    }

    static FieldScopeLogic none() {
        return NONE;
    }

    static FieldScopeLogic partialScope(Message message) {
        return new RootPartialScopeLogic(message);
    }

    static FieldScopeLogic and(FieldScopeLogic fieldScopeLogic1, FieldScopeLogic fieldScopeLogic2) {
        return new IntersectionFieldScopeLogic(fieldScopeLogic1, fieldScopeLogic2);
    }

    static FieldScopeLogic or(FieldScopeLogic fieldScopeLogic1, FieldScopeLogic fieldScopeLogic2) {
        return new UnionFieldScopeLogic(fieldScopeLogic1, fieldScopeLogic2);
    }

    static FieldScopeLogic not(FieldScopeLogic fieldScopeLogic) {
        return new NegationFieldScopeLogic(fieldScopeLogic);
    }

    private static final class NegationFieldScopeLogic
    extends CompoundFieldScopeLogic<NegationFieldScopeLogic> {
        NegationFieldScopeLogic(FieldScopeLogic subject) {
            super(subject);
        }

        @Override
        boolean doMatchStateAppliesForAllSubPaths(Context context, Cache cache) {
            return ((FieldScopeLogic)this.elements.get(0)).matchStateAppliesForAllSubPaths(context, cache);
        }

        @Override
        boolean doMatchesFieldPath(Context context, Cache cache) {
            return !((FieldScopeLogic)this.elements.get(0)).matchesFieldPath(context, cache);
        }

        @Override
        NegationFieldScopeLogic newLogicOfSameType(List<FieldScopeLogic> newElements) {
            Preconditions.checkArgument((newElements.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 element: %s", newElements);
            return new NegationFieldScopeLogic(newElements.get(0));
        }

        @Override
        ProtoTruthMessageDifferencer.ShouldIgnore shouldIgnore(Descriptors.Descriptor rootDescriptor, ProtoTruthMessageDifferencer.FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            ProtoTruthMessageDifferencer.ShouldIgnore op = ((FieldScopeLogic)this.elements.get(0)).shouldIgnore(rootDescriptor, fieldDescriptorOrUnknown);
            switch (op) {
                case YES: {
                    return ProtoTruthMessageDifferencer.ShouldIgnore.NO;
                }
                case NO: {
                    return ProtoTruthMessageDifferencer.ShouldIgnore.YES;
                }
                case MAYBE: {
                    return ProtoTruthMessageDifferencer.ShouldIgnore.MAYBE;
                }
            }
            throw new AssertionError((Object)("Impossible: " + (Object)((Object)op)));
        }

        @Override
        public String toString() {
            return String.format("!(%s)", this.elements.get(0));
        }
    }

    private static final class UnionFieldScopeLogic
    extends CompoundFieldScopeLogic<UnionFieldScopeLogic> {
        UnionFieldScopeLogic(FieldScopeLogic subject1, FieldScopeLogic subject2) {
            super(subject1, subject2);
        }

        @Override
        boolean doMatchStateAppliesForAllSubPaths(Context context, Cache cache) {
            if (this.matchesFieldPath(context, cache)) {
                boolean firstFixedTrue = ((FieldScopeLogic)this.elements.get(0)).matchesFieldPath(context, cache) && ((FieldScopeLogic)this.elements.get(0)).matchStateAppliesForAllSubPaths(context, cache);
                boolean secondFixedTrue = ((FieldScopeLogic)this.elements.get(1)).matchesFieldPath(context, cache) && ((FieldScopeLogic)this.elements.get(1)).matchStateAppliesForAllSubPaths(context, cache);
                return firstFixedTrue || secondFixedTrue;
            }
            return ((FieldScopeLogic)this.elements.get(0)).matchStateAppliesForAllSubPaths(context, cache) && ((FieldScopeLogic)this.elements.get(1)).matchStateAppliesForAllSubPaths(context, cache);
        }

        @Override
        boolean doMatchesFieldPath(Context context, Cache cache) {
            return ((FieldScopeLogic)this.elements.get(0)).matchesFieldPath(context, cache) || ((FieldScopeLogic)this.elements.get(1)).matchesFieldPath(context, cache);
        }

        @Override
        UnionFieldScopeLogic newLogicOfSameType(List<FieldScopeLogic> newElements) {
            Preconditions.checkArgument((newElements.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 elements: %s", newElements);
            return new UnionFieldScopeLogic(newElements.get(0), newElements.get(1));
        }

        @Override
        ProtoTruthMessageDifferencer.ShouldIgnore shouldIgnore(Descriptors.Descriptor rootDescriptor, ProtoTruthMessageDifferencer.FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            return UnionFieldScopeLogic.and(((FieldScopeLogic)this.elements.get(0)).shouldIgnore(rootDescriptor, fieldDescriptorOrUnknown), ((FieldScopeLogic)this.elements.get(1)).shouldIgnore(rootDescriptor, fieldDescriptorOrUnknown));
        }

        private static ProtoTruthMessageDifferencer.ShouldIgnore and(ProtoTruthMessageDifferencer.ShouldIgnore op1, ProtoTruthMessageDifferencer.ShouldIgnore op2) {
            if (op1 == ProtoTruthMessageDifferencer.ShouldIgnore.NO || op2 == ProtoTruthMessageDifferencer.ShouldIgnore.NO) {
                return ProtoTruthMessageDifferencer.ShouldIgnore.NO;
            }
            if (op1 == ProtoTruthMessageDifferencer.ShouldIgnore.YES && op2 == ProtoTruthMessageDifferencer.ShouldIgnore.YES) {
                return ProtoTruthMessageDifferencer.ShouldIgnore.YES;
            }
            return ProtoTruthMessageDifferencer.ShouldIgnore.MAYBE;
        }

        @Override
        public String toString() {
            return String.format("(%s || %s)", this.elements.get(0), this.elements.get(1));
        }
    }

    private static final class IntersectionFieldScopeLogic
    extends CompoundFieldScopeLogic<IntersectionFieldScopeLogic> {
        IntersectionFieldScopeLogic(FieldScopeLogic subject1, FieldScopeLogic subject2) {
            super(subject1, subject2);
        }

        @Override
        boolean doMatchStateAppliesForAllSubPaths(Context context, Cache cache) {
            if (this.matchesFieldPath(context, cache)) {
                return ((FieldScopeLogic)this.elements.get(0)).matchStateAppliesForAllSubPaths(context, cache) && ((FieldScopeLogic)this.elements.get(1)).matchStateAppliesForAllSubPaths(context, cache);
            }
            boolean firstFixedFalse = !((FieldScopeLogic)this.elements.get(0)).matchesFieldPath(context, cache) && ((FieldScopeLogic)this.elements.get(0)).matchStateAppliesForAllSubPaths(context, cache);
            boolean secondFixedFalse = !((FieldScopeLogic)this.elements.get(1)).matchesFieldPath(context, cache) && ((FieldScopeLogic)this.elements.get(1)).matchStateAppliesForAllSubPaths(context, cache);
            return firstFixedFalse || secondFixedFalse;
        }

        @Override
        boolean doMatchesFieldPath(Context context, Cache cache) {
            return ((FieldScopeLogic)this.elements.get(0)).matchesFieldPath(context, cache) && ((FieldScopeLogic)this.elements.get(1)).matchesFieldPath(context, cache);
        }

        @Override
        IntersectionFieldScopeLogic newLogicOfSameType(List<FieldScopeLogic> newElements) {
            Preconditions.checkArgument((newElements.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 elements: %s", newElements);
            return new IntersectionFieldScopeLogic(newElements.get(0), newElements.get(1));
        }

        @Override
        ProtoTruthMessageDifferencer.ShouldIgnore shouldIgnore(Descriptors.Descriptor rootDescriptor, ProtoTruthMessageDifferencer.FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            return IntersectionFieldScopeLogic.or(((FieldScopeLogic)this.elements.get(0)).shouldIgnore(rootDescriptor, fieldDescriptorOrUnknown), ((FieldScopeLogic)this.elements.get(1)).shouldIgnore(rootDescriptor, fieldDescriptorOrUnknown));
        }

        private static ProtoTruthMessageDifferencer.ShouldIgnore or(ProtoTruthMessageDifferencer.ShouldIgnore op1, ProtoTruthMessageDifferencer.ShouldIgnore op2) {
            if (op1 == ProtoTruthMessageDifferencer.ShouldIgnore.YES || op2 == ProtoTruthMessageDifferencer.ShouldIgnore.YES) {
                return ProtoTruthMessageDifferencer.ShouldIgnore.YES;
            }
            if (op1 == ProtoTruthMessageDifferencer.ShouldIgnore.NO && op2 == ProtoTruthMessageDifferencer.ShouldIgnore.NO) {
                return ProtoTruthMessageDifferencer.ShouldIgnore.NO;
            }
            return ProtoTruthMessageDifferencer.ShouldIgnore.MAYBE;
        }

        @Override
        public String toString() {
            return String.format("(%s && %s)", this.elements.get(0), this.elements.get(1));
        }
    }

    private static abstract class CompoundFieldScopeLogic<T extends CompoundFieldScopeLogic<T>>
    extends FieldScopeLogic {
        final ImmutableList<FieldScopeLogic> elements;
        final boolean isRecursive;

        CompoundFieldScopeLogic(FieldScopeLogic singleElem) {
            this.elements = ImmutableList.of((Object)singleElem);
            this.isRecursive = CompoundFieldScopeLogic.areAllRecursive(this.elements);
        }

        CompoundFieldScopeLogic(FieldScopeLogic firstElem, FieldScopeLogic secondElem) {
            this.elements = ImmutableList.of((Object)firstElem, (Object)secondElem);
            this.isRecursive = CompoundFieldScopeLogic.areAllRecursive(this.elements);
        }

        private static boolean areAllRecursive(ImmutableList<FieldScopeLogic> elements) {
            for (FieldScopeLogic elem : elements) {
                if (elem.isRecursive()) continue;
                return false;
            }
            return true;
        }

        @Override
        final void validate(Descriptors.Descriptor descriptor) {
            for (FieldScopeLogic elem : this.elements) {
                elem.validate(descriptor);
            }
        }

        abstract T newLogicOfSameType(List<FieldScopeLogic> var1);

        @Override
        final FieldScopeLogic subLogic(Descriptors.Descriptor rootDescriptor, ProtoTruthMessageDifferencer.FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            if (this.isRecursive()) {
                return this;
            }
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.elements.size());
            for (FieldScopeLogic elem : this.elements) {
                builder.add((Object)elem.subLogic(rootDescriptor, fieldDescriptorOrUnknown));
            }
            return this.newLogicOfSameType((List<FieldScopeLogic>)builder.build());
        }

        @Override
        final boolean isRecursive() {
            return this.isRecursive;
        }
    }

    private static final class FieldDescriptorsLogic
    extends FieldMatcherLogicBase {
        private final ImmutableSet<Descriptors.FieldDescriptor> fieldDescriptors;

        FieldDescriptorsLogic(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            this.fieldDescriptors = ImmutableSet.copyOf(fieldDescriptors);
        }

        @Override
        boolean matchesFieldDescriptor(Descriptors.Descriptor descriptor, Descriptors.FieldDescriptor fieldDescriptor) {
            return this.fieldDescriptors.contains((Object)fieldDescriptor);
        }

        @Override
        public String toString() {
            return String.format("FieldScopes.allowingFieldDescriptors(%s)", FieldScopeUtil.join(this.fieldDescriptors));
        }
    }

    private static final class FieldNumbersLogic
    extends FieldMatcherLogicBase {
        private final ImmutableSet<Integer> fieldNumbers;

        FieldNumbersLogic(Iterable<Integer> fieldNumbers) {
            this.fieldNumbers = ImmutableSet.copyOf(fieldNumbers);
        }

        @Override
        void validate(Descriptors.Descriptor descriptor) {
            super.validate(descriptor);
            UnmodifiableIterator unmodifiableIterator = this.fieldNumbers.iterator();
            while (unmodifiableIterator.hasNext()) {
                int fieldNumber = (Integer)unmodifiableIterator.next();
                Preconditions.checkArgument((descriptor.findFieldByNumber(fieldNumber) != null ? 1 : 0) != 0, (String)"Message type %s has no field with number %s.", (Object)descriptor.getFullName(), (int)fieldNumber);
            }
        }

        @Override
        boolean matchesFieldDescriptor(Descriptors.Descriptor descriptor, Descriptors.FieldDescriptor fieldDescriptor) {
            return fieldDescriptor.getContainingType() == descriptor && this.fieldNumbers.contains((Object)fieldDescriptor.getNumber());
        }

        @Override
        public String toString() {
            return String.format("FieldScopes.allowingFields(%s)", FieldScopeUtil.join(this.fieldNumbers));
        }
    }

    private static abstract class FieldMatcherLogicBase
    extends FieldScopeLogic {
        private FieldMatcherLogicBase() {
        }

        abstract boolean matchesFieldDescriptor(Descriptors.Descriptor var1, Descriptors.FieldDescriptor var2);

        @Override
        final boolean doMatchesFieldPath(Context context, Cache cache) {
            if (context.field().isPresent() && this.matchesFieldDescriptor(context.descriptor(), (Descriptors.FieldDescriptor)context.field().get())) {
                return true;
            }
            for (MessageDifferencer.SpecificField field : context.fieldPath()) {
                Descriptors.FieldDescriptor specificFieldDescriptor = field.getField();
                if (specificFieldDescriptor == null || !this.matchesFieldDescriptor(context.descriptor(), specificFieldDescriptor)) continue;
                return true;
            }
            return false;
        }

        @Override
        final boolean doMatchStateAppliesForAllSubPaths(Context context, Cache cache) {
            if (!this.matchesFieldPath(context, cache)) {
                for (Message message : context.messageFields()) {
                    if (!this.messageHasMatchingField(context, cache, message)) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean messageHasMatchingField(Context context, Cache cache, Message message) {
            Map<Message, Boolean> messagesWithMatchingField = cache.getMessagesWithMatchingField(this);
            if (messagesWithMatchingField.containsKey(message)) {
                return messagesWithMatchingField.get(message);
            }
            boolean result = false;
            Map fields = message.getAllFields();
            for (Descriptors.FieldDescriptor key : fields.keySet()) {
                if (this.matchesFieldDescriptor(context.descriptor(), key)) {
                    result = true;
                } else if (key.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                    if (key.isRepeated()) {
                        for (int i = 0; i < message.getRepeatedFieldCount(key); ++i) {
                            if (!this.messageHasMatchingField(context, cache, (Message)message.getRepeatedField(key, i))) continue;
                            result = true;
                            break;
                        }
                    } else if (this.messageHasMatchingField(context, cache, (Message)message.getField(key))) {
                        result = true;
                    }
                }
                if (!result) continue;
                break;
            }
            messagesWithMatchingField.put(message, result);
            return result;
        }

        @Override
        final ProtoTruthMessageDifferencer.ShouldIgnore shouldIgnore(Descriptors.Descriptor rootDescriptor, ProtoTruthMessageDifferencer.FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            if (fieldDescriptorOrUnknown.unknownFieldDescriptor().isPresent()) {
                return ProtoTruthMessageDifferencer.ShouldIgnore.YES;
            }
            Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)fieldDescriptorOrUnknown.fieldDescriptor().get();
            if (this.matchesFieldDescriptor(rootDescriptor, fieldDescriptor)) {
                return ProtoTruthMessageDifferencer.ShouldIgnore.NO;
            }
            return fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? ProtoTruthMessageDifferencer.ShouldIgnore.MAYBE : ProtoTruthMessageDifferencer.ShouldIgnore.YES;
        }

        @Override
        final boolean isRecursive() {
            return false;
        }

        @Override
        final FieldScopeLogic subLogic(Descriptors.Descriptor rootDescriptor, ProtoTruthMessageDifferencer.FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            ProtoTruthMessageDifferencer.ShouldIgnore shouldIgnore = this.shouldIgnore(rootDescriptor, fieldDescriptorOrUnknown);
            switch (shouldIgnore) {
                case YES: {
                    return FieldMatcherLogicBase.none();
                }
                case NO: {
                    return FieldMatcherLogicBase.all();
                }
                case MAYBE: {
                    return this;
                }
            }
            throw new AssertionError((Object)("Unexpected enum: " + (Object)((Object)shouldIgnore)));
        }
    }

    private static final class RootPartialScopeLogic
    extends PartialScopeLogic {
        private final Message message;
        private final Descriptors.Descriptor expectedDescriptor;

        RootPartialScopeLogic(Message message) {
            super(FieldNumberTree.fromMessage(message));
            this.message = message;
            this.expectedDescriptor = message.getDescriptorForType();
        }

        @Override
        void validate(Descriptors.Descriptor descriptor) {
            Preconditions.checkArgument((boolean)this.expectedDescriptor.equals(descriptor), (String)"Message given to FieldScopes.fromSetFields() does not have the same descriptor as the message being tested. Expected %s, got %s.", (Object)this.expectedDescriptor.getFullName(), (Object)descriptor.getFullName());
        }

        @Override
        public String toString() {
            return String.format("FieldScopes.fromSetFields(%s)", this.message);
        }
    }

    private static class PartialScopeLogic
    extends FieldScopeLogic {
        private static final PartialScopeLogic EMPTY = new PartialScopeLogic(FieldNumberTree.empty());
        private final FieldNumberTree fieldNumberTree;

        PartialScopeLogic(FieldNumberTree fieldNumberTree) {
            this.fieldNumberTree = fieldNumberTree;
        }

        @Override
        boolean doMatchesFieldPath(Context context, Cache cache) {
            return this.fieldNumberTree.matches(context.fieldPath(), context.field());
        }

        @Override
        public String toString() {
            return String.format("PartialScopeLogic(%s)", this.fieldNumberTree);
        }

        @Override
        final ProtoTruthMessageDifferencer.ShouldIgnore shouldIgnore(Descriptors.Descriptor rootDescriptor, ProtoTruthMessageDifferencer.FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            return this.fieldNumberTree.hasChild(fieldDescriptorOrUnknown) ? ProtoTruthMessageDifferencer.ShouldIgnore.NO : ProtoTruthMessageDifferencer.ShouldIgnore.YES;
        }

        @Override
        final FieldScopeLogic subLogic(Descriptors.Descriptor rootDescriptor, ProtoTruthMessageDifferencer.FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            return PartialScopeLogic.newPartialScopeLogic(this.fieldNumberTree.child(fieldDescriptorOrUnknown));
        }

        @Override
        boolean isRecursive() {
            return this.fieldNumberTree.isEmpty();
        }

        private static PartialScopeLogic newPartialScopeLogic(FieldNumberTree fieldNumberTree) {
            return fieldNumberTree.isEmpty() ? EMPTY : new PartialScopeLogic(fieldNumberTree);
        }
    }

    @AutoValue
    static abstract class Context {
        Context() {
        }

        abstract Descriptors.Descriptor descriptor();

        abstract List<MessageDifferencer.SpecificField> fieldPath();

        abstract Optional<Descriptors.FieldDescriptor> field();

        abstract ImmutableList<Message> messageFields();

        static Context create(Descriptors.Descriptor descriptor, List<MessageDifferencer.SpecificField> fieldPath, @Nullable Descriptors.FieldDescriptor field, ImmutableList.Builder<Message> messageFields) {
            return new AutoValue_FieldScopeLogic_Context(descriptor, fieldPath, (Optional<Descriptors.FieldDescriptor>)Optional.fromNullable((Object)field), (ImmutableList<Message>)messageFields.build());
        }
    }

    private static final class Cache {
        private final Map<FieldMatcherLogicBase, Map<Message, Boolean>> messagesWithMatchingField = Maps.newHashMap();
        private final Map<FieldScopeLogic, Boolean> matchesFieldPath = Maps.newHashMap();
        private final Map<FieldScopeLogic, Boolean> matchStateAppliesForAllSubPaths = Maps.newHashMap();

        private Cache() {
        }

        public Map<Message, Boolean> getMessagesWithMatchingField(FieldMatcherLogicBase key) {
            HashMap map = this.messagesWithMatchingField.get(key);
            if (map == null) {
                map = Maps.newHashMap();
                this.messagesWithMatchingField.put(key, map);
            }
            return map;
        }

        public boolean matchesFieldPath(FieldScopeLogic logic, Context context) {
            Boolean match = this.matchesFieldPath.get(logic);
            if (match == null) {
                match = logic.doMatchesFieldPath(context, this);
                this.matchesFieldPath.put(logic, match);
            }
            return match;
        }

        public boolean matchStateAppliesForAllSubPaths(FieldScopeLogic logic, Context context) {
            Boolean matchAppliesForAll = this.matchStateAppliesForAllSubPaths.get(logic);
            if (matchAppliesForAll == null) {
                matchAppliesForAll = logic.doMatchStateAppliesForAllSubPaths(context, this);
                this.matchStateAppliesForAllSubPaths.put(logic, matchAppliesForAll);
            }
            return matchAppliesForAll;
        }

        public void clearMethodCaches() {
            this.matchesFieldPath.clear();
            this.matchStateAppliesForAllSubPaths.clear();
        }
    }
}

