/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import com.google.common.truth.extensions.proto.AutoValue_ProtoSubject_ReporterRecord;
import com.google.common.truth.extensions.proto.FieldScope;
import com.google.common.truth.extensions.proto.FieldScopeUtil;
import com.google.common.truth.extensions.proto.FluentEqualityConfig;
import com.google.common.truth.extensions.proto.LiteProtoSubject;
import com.google.common.truth.extensions.proto.MessageDifferencer;
import com.google.common.truth.extensions.proto.ProtoFluentAssertion;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ProtoSubject<S extends ProtoSubject<S, M>, M extends Message>
extends LiteProtoSubject<S, M>
implements ProtoFluentAssertion {
    private final FluentEqualityConfig config;

    protected ProtoSubject(FailureMetadata failureMetadata, @Nullable M message) {
        this(failureMetadata, FluentEqualityConfig.defaultInstance(), message);
    }

    ProtoSubject(FailureMetadata failureMetadata, FluentEqualityConfig config, @Nullable M message) {
        super(failureMetadata, message);
        this.config = config;
    }

    ProtoSubject<?, Message> usingConfig(FluentEqualityConfig newConfig) {
        MessageSubject newSubject = (MessageSubject)this.check().about(MessageSubject.messages(newConfig)).that(this.actual());
        if (this.internalCustomName() != null) {
            newSubject = (MessageSubject)newSubject.named(this.internalCustomName(), new Object[0]);
        }
        return newSubject;
    }

    @Override
    public ProtoFluentAssertion ignoringFieldAbsence() {
        return this.usingConfig(this.config.ignoringFieldAbsence());
    }

    @Override
    public ProtoFluentAssertion ignoringRepeatedFieldOrder() {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrder());
    }

    @Override
    public ProtoFluentAssertion withPartialScope(FieldScope fieldScope) {
        return this.usingConfig(this.config.withPartialScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    @Override
    public ProtoFluentAssertion ignoringFields(int firstFieldNumber, int ... rest) {
        return this.ignoringFields(FieldScopeUtil.asList(firstFieldNumber, rest));
    }

    @Override
    public ProtoFluentAssertion ignoringFields(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringFields(fieldNumbers));
    }

    @Override
    public ProtoFluentAssertion ignoringFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.ignoringFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest));
    }

    @Override
    public ProtoFluentAssertion ignoringFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringFieldDescriptors(fieldDescriptors));
    }

    @Override
    public ProtoFluentAssertion ignoringFieldScope(FieldScope fieldScope) {
        return this.usingConfig(this.config.ignoringFieldScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    @Override
    public ProtoFluentAssertion reportingMismatchesOnly() {
        return this.usingConfig(this.config.reportingMismatchesOnly());
    }

    @Override
    public void isEqualTo(@Nullable Object expected) {
        if (this.getSubject() == null || expected == null || ((Message)this.getSubject()).getClass() != expected.getClass()) {
            super.isEqualTo(expected);
        } else {
            Reporter reporter = new Reporter();
            if (!this.makeDifferencer().compare((Message)expected, (Message)this.getSubject(), reporter)) {
                reporter.failEqual((Message)expected);
            }
        }
    }

    boolean testIsEqualTo(@Nullable Object expected) {
        if (this.getSubject() == null || expected == null) {
            return this.getSubject() == expected;
        }
        if (((Message)this.getSubject()).getClass() != expected.getClass()) {
            return false;
        }
        return this.makeDifferencer().compare((Message)expected, (Message)this.getSubject(), null);
    }

    @Override
    public void isNotEqualTo(@Nullable Object expected) {
        if (this.getSubject() == null || expected == null || ((Message)this.getSubject()).getClass() != expected.getClass()) {
            super.isNotEqualTo(expected);
        } else {
            Reporter reporter = new Reporter();
            if (this.makeDifferencer().compare((Message)expected, (Message)this.getSubject(), reporter)) {
                reporter.failNotEqual((Message)expected);
            }
        }
    }

    public void hasAllRequiredFields() {
        if (!((Message)this.getSubject()).isInitialized()) {
            this.failWithRawMessage("Not true that %s has all required fields set. Missing: %s", new Object[]{this.getTrimmedDisplaySubject(), ((Message)this.getSubject()).findInitializationErrors()});
        }
    }

    private MessageDifferencer makeDifferencer() {
        return this.config.toMessageDifferencer(((Message)this.getSubject()).getDescriptorForType());
    }

    static final class MessageSubject
    extends ProtoSubject<MessageSubject, Message> {
        static Subject.Factory<MessageSubject, Message> messages(final FluentEqualityConfig config) {
            return new Subject.Factory<MessageSubject, Message>(){

                public MessageSubject createSubject(FailureMetadata failureMetadata, Message actual) {
                    return new MessageSubject(failureMetadata, config, actual);
                }
            };
        }

        MessageSubject(FailureMetadata failureMetadata, @Nullable Message message) {
            super(failureMetadata, message);
        }

        private MessageSubject(FailureMetadata failureMetadata, FluentEqualityConfig config, @Nullable Message message) {
            super(failureMetadata, config, message);
        }
    }

    @AutoValue
    static abstract class ReporterRecord {
        ReporterRecord() {
        }

        abstract MessageDifferencer.ReportType type();

        abstract Message message1();

        abstract Message message2();

        abstract ImmutableList<MessageDifferencer.SpecificField> path();

        final boolean isFailure() {
            return this.type() == MessageDifferencer.ReportType.ADDED || this.type() == MessageDifferencer.ReportType.DELETED || this.type() == MessageDifferencer.ReportType.MODIFIED;
        }

        static ReporterRecord of(MessageDifferencer.ReportType type, Message message1, Message message2, ImmutableList<MessageDifferencer.SpecificField> path) {
            return new AutoValue_ProtoSubject_ReporterRecord(type, message1, message2, path);
        }
    }

    private class Reporter
    implements MessageDifferencer.Reporter {
        private final List<ReporterRecord> records = new ArrayList<ReporterRecord>();
        private boolean anyFailures = false;
        private boolean anyNotices = false;

        private Reporter() {
        }

        @Override
        public void report(MessageDifferencer.ReportType type, Message message1, Message message2, ImmutableList<MessageDifferencer.SpecificField> path) {
            ReporterRecord record = ReporterRecord.of(type, message1, message2, path);
            this.anyFailures |= record.isFailure();
            this.anyNotices |= !record.isFailure();
            this.records.add(record);
        }

        void failEqual(Message expected) {
            StringBuilder rawMessage = new StringBuilder();
            rawMessage.append("Not true that ");
            if (ProtoSubject.this.internalCustomName() != null) {
                rawMessage.append(ProtoSubject.this.internalCustomName()).append(" compares equal. ");
            } else {
                rawMessage.append("messages compare equal. ");
            }
            MessageDifferencer.StreamReporter streamReporter = new MessageDifferencer.StreamReporter(rawMessage);
            if (this.anyFailures) {
                rawMessage.append("Differences were found:\n");
                for (ReporterRecord record : this.records) {
                    if (!record.isFailure()) continue;
                    streamReporter.report(record.type(), record.message1(), record.message2(), record.path());
                }
                if (this.anyNotices && !ProtoSubject.this.config.reportMismatchesOnly()) {
                    rawMessage.append("\nFull diff:\n");
                    for (ReporterRecord record : this.records) {
                        streamReporter.report(record.type(), record.message1(), record.message2(), record.path());
                    }
                }
            } else {
                rawMessage.append("No differences were reported.");
                if (!ProtoSubject.this.config.reportMismatchesOnly()) {
                    if (this.anyNotices) {
                        rawMessage.append("\nFull diff:\n");
                        for (ReporterRecord record : this.records) {
                            streamReporter.report(record.type(), record.message1(), record.message2(), record.path());
                        }
                    } else {
                        rawMessage.append("\nActual:\n");
                        rawMessage.append(TextFormat.printToString((MessageOrBuilder)((MessageOrBuilder)ProtoSubject.this.getSubject())));
                        rawMessage.append("Expected:\n");
                        rawMessage.append(TextFormat.printToString((MessageOrBuilder)expected));
                    }
                }
            }
            ProtoSubject.this.failWithRawMessage(rawMessage.toString(), new Object[0]);
        }

        void failNotEqual(Message expected) {
            StringBuilder rawMessage = new StringBuilder();
            rawMessage.append("Not true that ");
            if (ProtoSubject.this.internalCustomName() != null) {
                rawMessage.append(ProtoSubject.this.internalCustomName()).append(" compares not equal. ");
            } else {
                rawMessage.append("messages compare not equal. ");
            }
            if (!this.records.isEmpty() && !ProtoSubject.this.config.reportMismatchesOnly()) {
                rawMessage.append("Only ignorable differences were found:\n");
                MessageDifferencer.StreamReporter streamReporter = new MessageDifferencer.StreamReporter(rawMessage);
                for (ReporterRecord record : this.records) {
                    streamReporter.report(record.type(), record.message1(), record.message2(), record.path());
                }
            } else {
                rawMessage.append("No differences were found.");
                if (!ProtoSubject.this.config.reportMismatchesOnly()) {
                    rawMessage.append("\nActual:\n");
                    rawMessage.append(TextFormat.printToString((MessageOrBuilder)((MessageOrBuilder)ProtoSubject.this.getSubject())));
                    rawMessage.append("Expected:\n");
                    rawMessage.append(TextFormat.printToString((MessageOrBuilder)expected));
                }
            }
            ProtoSubject.this.failWithRawMessage(rawMessage.toString(), new Object[0]);
        }
    }
}

