/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.truth.Correspondence;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.MultimapSubject;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.common.truth.extensions.proto.FieldScope;
import com.google.common.truth.extensions.proto.FieldScopeUtil;
import com.google.common.truth.extensions.proto.FluentEqualityConfig;
import com.google.common.truth.extensions.proto.IterableOfProtosSubject;
import com.google.common.truth.extensions.proto.MultimapWithProtoValuesFluentAssertion;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import javax.annotation.Nullable;

public class MultimapWithProtoValuesSubject<S extends MultimapWithProtoValuesSubject<S, K, M, C>, K, M extends Message, C extends Multimap<K, M>>
extends Subject<S, C> {
    private final FluentEqualityConfig config;

    private static <K, M extends Message> Subject.Factory<MultimapWithMessageValuesSubject<K, M>, Multimap<K, M>> multimapWithMessageValues(final FluentEqualityConfig config) {
        return new Subject.Factory<MultimapWithMessageValuesSubject<K, M>, Multimap<K, M>>(){

            public MultimapWithMessageValuesSubject<K, M> createSubject(FailureMetadata metadata, Multimap<K, M> actual) {
                return new MultimapWithMessageValuesSubject(metadata, config, actual);
            }
        };
    }

    protected MultimapWithProtoValuesSubject(FailureMetadata failureMetadata, @Nullable C multimap) {
        this(failureMetadata, FluentEqualityConfig.defaultInstance(), multimap);
    }

    MultimapWithProtoValuesSubject(FailureMetadata failureMetadata, FluentEqualityConfig config, @Nullable C multimap) {
        super(failureMetadata, multimap);
        this.config = config;
    }

    private final MultimapSubject delegate() {
        MultimapSubject delegate = this.check().that((Multimap)this.actual());
        if (this.internalCustomName() != null) {
            delegate = (MultimapSubject)delegate.named(this.internalCustomName(), new Object[0]);
        }
        return delegate;
    }

    public void isEmpty() {
        this.delegate().isEmpty();
    }

    public void isNotEmpty() {
        this.delegate().isNotEmpty();
    }

    public void hasSize(int expectedSize) {
        this.delegate().hasSize(expectedSize);
    }

    public void containsKey(@Nullable Object key) {
        this.delegate().containsKey(key);
    }

    public void doesNotContainKey(@Nullable Object key) {
        this.delegate().doesNotContainKey(key);
    }

    public void containsEntry(@Nullable Object key, @Nullable Object value) {
        this.delegate().containsEntry(key, value);
    }

    public void doesNotContainEntry(@Nullable Object key, @Nullable Object value) {
        this.delegate().doesNotContainEntry(key, value);
    }

    static <M extends Message> Subject.Factory<IterableValuesForKey<M>, Iterable<M>> iterableOfProtos(final String stringRepresentation) {
        return new Subject.Factory<IterableValuesForKey<M>, Iterable<M>>(){

            public IterableValuesForKey<M> createSubject(FailureMetadata metadata, Iterable<M> actual) {
                return new IterableValuesForKey(metadata, actual, stringRepresentation);
            }
        };
    }

    public IterableOfProtosSubject<?, M, Iterable<M>> valuesForKey(@Nullable Object key) {
        Subject.Factory<IterableValuesForKey<M>, Iterable<M>> factory = MultimapWithProtoValuesSubject.iterableOfProtos("Values for key <" + key + "> (<" + this.actual() + ">) in " + this.actualAsString());
        return (IterableOfProtosSubject)this.check().about(factory).that((Object)((Multimap)this.actual()).get(key));
    }

    @CanIgnoreReturnValue
    public Ordered containsExactlyEntriesIn(Multimap<?, ?> expectedMultimap) {
        return this.delegate().containsExactlyEntriesIn(expectedMultimap);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly(@Nullable Object k0, @Nullable Object v0, Object ... rest) {
        return this.delegate().containsExactly(k0, v0, rest);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly() {
        return this.delegate().containsExactly();
    }

    public <A, E> MultimapSubject.UsingCorrespondence<A, E> comparingValuesUsing(Correspondence<A, E> correspondence) {
        return this.delegate().comparingValuesUsing(correspondence);
    }

    MultimapWithProtoValuesFluentAssertion<M> usingConfig(FluentEqualityConfig newConfig) {
        Subject.Factory<MultimapWithMessageValuesSubject<K, M>, Multimap<K, M>> factory = MultimapWithProtoValuesSubject.multimapWithMessageValues(newConfig);
        MultimapWithMessageValuesSubject newSubject = (MultimapWithMessageValuesSubject)this.check().about(factory).that(this.actual());
        if (this.internalCustomName() != null) {
            newSubject = (MultimapWithMessageValuesSubject)newSubject.named(this.internalCustomName(), new Object[0]);
        }
        return new MultimapWithProtoValuesFluentAssertionImpl(newSubject);
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceForValues() {
        return this.usingConfig(this.config.ignoringFieldAbsence());
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderForValues() {
        return this.usingConfig(this.config.ignoringRepeatedFieldOrder());
    }

    public MultimapWithProtoValuesFluentAssertion<M> withPartialScopeForValues(FieldScope fieldScope) {
        return this.usingConfig(this.config.withPartialScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(int firstFieldNumber, int ... rest) {
        return this.ignoringFieldsForValues(FieldScopeUtil.asList(firstFieldNumber, rest));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(Iterable<Integer> fieldNumbers) {
        return this.usingConfig(this.config.ignoringFields(fieldNumbers));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.ignoringFieldDescriptorsForValues(Lists.asList((Object)firstFieldDescriptor, (Object[])rest));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return this.usingConfig(this.config.ignoringFieldDescriptors(fieldDescriptors));
    }

    public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldScopeForValues(FieldScope fieldScope) {
        return this.usingConfig(this.config.ignoringFieldScope((FieldScope)Preconditions.checkNotNull((Object)fieldScope, (Object)"fieldScope")));
    }

    public MultimapWithProtoValuesFluentAssertion<M> reportingMismatchesOnlyForValues() {
        return this.usingConfig(this.config.reportingMismatchesOnly());
    }

    private MultimapSubject.UsingCorrespondence<M, M> usingCorrespondence() {
        return this.comparingValuesUsing(this.config.toCorrespondence(FieldScopeUtil.getSingleDescriptor(((Multimap)this.actual()).values())));
    }

    private static final class MultimapWithProtoValuesFluentAssertionImpl<M extends Message>
    implements MultimapWithProtoValuesFluentAssertion<M> {
        private final MultimapWithProtoValuesSubject<?, ?, M, ?> subject;

        MultimapWithProtoValuesFluentAssertionImpl(MultimapWithProtoValuesSubject<?, ?, M, ?> subject) {
            this.subject = subject;
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldAbsenceForValues() {
            return this.subject.ignoringFieldAbsenceForValues();
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringRepeatedFieldOrderForValues() {
            return this.subject.ignoringRepeatedFieldOrderForValues();
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> withPartialScopeForValues(FieldScope fieldScope) {
            return this.subject.withPartialScopeForValues(fieldScope);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(int firstFieldNumber, int ... rest) {
            return this.subject.ignoringFieldsForValues(firstFieldNumber, rest);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldsForValues(Iterable<Integer> fieldNumbers) {
            return this.subject.ignoringFieldsForValues(fieldNumbers);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
            return this.subject.ignoringFieldDescriptorsForValues(firstFieldDescriptor, rest);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldDescriptorsForValues(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
            return this.subject.ignoringFieldDescriptorsForValues(fieldDescriptors);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> ignoringFieldScopeForValues(FieldScope fieldScope) {
            return this.subject.ignoringFieldScopeForValues(fieldScope);
        }

        @Override
        public MultimapWithProtoValuesFluentAssertion<M> reportingMismatchesOnlyForValues() {
            return this.subject.reportingMismatchesOnlyForValues();
        }

        @Override
        public void containsEntry(@Nullable Object expectedKey, @Nullable M expectedValue) {
            this.usingCorrespondence().containsEntry(expectedKey, expectedValue);
        }

        @Override
        public void doesNotContainEntry(@Nullable Object excludedKey, @Nullable M excludedValue) {
            this.usingCorrespondence().doesNotContainEntry(excludedKey, excludedValue);
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsExactlyEntriesIn(Multimap<?, ? extends M> expectedMap) {
            return this.usingCorrespondence().containsExactlyEntriesIn(expectedMap);
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsExactly() {
            return this.usingCorrespondence().containsExactly();
        }

        @Override
        @CanIgnoreReturnValue
        public Ordered containsExactly(@Nullable Object k0, @Nullable M v0, Object ... rest) {
            return this.usingCorrespondence().containsExactly(k0, v0, rest);
        }

        @Override
        @Deprecated
        public boolean equals(Object o) {
            return this.subject.equals(o);
        }

        @Override
        @Deprecated
        public int hashCode() {
            return this.subject.hashCode();
        }

        private final MultimapSubject.UsingCorrespondence<M, M> usingCorrespondence() {
            return ((MultimapWithProtoValuesSubject)this.subject).usingCorrespondence();
        }
    }

    private static class IterableValuesForKey<M extends Message>
    extends IterableOfProtosSubject<IterableValuesForKey<M>, M, Iterable<M>> {
        private final String stringRepresentation;

        IterableValuesForKey(FailureMetadata failureMetadata, Iterable<M> actual, String stringRepresentation) {
            super(failureMetadata, actual);
            this.stringRepresentation = stringRepresentation;
        }

        protected String actualCustomStringRepresentation() {
            return this.stringRepresentation;
        }
    }

    public static class MultimapWithMessageValuesSubject<K, M extends Message>
    extends MultimapWithProtoValuesSubject<MultimapWithMessageValuesSubject<K, M>, K, M, Multimap<K, M>> {
        MultimapWithMessageValuesSubject(FailureMetadata failureMetadata, @Nullable Multimap<K, M> multimap) {
            super(failureMetadata, multimap);
        }

        private MultimapWithMessageValuesSubject(FailureMetadata failureMetadata, FluentEqualityConfig config, @Nullable Multimap<K, M> multimap) {
            super(failureMetadata, config, multimap);
        }
    }
}

