/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.auto.value.AutoValue;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.truth.extensions.proto.AutoValue_FieldNumberTree_Key;
import com.google.common.truth.extensions.proto.MessageDifferencer;
import com.google.common.truth.extensions.proto.ProtoTruthMessageDifferencer;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class FieldNumberTree {
    private static final FieldNumberTree EMPTY = new FieldNumberTree();
    private final Map<Key, FieldNumberTree> children = Maps.newHashMap();

    FieldNumberTree() {
    }

    static FieldNumberTree empty() {
        return EMPTY;
    }

    boolean isEmpty() {
        return this.children.isEmpty();
    }

    FieldNumberTree child(ProtoTruthMessageDifferencer.FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
        FieldNumberTree child = this.children.get(Key.fromFieldDescriptorOrUnknown(fieldDescriptorOrUnknown));
        return child == null ? EMPTY : child;
    }

    boolean hasChild(ProtoTruthMessageDifferencer.FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
        return this.children.containsKey(Key.fromFieldDescriptorOrUnknown(fieldDescriptorOrUnknown));
    }

    static FieldNumberTree fromMessage(Message message) {
        FieldNumberTree tree = new FieldNumberTree();
        Map knownFieldValues = message.getAllFields();
        for (Descriptors.FieldDescriptor field : knownFieldValues.keySet()) {
            Key key = Key.known(field.getNumber());
            FieldNumberTree childTree = new FieldNumberTree();
            tree.children.put(key, childTree);
            Object fieldValue = knownFieldValues.get(field);
            if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
            if (field.isRepeated()) {
                List valueList = (List)fieldValue;
                for (Object value : valueList) {
                    childTree.merge(FieldNumberTree.fromMessage((Message)value));
                }
                continue;
            }
            childTree.merge(FieldNumberTree.fromMessage((Message)fieldValue));
        }
        tree.merge(FieldNumberTree.fromUnknownFieldSet(message.getUnknownFields()));
        return tree;
    }

    private static FieldNumberTree fromUnknownFieldSet(UnknownFieldSet unknownFieldSet) {
        FieldNumberTree tree = new FieldNumberTree();
        Iterator iterator = unknownFieldSet.asMap().keySet().iterator();
        while (iterator.hasNext()) {
            int fieldNumber = (Integer)iterator.next();
            UnknownFieldSet.Field unknownField = (UnknownFieldSet.Field)unknownFieldSet.asMap().get(fieldNumber);
            for (ProtoTruthMessageDifferencer.UnknownFieldDescriptor unknownFieldDescriptor : ProtoTruthMessageDifferencer.UnknownFieldDescriptor.descriptors(fieldNumber, unknownField)) {
                Key key = Key.unknown(unknownFieldDescriptor);
                FieldNumberTree childTree = new FieldNumberTree();
                tree.children.put(key, childTree);
                if (unknownFieldDescriptor.type() != ProtoTruthMessageDifferencer.UnknownFieldDescriptor.Type.GROUP) continue;
                for (Object group : unknownFieldDescriptor.type().getValues(unknownField)) {
                    childTree.merge(FieldNumberTree.fromUnknownFieldSet((UnknownFieldSet)group));
                }
            }
        }
        return tree;
    }

    private void merge(FieldNumberTree other) {
        for (Key key : other.children.keySet()) {
            FieldNumberTree value = other.children.get(key);
            if (!this.children.containsKey(key)) {
                this.children.put(key, value);
                continue;
            }
            this.children.get(key).merge(value);
        }
    }

    boolean matches(List<MessageDifferencer.SpecificField> fieldPath, Optional<Descriptors.FieldDescriptor> fieldDescriptor) {
        return this.matchesInternal(0, fieldPath, fieldDescriptor);
    }

    private boolean matchesInternal(int fieldPathIndex, List<MessageDifferencer.SpecificField> fieldPath, Optional<Descriptors.FieldDescriptor> fieldDescriptor) {
        if (fieldPathIndex < fieldPath.size()) {
            Key key;
            MessageDifferencer.SpecificField field = fieldPath.get(fieldPathIndex);
            if (field.getField() != null) {
                key = Key.known(field.getField().getNumber());
            } else {
                ProtoTruthMessageDifferencer.UnknownFieldDescriptor.Type type = (ProtoTruthMessageDifferencer.UnknownFieldDescriptor.Type)((Object)ProtoTruthMessageDifferencer.UnknownFieldDescriptor.Type.all().get(field.getUnknown().getFieldType().ordinal()));
                key = Key.unknown(ProtoTruthMessageDifferencer.UnknownFieldDescriptor.create(field.getUnknown().getFieldNumber(), type));
            }
            FieldNumberTree child = this.children.get(key);
            return child != null && child.matchesInternal(fieldPathIndex + 1, fieldPath, fieldDescriptor);
        }
        return !fieldDescriptor.isPresent() || this.children.containsKey(Key.known(((Descriptors.FieldDescriptor)fieldDescriptor.get()).getNumber()));
    }

    @AutoValue
    static abstract class Key {
        Key() {
        }

        abstract Optional<Integer> knownFieldNumber();

        abstract Optional<ProtoTruthMessageDifferencer.UnknownFieldDescriptor> unknownFieldDescriptor();

        static Key fromFieldDescriptorOrUnknown(ProtoTruthMessageDifferencer.FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
            return fieldDescriptorOrUnknown.fieldDescriptor().isPresent() ? Key.known(((Descriptors.FieldDescriptor)fieldDescriptorOrUnknown.fieldDescriptor().get()).getNumber()) : Key.unknown((ProtoTruthMessageDifferencer.UnknownFieldDescriptor)fieldDescriptorOrUnknown.unknownFieldDescriptor().get());
        }

        static Key known(int fieldNumber) {
            return new AutoValue_FieldNumberTree_Key((Optional<Integer>)Optional.of((Object)fieldNumber), (Optional<ProtoTruthMessageDifferencer.UnknownFieldDescriptor>)Optional.absent());
        }

        static Key unknown(ProtoTruthMessageDifferencer.UnknownFieldDescriptor unknownFieldDescriptor) {
            return new AutoValue_FieldNumberTree_Key((Optional<Integer>)Optional.absent(), (Optional<ProtoTruthMessageDifferencer.UnknownFieldDescriptor>)Optional.of((Object)unknownFieldDescriptor));
        }
    }
}

