/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.auto.value.AutoValue;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.truth.extensions.proto.;
import com.google.common.truth.extensions.proto.$AutoValue_DiffResult;
import com.google.common.truth.extensions.proto.$AutoValue_DiffResult_RepeatedField_PairResult;
import com.google.common.truth.extensions.proto.$AutoValue_DiffResult_SingularField;
import com.google.common.truth.extensions.proto.$AutoValue_DiffResult_UnknownFieldSetDiff;
import com.google.common.truth.extensions.proto.RecursableDiffEntity;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.ForOverride;
import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import java.util.Iterator;
import java.util.Set;

@AutoValue
abstract class DiffResult
extends RecursableDiffEntity.WithoutResultCode {
    DiffResult() {
    }

    abstract Message actual();

    abstract Message expected();

    abstract ImmutableListMultimap<Integer, SingularField> singularFields();

    abstract ImmutableListMultimap<Integer, RepeatedField> repeatedFields();

    abstract Optional<UnknownFieldSetDiff> unknownFields();

    @Override
    Iterable<? extends RecursableDiffEntity> childEntities() {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.singularFields().size() + this.repeatedFields().size() + this.unknownFields().asSet().size()));
        Sets.SetView fieldNumbers = Sets.union((Set)this.singularFields().keySet(), (Set)this.repeatedFields().keySet());
        Iterator iterator = Ordering.natural().sortedCopy((Iterable)fieldNumbers).iterator();
        while (iterator.hasNext()) {
            int fieldNumber = (Integer)iterator.next();
            builder.addAll((Iterable)this.singularFields().get((Object)fieldNumber));
            builder.addAll((Iterable)this.repeatedFields().get((Object)fieldNumber));
        }
        builder.addAll((Iterable)this.unknownFields().asSet());
        return builder.build();
    }

    static Builder newBuilder() {
        return new $AutoValue_DiffResult.Builder();
    }

    @CanIgnoreReturnValue
    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setActual(Message var1);

        abstract Builder setExpected(Message var1);

        @ForOverride
        abstract ImmutableListMultimap.Builder<Integer, SingularField> singularFieldsBuilder();

        final Builder addSingularField(int fieldNumber, SingularField singularField) {
            this.singularFieldsBuilder().put((Object)fieldNumber, (Object)singularField);
            return this;
        }

        final Builder addAllSingularFields(int fieldNumber, Iterable<SingularField> singularFields) {
            this.singularFieldsBuilder().putAll((Object)fieldNumber, singularFields);
            return this;
        }

        @ForOverride
        abstract ImmutableListMultimap.Builder<Integer, RepeatedField> repeatedFieldsBuilder();

        final Builder addRepeatedField(int fieldNumber, RepeatedField repeatedField) {
            this.repeatedFieldsBuilder().put((Object)fieldNumber, (Object)repeatedField);
            return this;
        }

        abstract Builder setUnknownFields(UnknownFieldSetDiff var1);

        abstract DiffResult build();
    }

    @AutoValue
    static abstract class UnknownFieldSetDiff
    extends RecursableDiffEntity.WithoutResultCode {
        UnknownFieldSetDiff() {
        }

        abstract Optional<UnknownFieldSet> actual();

        abstract Optional<UnknownFieldSet> expected();

        abstract ImmutableListMultimap<Integer, SingularField> singularFields();

        @Override
        Iterable<? extends RecursableDiffEntity> childEntities() {
            return this.singularFields().values();
        }

        static Builder newBuilder() {
            return new $AutoValue_DiffResult_UnknownFieldSetDiff.Builder();
        }

        @CanIgnoreReturnValue
        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setActual(UnknownFieldSet var1);

            abstract Builder setExpected(UnknownFieldSet var1);

            @ForOverride
            abstract ImmutableListMultimap.Builder<Integer, SingularField> singularFieldsBuilder();

            final Builder addSingularField(int fieldNumber, SingularField singularField) {
                this.singularFieldsBuilder().put((Object)fieldNumber, (Object)singularField);
                return this;
            }

            final Builder addAllSingularFields(int fieldNumber, Iterable<SingularField> singularFields) {
                this.singularFieldsBuilder().putAll((Object)fieldNumber, singularFields);
                return this;
            }

            abstract UnknownFieldSetDiff build();
        }
    }

    @AutoValue
    static abstract class RepeatedField
    extends RecursableDiffEntity.WithoutResultCode {
        RepeatedField() {
        }

        abstract String fieldName();

        abstract ImmutableList<Object> actual();

        abstract ImmutableList<Object> expected();

        abstract ImmutableList<PairResult> pairResults();

        @Override
        Iterable<? extends RecursableDiffEntity> childEntities() {
            return this.pairResults();
        }

        static Builder newBuilder() {
            return new .AutoValue_DiffResult_RepeatedField.Builder();
        }

        @CanIgnoreReturnValue
        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setFieldName(String var1);

            abstract Builder setActual(Iterable<?> var1);

            abstract Builder setExpected(Iterable<?> var1);

            @ForOverride
            abstract ImmutableList.Builder<PairResult> pairResultsBuilder();

            final Builder addPairResult(PairResult pairResult) {
                this.pairResultsBuilder().add((Object)pairResult);
                return this;
            }

            abstract RepeatedField build();
        }

        @AutoValue
        static abstract class PairResult
        extends RecursableDiffEntity.WithResultCode {
            PairResult() {
            }

            abstract Optional<Integer> actualFieldIndex();

            abstract Optional<Integer> expectedFieldIndex();

            abstract Optional<Object> actual();

            abstract Optional<Object> expected();

            abstract Optional<DiffResult> breakdown();

            @Override
            Iterable<? extends RecursableDiffEntity> childEntities() {
                return this.breakdown().asSet();
            }

            static Builder newBuilder() {
                return new $AutoValue_DiffResult_RepeatedField_PairResult.Builder();
            }

            @CanIgnoreReturnValue
            @AutoValue.Builder
            static abstract class Builder {
                Builder() {
                }

                abstract Builder setResult(RecursableDiffEntity.WithResultCode.Result var1);

                abstract Builder setActualFieldIndex(int var1);

                abstract Builder setExpectedFieldIndex(int var1);

                abstract Builder setActual(Object var1);

                abstract Builder setExpected(Object var1);

                abstract Builder setBreakdown(DiffResult var1);

                abstract PairResult build();
            }
        }
    }

    @AutoValue
    static abstract class SingularField
    extends RecursableDiffEntity.WithResultCode {
        SingularField() {
        }

        abstract String fieldName();

        abstract Optional<Object> actual();

        abstract Optional<Object> expected();

        abstract Optional<DiffResult> breakdown();

        abstract Optional<UnknownFieldSetDiff> unknownsBreakdown();

        @Override
        Iterable<? extends RecursableDiffEntity> childEntities() {
            return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)this.breakdown().asSet(), (Iterable)this.unknownsBreakdown().asSet()));
        }

        static SingularField ignored(String fieldName) {
            return SingularField.newBuilder().setFieldName(fieldName).setResult(RecursableDiffEntity.WithResultCode.Result.IGNORED).build();
        }

        static Builder newBuilder() {
            return new $AutoValue_DiffResult_SingularField.Builder();
        }

        @CanIgnoreReturnValue
        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setResult(RecursableDiffEntity.WithResultCode.Result var1);

            abstract Builder setFieldName(String var1);

            abstract Builder setActual(Object var1);

            abstract Builder setExpected(Object var1);

            abstract Builder setBreakdown(DiffResult var1);

            abstract Builder setUnknownsBreakdown(UnknownFieldSetDiff var1);

            abstract SingularField build();
        }
    }
}

