/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import java.util.Optional;
import javax.annotation.Nullable;

public final class OptionalSubject
extends Subject<OptionalSubject, Optional<?>> {
    OptionalSubject(FailureMetadata failureMetadata, @Nullable Optional<?> subject, @Nullable String typeDescription) {
        super(failureMetadata, subject, typeDescription);
    }

    public void isPresent() {
        if (this.actual() == null || !((Optional)this.actual()).isPresent()) {
            this.failWithoutActual("is present");
        }
    }

    public void isEmpty() {
        if (this.actual() == null || ((Optional)this.actual()).isPresent()) {
            this.fail("is empty");
        }
    }

    public void hasValue(Object expected) {
        if (expected == null) {
            throw new NullPointerException("Optional cannot have a null value.");
        }
        if (this.actual() == null || !((Optional)this.actual()).isPresent()) {
            this.fail("has value", expected);
        } else {
            Object actual = ((Optional)this.actual()).get();
            if (!actual.equals(expected)) {
                if (actual.toString().equals(expected.toString())) {
                    this.failWithRawMessage("Not true that %s (%s) has value <%s> (%s)", new Object[]{this.actualAsString(), actual.getClass(), expected, expected.getClass()});
                } else {
                    this.fail("has value", expected);
                }
            }
        }
    }

    public static Subject.Factory<OptionalSubject, Optional<?>> optionals() {
        return (metadata, subject) -> new OptionalSubject(metadata, (Optional<?>)subject, "optional");
    }
}

