/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import java.util.Optional;
import javax.annotation.Nullable;

public final class OptionalSubject
extends Subject<OptionalSubject, Optional<?>> {
    private static final SubjectFactory<OptionalSubject, Optional<?>> FACTORY = new SubjectFactory<OptionalSubject, Optional<?>>(){

        public OptionalSubject getSubject(FailureStrategy fs, Optional<?> target) {
            return new OptionalSubject(fs, target);
        }
    };

    OptionalSubject(FailureStrategy failureStrategy, @Nullable Optional<?> subject) {
        super(failureStrategy, subject);
    }

    public void isPresent() {
        if (this.actual() == null || !((Optional)this.actual()).isPresent()) {
            this.failWithoutActual("is present");
        }
    }

    public void isEmpty() {
        if (this.actual() == null || ((Optional)this.actual()).isPresent()) {
            this.fail("is empty");
        }
    }

    public void hasValue(Object expected) {
        if (expected == null) {
            throw new NullPointerException("Optional cannot have a null value.");
        }
        if (this.actual() == null || !((Optional)this.actual()).isPresent()) {
            this.fail("has value", expected);
        } else {
            Object actual = ((Optional)this.actual()).get();
            if (!actual.equals(expected)) {
                if (actual.toString().equals(expected.toString())) {
                    this.failWithRawMessage("Not true that %s (%s) has value <%s> (%s)", new Object[]{this.actualAsString(), actual.getClass(), expected, expected.getClass()});
                }
                this.fail("has value", expected);
            }
        }
    }

    public static SubjectFactory<OptionalSubject, Optional<?>> optionals() {
        return FACTORY;
    }
}

