/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.Arrays;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueConstant;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;

public final class CharValue
extends IntegerValueConstant<Character> {
    public CharValue(char value) {
        super(Character.valueOf(value));
    }

    @Override
    @NotNull
    public SimpleType getType(@NotNull ModuleDescriptor module) {
        Intrinsics.checkNotNullParameter(module, "module");
        SimpleType simpleType2 = module.getBuiltIns().getCharType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "module.builtIns.charType");
        return simpleType2;
    }

    @Override
    @NotNull
    public String toString() {
        Object[] objectArray = new Object[]{(int)((Character)this.getValue()).charValue(), this.getPrintablePart(((Character)this.getValue()).charValue())};
        String string = String.format("\\u%04X ('%s')", Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(this, *args)");
        return string;
    }

    private final String getPrintablePart(char c) {
        char c2 = c;
        return c2 == '\b' ? "\\b" : (c2 == '\t' ? "\\t" : (c2 == '\n' ? "\\n" : (c2 == '\f' ? "\\f" : (c2 == '\r' ? "\\r" : (this.isPrintableUnicode(c) ? String.valueOf(c) : "?")))));
    }

    private final boolean isPrintableUnicode(char c) {
        byte t2 = (byte)Character.getType(c);
        return t2 != 0 && t2 != 13 && t2 != 14 && t2 != 15 && t2 != 16 && t2 != 18 && t2 != 19;
    }
}

