/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.launcher;

import com.google.testing.platform.launcher.LogFormatter;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/google/testing/platform/launcher/ThreadAwareConsoleHandler;", "Ljava/util/logging/StreamHandler;", "original", "(Ljava/util/logging/StreamHandler;)V", "close", "", "isLoggable", "", "record", "Ljava/util/logging/LogRecord;", "publish", "Companion", "java_com_google_testing_platform_launcher-thread_aware_console_handler"})
public final class ThreadAwareConsoleHandler
extends StreamHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StreamHandler original;

    public ThreadAwareConsoleHandler(@NotNull StreamHandler original) {
        Intrinsics.checkNotNullParameter(original, "original");
        super(System.err, new LogFormatter());
        this.original = original;
    }

    @Override
    public boolean isLoggable(@NotNull LogRecord record) {
        Intrinsics.checkNotNullParameter(record, "record");
        return this.original.isLoggable(record) || super.isLoggable(record);
    }

    @Override
    public void publish(@NotNull LogRecord record) {
        Intrinsics.checkNotNullParameter(record, "record");
        super.publish(record);
        this.flush();
    }

    @Override
    public void close() {
        this.flush();
    }

    @JvmStatic
    public static final void swapConsoleHandlers() {
        Companion.swapConsoleHandlers();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/google/testing/platform/launcher/ThreadAwareConsoleHandler$Companion;", "", "()V", "swapConsoleHandlers", "", "java_com_google_testing_platform_launcher-thread_aware_console_handler"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void swapConsoleHandlers() {
            Logger rootLogger = LogManager.getLogManager().getLogger("");
            Handler[] handlerArray = rootLogger.getHandlers();
            Intrinsics.checkNotNullExpressionValue(handlerArray, "rootLogger.handlers");
            for (Handler handler : handlerArray) {
                if (!(handler instanceof ConsoleHandler)) continue;
                rootLogger.addHandler(new ThreadAwareConsoleHandler((StreamHandler)handler));
                rootLogger.removeHandler(handler);
                break;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

