/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.api.config;

import com.google.testing.platform.api.config.Environment;
import com.google.testing.platform.config.v1.extension.EnvironmentExtKt;
import com.google.testing.platform.proto.api.config.EnvironmentProto;
import java.io.File;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0002&'BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u00c6\u0003JW\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u00c6\u0001J\u0013\u0010!\u001a\u00020\u00112\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000f\u00a8\u0006("}, d2={"Lcom/google/testing/platform/api/config/Environment;", "", "outputDirectory", "", "tempDirectory", "runfilesDirectory", "testLogDirectory", "testRunLog", "coverageReportPath", "androidLogcatOptions", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getAndroidLogcatOptions", "()Ljava/util/List;", "getCoverageReportPath", "()Ljava/lang/String;", "enableCoverage", "", "getEnableCoverage", "()Z", "getOutputDirectory", "getRunfilesDirectory", "getTempDirectory", "getTestLogDirectory", "getTestRunLog", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "Creator", "java_com_google_testing_platform_api_config-config_api"})
public final class Environment {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String outputDirectory;
    @NotNull
    private final String tempDirectory;
    @NotNull
    private final String runfilesDirectory;
    @NotNull
    private final String testLogDirectory;
    @NotNull
    private final String testRunLog;
    @Nullable
    private final String coverageReportPath;
    @NotNull
    private final List<String> androidLogcatOptions;
    private final boolean enableCoverage;
    @Deprecated
    @NotNull
    private static final String DEFAULT_OUTPUT_DIRECTORY = ".";
    @Deprecated
    @NotNull
    private static final String DEFAULT_TEMP_DIRECTORY = "/tmp";
    @Deprecated
    @NotNull
    private static final String DEFAULT_TEST_LOG_DIR = "broker_logs";
    @Deprecated
    @NotNull
    private static final String DEFAULT_INSTRUMENTATION_TEST_RUN_LOG = "test-results.log";
    @Deprecated
    @NotNull
    private static final List<String> DEFAULT_LOGCAT_OPTIONS = CollectionsKt.emptyList();

    public Environment(@NotNull String outputDirectory, @NotNull String tempDirectory, @NotNull String runfilesDirectory, @NotNull String testLogDirectory, @NotNull String testRunLog, @Nullable String coverageReportPath, @NotNull List<String> androidLogcatOptions) {
        Intrinsics.checkNotNullParameter(outputDirectory, "outputDirectory");
        Intrinsics.checkNotNullParameter(tempDirectory, "tempDirectory");
        Intrinsics.checkNotNullParameter(runfilesDirectory, "runfilesDirectory");
        Intrinsics.checkNotNullParameter(testLogDirectory, "testLogDirectory");
        Intrinsics.checkNotNullParameter(testRunLog, "testRunLog");
        Intrinsics.checkNotNullParameter(androidLogcatOptions, "androidLogcatOptions");
        this.outputDirectory = outputDirectory;
        this.tempDirectory = tempDirectory;
        this.runfilesDirectory = runfilesDirectory;
        this.testLogDirectory = testLogDirectory;
        this.testRunLog = testRunLog;
        this.coverageReportPath = coverageReportPath;
        this.androidLogcatOptions = androidLogcatOptions;
        CharSequence charSequence = this.coverageReportPath;
        this.enableCoverage = !(charSequence == null || charSequence.length() == 0);
    }

    public /* synthetic */ Environment(String string, String string2, String string3, String string4, String string5, String string6, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, string2, string3, string4, string5, string6, list);
    }

    @NotNull
    public final String getOutputDirectory() {
        return this.outputDirectory;
    }

    @NotNull
    public final String getTempDirectory() {
        return this.tempDirectory;
    }

    @NotNull
    public final String getRunfilesDirectory() {
        return this.runfilesDirectory;
    }

    @NotNull
    public final String getTestLogDirectory() {
        return this.testLogDirectory;
    }

    @NotNull
    public final String getTestRunLog() {
        return this.testRunLog;
    }

    @Nullable
    public final String getCoverageReportPath() {
        return this.coverageReportPath;
    }

    @NotNull
    public final List<String> getAndroidLogcatOptions() {
        return this.androidLogcatOptions;
    }

    public final boolean getEnableCoverage() {
        return this.enableCoverage;
    }

    @NotNull
    public final String component1() {
        return this.outputDirectory;
    }

    @NotNull
    public final String component2() {
        return this.tempDirectory;
    }

    @NotNull
    public final String component3() {
        return this.runfilesDirectory;
    }

    @NotNull
    public final String component4() {
        return this.testLogDirectory;
    }

    @NotNull
    public final String component5() {
        return this.testRunLog;
    }

    @Nullable
    public final String component6() {
        return this.coverageReportPath;
    }

    @NotNull
    public final List<String> component7() {
        return this.androidLogcatOptions;
    }

    @NotNull
    public final Environment copy(@NotNull String outputDirectory, @NotNull String tempDirectory, @NotNull String runfilesDirectory, @NotNull String testLogDirectory, @NotNull String testRunLog, @Nullable String coverageReportPath, @NotNull List<String> androidLogcatOptions) {
        Intrinsics.checkNotNullParameter(outputDirectory, "outputDirectory");
        Intrinsics.checkNotNullParameter(tempDirectory, "tempDirectory");
        Intrinsics.checkNotNullParameter(runfilesDirectory, "runfilesDirectory");
        Intrinsics.checkNotNullParameter(testLogDirectory, "testLogDirectory");
        Intrinsics.checkNotNullParameter(testRunLog, "testRunLog");
        Intrinsics.checkNotNullParameter(androidLogcatOptions, "androidLogcatOptions");
        return new Environment(outputDirectory, tempDirectory, runfilesDirectory, testLogDirectory, testRunLog, coverageReportPath, androidLogcatOptions);
    }

    public static /* synthetic */ Environment copy$default(Environment environment2, String string, String string2, String string3, String string4, String string5, String string6, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = environment2.outputDirectory;
        }
        if ((n & 2) != 0) {
            string2 = environment2.tempDirectory;
        }
        if ((n & 4) != 0) {
            string3 = environment2.runfilesDirectory;
        }
        if ((n & 8) != 0) {
            string4 = environment2.testLogDirectory;
        }
        if ((n & 0x10) != 0) {
            string5 = environment2.testRunLog;
        }
        if ((n & 0x20) != 0) {
            string6 = environment2.coverageReportPath;
        }
        if ((n & 0x40) != 0) {
            list = environment2.androidLogcatOptions;
        }
        return environment2.copy(string, string2, string3, string4, string5, string6, list);
    }

    @NotNull
    public String toString() {
        return "Environment(outputDirectory=" + this.outputDirectory + ", tempDirectory=" + this.tempDirectory + ", runfilesDirectory=" + this.runfilesDirectory + ", testLogDirectory=" + this.testLogDirectory + ", testRunLog=" + this.testRunLog + ", coverageReportPath=" + this.coverageReportPath + ", androidLogcatOptions=" + this.androidLogcatOptions + ')';
    }

    public int hashCode() {
        int result2 = this.outputDirectory.hashCode();
        result2 = result2 * 31 + this.tempDirectory.hashCode();
        result2 = result2 * 31 + this.runfilesDirectory.hashCode();
        result2 = result2 * 31 + this.testLogDirectory.hashCode();
        result2 = result2 * 31 + this.testRunLog.hashCode();
        result2 = result2 * 31 + (this.coverageReportPath == null ? 0 : this.coverageReportPath.hashCode());
        result2 = result2 * 31 + ((Object)this.androidLogcatOptions).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Environment)) {
            return false;
        }
        Environment environment2 = (Environment)other;
        if (!Intrinsics.areEqual(this.outputDirectory, environment2.outputDirectory)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tempDirectory, environment2.tempDirectory)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.runfilesDirectory, environment2.runfilesDirectory)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.testLogDirectory, environment2.testLogDirectory)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.testRunLog, environment2.testRunLog)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.coverageReportPath, environment2.coverageReportPath)) {
            return false;
        }
        return Intrinsics.areEqual(this.androidLogcatOptions, environment2.androidLogcatOptions);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/google/testing/platform/api/config/Environment$Companion;", "", "()V", "DEFAULT_INSTRUMENTATION_TEST_RUN_LOG", "", "DEFAULT_LOGCAT_OPTIONS", "", "DEFAULT_OUTPUT_DIRECTORY", "DEFAULT_TEMP_DIRECTORY", "DEFAULT_TEST_LOG_DIR", "java_com_google_testing_platform_api_config-config_api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bR\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/google/testing/platform/api/config/Environment$Creator;", "", "()V", "default", "Lcom/google/testing/platform/api/config/Environment;", "getDefault", "()Lcom/google/testing/platform/api/config/Environment;", "default$delegate", "Lkotlin/Lazy;", "parseFrom", "environmentProto", "Lcom/google/testing/platform/proto/api/config/EnvironmentProto$Environment;", "java_com_google_testing_platform_api_config-config_api"})
    public static final class Creator {
        @NotNull
        public static final Creator INSTANCE = new Creator();
        @NotNull
        private static final Lazy default$delegate = LazyKt.lazy(default.2.INSTANCE);

        private Creator() {
        }

        @NotNull
        public final Environment getDefault() {
            Lazy lazy = default$delegate;
            return (Environment)lazy.getValue();
        }

        @NotNull
        public final Environment parseFrom(@NotNull EnvironmentProto.Environment environmentProto) {
            Intrinsics.checkNotNullParameter(environmentProto, "environmentProto");
            String outputDirectory = EnvironmentExtKt.outputDirOrDefault(environmentProto, Environment.DEFAULT_OUTPUT_DIRECTORY);
            String tempDirectory = EnvironmentExtKt.tmpDirOrDefault(environmentProto, Environment.DEFAULT_TEMP_DIRECTORY);
            String runfilesDirectory = EnvironmentExtKt.runfilesDirOrDefault(environmentProto, this.getDefault().getRunfilesDirectory());
            String testLogDir = new File(outputDirectory, EnvironmentExtKt.testLogDirOrDefault(environmentProto, Environment.DEFAULT_TEST_LOG_DIR)).getAbsolutePath();
            String testRunLog = EnvironmentExtKt.testRunLogOrDefault(environmentProto, Environment.DEFAULT_INSTRUMENTATION_TEST_RUN_LOG);
            String coverageReportPath = EnvironmentExtKt.coverageReportPathOrNull(environmentProto);
            List<String> androidLogcatOptions = EnvironmentExtKt.logcatOptionsOrDefault(environmentProto, DEFAULT_LOGCAT_OPTIONS);
            Intrinsics.checkNotNullExpressionValue(outputDirectory, "outputDirectory");
            Intrinsics.checkNotNullExpressionValue(tempDirectory, "tempDirectory");
            Intrinsics.checkNotNullExpressionValue(runfilesDirectory, "runfilesDirectory");
            Intrinsics.checkNotNullExpressionValue(testLogDir, "testLogDir");
            Intrinsics.checkNotNullExpressionValue(testRunLog, "testRunLog");
            Intrinsics.checkNotNullExpressionValue(androidLogcatOptions, "androidLogcatOptions");
            return new Environment(outputDirectory, tempDirectory, runfilesDirectory, testLogDir, testRunLog, coverageReportPath, androidLogcatOptions);
        }
    }
}

