/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.plugin.android;

import com.google.auto.service.AutoService;
import com.google.protobuf.Message;
import com.google.testing.platform.api.config.Config;
import com.google.testing.platform.api.config.ConfigExtKt;
import com.google.testing.platform.api.context.Context;
import com.google.testing.platform.api.context.ContextExtKt;
import com.google.testing.platform.api.device.CommandResult;
import com.google.testing.platform.api.device.DeviceController;
import com.google.testing.platform.api.device.DeviceProperties;
import com.google.testing.platform.api.error.ErrorSummary;
import com.google.testing.platform.api.event.EventExtKt;
import com.google.testing.platform.api.event.Events;
import com.google.testing.platform.api.plugin.HostPlugin;
import com.google.testing.platform.api.plugin.PluginException;
import com.google.testing.platform.api.plugins.PluginConfigImpl;
import com.google.testing.platform.core.plugin.PluginErrorSummary;
import com.google.testing.platform.lib.logging.jvm.LoggerExtKt;
import com.google.testing.platform.plugin.android.proto.AndroidDevicePluginArtifactsInstalledKt;
import com.google.testing.platform.plugin.android.proto.AndroidDevicePluginProto;
import com.google.testing.platform.plugin.annotations.OrderProvides;
import com.google.testing.platform.plugin.common.BaseHostPlugin;
import com.google.testing.platform.proto.api.core.TestArtifactProto;
import com.google.testing.platform.proto.api.core.TestCaseProto;
import com.google.testing.platform.proto.api.core.TestResultProto;
import com.google.testing.platform.proto.api.core.TestSuiteResultProto;
import com.google.testing.platform.runtime.android.controller.ext.AndroidDeviceControllerExtKt;
import com.google.testing.platform.runtime.android.device.AndroidDeviceProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0096\u0001J#\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0096\u0001J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001b\u0010\u0018\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0001J\t\u0010\u001b\u001a\u00020\u0013H\u0096\u0001J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u001d\u001a\u00020\u001e*\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u000b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040!H\u0002J\u0014\u0010\"\u001a\u00020\u001e*\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/google/testing/platform/plugin/android/AndroidDevicePlugin;", "Lcom/google/testing/platform/api/plugin/HostPlugin;", "()V", "adbPath", "", "context", "Lcom/google/testing/platform/api/context/Context;", "installConfig", "Lcom/google/testing/platform/plugin/android/proto/AndroidDevicePluginProto$AndroidDevicePlugin;", "installables", "", "Lcom/google/testing/platform/proto/api/core/TestArtifactProto$Artifact;", "afterAll", "", "testSuiteResult", "Lcom/google/testing/platform/proto/api/core/TestSuiteResultProto$TestSuiteResult;", "deviceController", "Lcom/google/testing/platform/api/device/DeviceController;", "cancelled", "", "afterEach", "testResult", "Lcom/google/testing/platform/proto/api/core/TestResultProto$TestResult;", "beforeAll", "beforeEach", "testCase", "Lcom/google/testing/platform/proto/api/core/TestCaseProto$TestCase;", "canRun", "configure", "installApk", "Lcom/google/testing/platform/api/device/CommandResult;", "apk", "installOptions", "", "installTestService", "Companion", "java_com_google_testing_platform_plugin_android-android_device_plugin"})
@AutoService(value={HostPlugin.class})
public final class AndroidDevicePlugin
implements HostPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ BaseHostPlugin $$delegate_0;
    private Context context;
    private Set<TestArtifactProto.Artifact> installables;
    private AndroidDevicePluginProto.AndroidDevicePlugin installConfig;
    private String adbPath;
    @NotNull
    private static final Logger logger = LoggerExtKt.getLogger(Companion);

    public AndroidDevicePlugin() {
        this.$$delegate_0 = new BaseHostPlugin();
    }

    public void afterAll(@NotNull TestSuiteResultProto.TestSuiteResult testSuiteResult, @NotNull DeviceController deviceController, boolean cancelled) {
        Intrinsics.checkNotNullParameter((Object)testSuiteResult, (String)"testSuiteResult");
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        this.$$delegate_0.afterAll(testSuiteResult, deviceController, cancelled);
    }

    public void afterEach(@NotNull TestResultProto.TestResult testResult, @NotNull DeviceController deviceController, boolean cancelled) {
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        this.$$delegate_0.afterEach(testResult, deviceController, cancelled);
    }

    public void beforeEach(@Nullable TestCaseProto.TestCase testCase, @NotNull DeviceController deviceController) {
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        this.$$delegate_0.beforeEach(testCase, deviceController);
    }

    public boolean canRun() {
        return this.$$delegate_0.canRun();
    }

    public void configure(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        Config config = ContextExtKt.getConfig(context);
        PluginConfigImpl cfr_ignored_0 = (PluginConfigImpl)config;
        this.installables = ((PluginConfigImpl)config).getSetup().getInstallables();
        Set<TestArtifactProto.Artifact> set = this.installables;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"installables");
            set = null;
        }
        if (set.isEmpty()) {
            logger.info("No installables found in test fixture. Nothing to install.");
        }
        this.adbPath = ((PluginConfigImpl)config).getAndroidSdk().getAdbPath();
        Config $this$parseConfig$iv = config;
        boolean $i$f$parseConfig = false;
        AndroidDevicePluginProto.AndroidDevicePlugin androidDevicePlugin = (AndroidDevicePluginProto.AndroidDevicePlugin)ConfigExtKt.parseConfig((Config)$this$parseConfig$iv, AndroidDevicePluginProto.AndroidDevicePlugin.class);
        if (androidDevicePlugin == null) {
            AndroidDevicePluginProto.AndroidDevicePlugin androidDevicePlugin2 = AndroidDevicePluginProto.AndroidDevicePlugin.getDefaultInstance();
            androidDevicePlugin = androidDevicePlugin2;
            Intrinsics.checkNotNullExpressionValue((Object)androidDevicePlugin2, (String)"getDefaultInstance()");
        }
        this.installConfig = androidDevicePlugin;
    }

    /*
     * WARNING - void declaration
     */
    @OrderProvides(message=AndroidDevicePluginProto.AndroidDevicePluginArtifactsInstalled.class)
    public void beforeAll(@NotNull DeviceController deviceController) {
        AndroidDevicePluginArtifactsInstalledKt.Dsl dsl;
        Object installableApk;
        AndroidDevicePluginProto.AndroidDevicePlugin androidDevicePlugin;
        Iterable $this$forEach$iv;
        AndroidDevicePluginProto.AndroidDevicePlugin androidDevicePlugin2;
        Duration timeout;
        Duration duration;
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        AndroidDevicePluginProto.AndroidDevicePlugin androidDevicePlugin3 = this.installConfig;
        if (androidDevicePlugin3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"installConfig");
            androidDevicePlugin3 = null;
        }
        Long l = androidDevicePlugin3.getInstallApkTimeout().getSeconds();
        long it = ((Number)l).longValue();
        boolean bl = false;
        Long l2 = it > 0L ? l : null;
        if (l2 != null) {
            it = ((Number)l2).longValue();
            boolean bl2 = false;
            duration = Duration.ofSeconds(it);
        } else {
            duration = timeout = null;
        }
        if ((androidDevicePlugin2 = this.installConfig) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"installConfig");
            androidDevicePlugin2 = null;
        }
        if (androidDevicePlugin2.getInstallMultiPackage()) {
            logger.fine("Treat APKs as multi-package.");
            Set<TestArtifactProto.Artifact> set = this.installables;
            if (set == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"installables");
                set = null;
            }
            if (AndroidDeviceControllerExtKt.installMultiPackage(deviceController, set, timeout).getStatusCode() != 0) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                ErrorSummary errorSummary = PluginErrorSummary.PLUGIN_ERROR;
                StringBuilder stringBuilder = new StringBuilder().append("Failed to install APKs with 'install-multi-package': ");
                Set<TestArtifactProto.Artifact> set2 = this.installables;
                if (set2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"installables");
                    set2 = null;
                }
                Iterable iterable = set2;
                StringBuilder stringBuilder2 = stringBuilder;
                ErrorSummary errorSummary2 = errorSummary;
                boolean $i$f$map = false;
                void it2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    TestArtifactProto.Artifact artifact = (TestArtifactProto.Artifact)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it3.getSourcePath().getPath());
                }
                collection = (List)destination$iv$iv;
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 4;
                Throwable throwable = null;
                String string = stringBuilder2.append(collection).toString();
                ErrorSummary errorSummary3 = errorSummary2;
                throw new PluginException(errorSummary3, string, throwable, n, defaultConstructorMarker);
            }
        } else {
            Set<TestArtifactProto.Artifact> set = this.installables;
            if (set == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"installables");
                set = null;
            }
            $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TestArtifactProto.Artifact artifact = (TestArtifactProto.Artifact)element$iv;
                boolean bl4 = false;
                logger.fine("Installing APK: " + artifact.getSourcePath().getPath());
                if (deviceController.install(artifact).getStatusCode() == 0) continue;
                throw new PluginException((ErrorSummary)PluginErrorSummary.PLUGIN_ERROR, "Failed to install APK: " + artifact.getSourcePath().getPath(), null, 4, null);
            }
        }
        if ((androidDevicePlugin = this.installConfig) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"installConfig");
            androidDevicePlugin = null;
        }
        List<TestArtifactProto.Artifact> list = androidDevicePlugin.getTestServiceApksList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"installConfig.testServiceApksList");
        $this$forEach$iv = list;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            TestArtifactProto.Artifact artifact = (TestArtifactProto.Artifact)element$iv;
            boolean bl5 = false;
            logger.info("Installing Test Service APK: " + artifact.getSourcePath().getPath());
            Intrinsics.checkNotNullExpressionValue((Object)artifact, (String)"artifact");
            CommandResult result = this.installTestService(deviceController, artifact);
            if (result.getStatusCode() == 0) continue;
            throw new PluginException((ErrorSummary)PluginErrorSummary.PLUGIN_ERROR, "Failed to install Test Service APK: " + artifact.getSourcePath().getPath(), null, 4, null);
        }
        Object[] $i$f$forEach22 = new String[]{"-r", "-t"};
        List defaultInstallOptions = CollectionsKt.listOf((Object[])$i$f$forEach22);
        DeviceProperties deviceProperties = deviceController.getDevice().getProperties();
        if (deviceProperties == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.google.testing.platform.runtime.android.device.AndroidDeviceProperties");
        }
        int apiLevel = Integer.parseInt(((AndroidDeviceProperties)deviceProperties).getDeviceApiLevel());
        AndroidDevicePluginProto.AndroidDevicePlugin androidDevicePlugin4 = this.installConfig;
        if (androidDevicePlugin4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"installConfig");
            androidDevicePlugin4 = null;
        }
        List<AndroidDevicePluginProto.InstallableApk> list2 = androidDevicePlugin4.getTestApksList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"installConfig.testApksList");
        Iterable $this$forEach$iv2 = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            AndroidDevicePluginProto.InstallableApk.InstallOption it4;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            installableApk = (AndroidDevicePluginProto.InstallableApk)element$iv;
            boolean bl6 = false;
            logger.info("Installing APK: " + ((AndroidDevicePluginProto.InstallableApk)installableApk).getTestApk().getSourcePath().getPath());
            List<AndroidDevicePluginProto.InstallableApk.InstallOption> list3 = ((AndroidDevicePluginProto.InstallableApk)installableApk).getInstallOptionsList();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"installableApk.installOptionsList");
            Iterable bl3 = list3;
            boolean $i$f$filter = false;
            void var13_44 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it4 = (AndroidDevicePluginProto.InstallableApk.InstallOption)element$iv$iv;
                boolean bl7 = false;
                if (!(it4.getMinDeviceApiLevel() <= apiLevel)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it4 = (AndroidDevicePluginProto.InstallableApk.InstallOption)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl8 = false;
                collection.add(it4.getCommandLineParameter());
            }
            List additionalInstallOptions = (List)destination$iv$iv;
            List installOptions = CollectionsKt.plus((Collection)defaultInstallOptions, (Iterable)additionalInstallOptions);
            TestArtifactProto.Artifact artifact = ((AndroidDevicePluginProto.InstallableApk)installableApk).getTestApk();
            Intrinsics.checkNotNullExpressionValue((Object)artifact, (String)"installableApk.testApk");
            CommandResult result = this.installApk(deviceController, artifact, installOptions);
            if (result.getStatusCode() == 0) continue;
            throw new PluginException((ErrorSummary)PluginErrorSummary.PLUGIN_ERROR, "Failed to install APK: " + ((AndroidDevicePluginProto.InstallableApk)installableApk).getTestApk().getSourcePath().getPath() + ", with option " + CollectionsKt.joinToString$default((Iterable)installOptions, (CharSequence)",", null, null, (int)0, null, null, (int)62, null), null, 4, null);
        }
        Context context = this.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            context = null;
        }
        Events events = ContextExtKt.getEvents(context);
        boolean bl9 = false;
        AndroidDevicePluginProto.AndroidDevicePluginArtifactsInstalled.Builder builder = AndroidDevicePluginProto.AndroidDevicePluginArtifactsInstalled.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
        AndroidDevicePluginArtifactsInstalledKt.Dsl $this$androidDevicePluginArtifactsInstalled_u24lambda_u2d0$iv = dsl = AndroidDevicePluginArtifactsInstalledKt.Dsl.Companion._create(builder);
        boolean bl10 = false;
        installableApk = $this$androidDevicePluginArtifactsInstalled_u24lambda_u2d0$iv;
        Events events2 = events;
        boolean bl11 = false;
        EventExtKt.send((Events)events2, (Message)((Message)dsl._build()));
    }

    private final CommandResult installTestService(DeviceController $this$installTestService, TestArtifactProto.Artifact apk) {
        String string;
        DeviceProperties deviceProperties = $this$installTestService.getDevice().getProperties();
        if (deviceProperties == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.google.testing.platform.runtime.android.device.AndroidDeviceProperties");
        }
        int apiLevel = Integer.parseInt(((AndroidDeviceProperties)deviceProperties).getDeviceApiLevel());
        boolean grantPermissions = apiLevel >= 23;
        boolean addForceQueryable = apiLevel >= 30;
        Object[] objectArray = new String[4];
        objectArray[0] = "-r";
        objectArray[1] = "-t";
        String string2 = string = "-g";
        int n = 2;
        Object[] objectArray2 = objectArray;
        TestArtifactProto.Artifact artifact = apk;
        DeviceController deviceController = $this$installTestService;
        AndroidDevicePlugin androidDevicePlugin = this;
        boolean bl = false;
        boolean bl2 = grantPermissions;
        objectArray2[n] = bl2 ? string : null;
        String it = string = "--force-queryable";
        n = 3;
        objectArray2 = objectArray;
        boolean bl3 = false;
        bl2 = addForceQueryable;
        objectArray2[n] = bl2 ? string : null;
        return androidDevicePlugin.installApk(deviceController, artifact, CollectionsKt.listOfNotNull((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private final CommandResult installApk(DeviceController $this$installApk, TestArtifactProto.Artifact apk, List<String> installOptions) {
        void $this$installApk_u24lambda_u2d13;
        Duration duration;
        AndroidDevicePluginProto.AndroidDevicePlugin androidDevicePlugin = this.installConfig;
        if (androidDevicePlugin == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"installConfig");
            androidDevicePlugin = null;
        }
        Object object = androidDevicePlugin.getInstallApkTimeout().getSeconds();
        long it = ((Number)object).longValue();
        boolean bl = false;
        Object object2 = it > 0L ? object : null;
        if (object2 != null) {
            it = ((Number)object2).longValue();
            boolean bl2 = false;
            duration = Duration.ofSeconds(it);
        } else {
            duration = null;
        }
        Duration timeout = duration;
        Object object3 = new String[]{"install"};
        object = object3 = CollectionsKt.mutableListOf((Object[])object3);
        DeviceController deviceController = $this$installApk;
        boolean bl3 = false;
        $this$installApk_u24lambda_u2d13.addAll((Collection)installOptions);
        String string = apk.getSourcePath().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"apk.sourcePath.path");
        $this$installApk_u24lambda_u2d13.add(string);
        return deviceController.execute((List)object3, timeout);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/google/testing/platform/plugin/android/AndroidDevicePlugin$Companion;", "", "()V", "logger", "Ljava/util/logging/Logger;", "getLogger$annotations", "java_com_google_testing_platform_plugin_android-android_device_plugin"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

