/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.lib.adb.command;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u0006\u0010\u0018\u001a\u00020\u0014J\u0006\u0010\u0019\u001a\u00020\u0014J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0000J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0000J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u001d"}, d2={"Lcom/google/testing/platform/lib/adb/command/Instrumentation;", "", "appPackage", "", "testPackage", "instrumentationClass", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAppPackage", "()Ljava/lang/String;", "fullInstrumentationClass", "getFullInstrumentationClass", "fullName", "getFullName", "getInstrumentationClass", "getTestPackage", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "isNull", "isValid", "isValidOrNull", "matches", "toString", "lib_java_com_google_testing_platform_lib_adb_command-instrumentations"})
public final class Instrumentation {
    @NotNull
    private final String appPackage;
    @NotNull
    private final String testPackage;
    @NotNull
    private final String instrumentationClass;

    public Instrumentation(@NotNull String appPackage, @NotNull String testPackage, @NotNull String instrumentationClass) {
        Intrinsics.checkNotNullParameter((Object)appPackage, (String)"appPackage");
        Intrinsics.checkNotNullParameter((Object)testPackage, (String)"testPackage");
        Intrinsics.checkNotNullParameter((Object)instrumentationClass, (String)"instrumentationClass");
        this.appPackage = appPackage;
        this.testPackage = testPackage;
        this.instrumentationClass = instrumentationClass;
    }

    public /* synthetic */ Instrumentation(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        this(string, string2, string3);
    }

    @NotNull
    public final String getAppPackage() {
        return this.appPackage;
    }

    @NotNull
    public final String getTestPackage() {
        return this.testPackage;
    }

    @NotNull
    public final String getInstrumentationClass() {
        return this.instrumentationClass;
    }

    @NotNull
    public final String getFullInstrumentationClass() {
        return StringsKt.startsWith$default((String)this.instrumentationClass, (String)".", (boolean)false, (int)2, null) ? this.testPackage + this.instrumentationClass : this.instrumentationClass;
    }

    @NotNull
    public final String getFullName() {
        return ((CharSequence)this.instrumentationClass).length() > 0 ? this.testPackage + '/' + this.instrumentationClass : this.testPackage;
    }

    public final boolean isValid() {
        return !StringsKt.isBlank((CharSequence)this.testPackage);
    }

    public final boolean isNull() {
        return StringsKt.isBlank((CharSequence)this.appPackage) & StringsKt.isBlank((CharSequence)this.testPackage) & StringsKt.isBlank((CharSequence)this.instrumentationClass);
    }

    @Nullable
    public final Instrumentation isValidOrNull() {
        return !StringsKt.isBlank((CharSequence)this.testPackage) ? this : null;
    }

    public final boolean matches(@NotNull Instrumentation other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (((CharSequence)this.appPackage).length() > 0) {
            return Intrinsics.areEqual((Object)this, (Object)other);
        }
        if (((CharSequence)this.testPackage).length() == 0 || !Intrinsics.areEqual((Object)this.testPackage, (Object)other.testPackage)) {
            return false;
        }
        if (((CharSequence)this.instrumentationClass).length() > 0) {
            return Intrinsics.areEqual((Object)this.getFullInstrumentationClass(), (Object)other.getFullInstrumentationClass());
        }
        return true;
    }

    @NotNull
    public final String component1() {
        return this.appPackage;
    }

    @NotNull
    public final String component2() {
        return this.testPackage;
    }

    @NotNull
    public final String component3() {
        return this.instrumentationClass;
    }

    @NotNull
    public final Instrumentation copy(@NotNull String appPackage, @NotNull String testPackage, @NotNull String instrumentationClass) {
        Intrinsics.checkNotNullParameter((Object)appPackage, (String)"appPackage");
        Intrinsics.checkNotNullParameter((Object)testPackage, (String)"testPackage");
        Intrinsics.checkNotNullParameter((Object)instrumentationClass, (String)"instrumentationClass");
        return new Instrumentation(appPackage, testPackage, instrumentationClass);
    }

    public static /* synthetic */ Instrumentation copy$default(Instrumentation instrumentation, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = instrumentation.appPackage;
        }
        if ((n & 2) != 0) {
            string2 = instrumentation.testPackage;
        }
        if ((n & 4) != 0) {
            string3 = instrumentation.instrumentationClass;
        }
        return instrumentation.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "Instrumentation(appPackage=" + this.appPackage + ", testPackage=" + this.testPackage + ", instrumentationClass=" + this.instrumentationClass + ')';
    }

    public int hashCode() {
        int result = this.appPackage.hashCode();
        result = result * 31 + this.testPackage.hashCode();
        result = result * 31 + this.instrumentationClass.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Instrumentation)) {
            return false;
        }
        Instrumentation instrumentation = (Instrumentation)other;
        if (!Intrinsics.areEqual((Object)this.appPackage, (Object)instrumentation.appPackage)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.testPackage, (Object)instrumentation.testPackage)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.instrumentationClass, (Object)instrumentation.instrumentationClass);
    }
}

