/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.runtime.android.driver.lib;

import com.google.testing.platform.api.device.CommandResult;
import com.google.testing.platform.api.device.DeviceController;
import com.google.testing.platform.config.v1.extension.InstrumentationExtKt;
import com.google.testing.platform.lib.adb.command.Instrumentation;
import com.google.testing.platform.lib.adb.command.Instrumentations;
import com.google.testing.platform.lib.adb.command.instrument.lib.InstrumentationFinder;
import com.google.testing.platform.lib.adb.command.parser.InstrumentationListParser;
import com.google.testing.platform.lib.logging.jvm.LoggerExtKt;
import com.google.testing.platform.proto.api.config.InstrumentationProto;
import com.google.testing.platform.proto.api.config.RuntimeProto;
import com.google.testing.platform.runtime.android.controller.ext.AndroidDeviceControllerExtKt;
import com.google.testing.platform.runtime.android.driver.lib.ListInstrumentationCommandKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/google/testing/platform/runtime/android/driver/lib/ListInstrumentationsCommand;", "", "parser", "Lcom/google/testing/platform/lib/adb/command/parser/InstrumentationListParser;", "configInstrumentation", "Lcom/google/testing/platform/proto/api/config/RuntimeProto$AndroidInstrumentationRuntime;", "(Lcom/google/testing/platform/lib/adb/command/parser/InstrumentationListParser;Lcom/google/testing/platform/proto/api/config/RuntimeProto$AndroidInstrumentationRuntime;)V", "getInstrumentation", "Lcom/google/testing/platform/lib/adb/command/Instrumentation;", "deviceController", "Lcom/google/testing/platform/api/device/DeviceController;", "Companion", "java_com_google_testing_platform_runtime_android_driver_lib-list_instrumentations_command"})
public final class ListInstrumentationsCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InstrumentationListParser parser;
    @NotNull
    private final RuntimeProto.AndroidInstrumentationRuntime configInstrumentation;
    @NotNull
    private static final Logger logger = LoggerExtKt.getLogger(Companion);

    public ListInstrumentationsCommand(@NotNull InstrumentationListParser parser, @NotNull RuntimeProto.AndroidInstrumentationRuntime configInstrumentation) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)configInstrumentation, (String)"configInstrumentation");
        this.parser = parser;
        this.configInstrumentation = configInstrumentation;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Instrumentation getInstrumentation(@NotNull DeviceController deviceController) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        CommandResult commandResult = AndroidDeviceControllerExtKt.listInstrumentations$default(deviceController, null, 1, null);
        int exitCode = commandResult.component1();
        List output = commandResult.component2();
        if (exitCode != 0) {
            logger.warning("pm list instrumentation return non-zero exit code: " + exitCode);
        }
        List instrumentations = (List)this.parser.from(output);
        Iterable $this$mapNotNull$iv = instrumentations;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Instrumentation it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            com.google.testing.platform.lib.adb.command.parser.Instrumentation it = (com.google.testing.platform.lib.adb.command.parser.Instrumentation)element$iv$iv;
            boolean bl2 = false;
            if (ListInstrumentationCommandKt.access$toInstrumentation(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        int n = exitCode;
        Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set<Instrumentation> availableInstrumentations = new Instrumentations(set, n).getInstrumentations();
        InstrumentationProto.Instrumentation instrumentationInfo = this.configInstrumentation.getInstrumentationInfo();
        Intrinsics.checkNotNullExpressionValue((Object)instrumentationInfo, (String)"instrumentationInfo");
        Instrumentation instrumentation = InstrumentationExtKt.toInstrumentation(instrumentationInfo);
        InstrumentationProto.InstrumentationFilter instrumentationFilter = instrumentationInfo.getInstrumentationFilter();
        Intrinsics.checkNotNullExpressionValue((Object)instrumentationFilter, (String)"instrumentationInfo.instrumentationFilter");
        InstrumentationFinder instrumentationFinder = new InstrumentationFinder(availableInstrumentations, instrumentation, instrumentationFilter);
        return instrumentationFinder.findFirst();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/google/testing/platform/runtime/android/driver/lib/ListInstrumentationsCommand$Companion;", "", "()V", "logger", "Ljava/util/logging/Logger;", "getLogger$annotations", "java_com_google_testing_platform_runtime_android_driver_lib-list_instrumentations_command"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

