/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.runtime.android.driver;

import com.google.auto.service.AutoService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.math.LongMath;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import com.google.testing.platform.api.config.Config;
import com.google.testing.platform.api.config.ConfigExtKt;
import com.google.testing.platform.api.context.Context;
import com.google.testing.platform.api.context.ContextExtKt;
import com.google.testing.platform.api.device.CommandHandle;
import com.google.testing.platform.api.device.DeviceController;
import com.google.testing.platform.api.driver.TestDriver;
import com.google.testing.platform.api.driver.TestDriverConfigImpl;
import com.google.testing.platform.api.event.Events;
import com.google.testing.platform.api.result.TestResultPublisher;
import com.google.testing.platform.config.v1.extension.InstrumentationExtKt;
import com.google.testing.platform.lib.adb.command.Instrumentation;
import com.google.testing.platform.lib.adb.command.instrument.AmInstrumentationListener;
import com.google.testing.platform.lib.adb.command.instrument.AmInstrumentationParser;
import com.google.testing.platform.lib.adb.command.instrument.InstrumentationResult;
import com.google.testing.platform.lib.adb.command.instrument.TestIdentifier;
import com.google.testing.platform.lib.adb.command.instrument.TestResult;
import com.google.testing.platform.lib.adb.command.io.LogWriter;
import com.google.testing.platform.lib.adb.command.timing.TestTimeTracker;
import com.google.testing.platform.lib.logging.jvm.LoggerExtKt;
import com.google.testing.platform.plugin.android.proto.InstrumentationTestOptionsPluginProto;
import com.google.testing.platform.proto.api.config.AndroidInstrumentationDriverProto;
import com.google.testing.platform.proto.api.config.InstrumentationProto;
import com.google.testing.platform.proto.api.config.RuntimeProto;
import com.google.testing.platform.proto.api.core.ErrorProto;
import com.google.testing.platform.proto.api.core.IssueProto;
import com.google.testing.platform.proto.api.core.TestArtifactProto;
import com.google.testing.platform.proto.api.core.TestCaseProto;
import com.google.testing.platform.proto.api.core.TestResultProto;
import com.google.testing.platform.proto.api.core.TestStatusProto;
import com.google.testing.platform.proto.api.core.TestSuiteResultProto;
import com.google.testing.platform.runtime.android.controller.ext.AndroidDeviceControllerExtKt;
import com.google.testing.platform.runtime.android.driver.AndroidInstrumentationArgs;
import com.google.testing.platform.runtime.android.driver.AndroidInstrumentationDriver;
import com.google.testing.platform.runtime.android.driver.AndroidInstrumentationDriverErrorSummary;
import com.google.testing.platform.runtime.android.driver.AndroidInstrumentationDriverException;
import com.google.testing.platform.runtime.android.driver.TestSuiteResultExtKt;
import com.google.testing.platform.runtime.android.driver.inject.AndroidInstrumentationDriverComponent;
import com.google.testing.platform.runtime.android.driver.inject.DaggerAndroidInstrumentationDriverComponent;
import com.google.testing.platform.runtime.android.driver.lib.TestRunnerArgs;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 62\u00020\u0001:\u0003678B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J<\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100#2\u0006\u0010$\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010%\u001a\u00020\u00192\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100'H\u0002J\b\u0010(\u001a\u00020\u0019H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J.\u00102\u001a\u00020*2\u0006\u00103\u001a\u00020/2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00100#2\u0006\u00100\u001a\u0002012\u0006\u0010$\u001a\u00020\u0007H\u0002J\u0010\u00105\u001a\u00020*2\u0006\u0010.\u001a\u00020/H\u0002R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/google/testing/platform/runtime/android/driver/AndroidInstrumentationDriver;", "Lcom/google/testing/platform/api/driver/TestDriver;", "()V", "androidInstrumentationDriverComponentBuilder", "Lcom/google/testing/platform/runtime/android/driver/inject/AndroidInstrumentationDriverComponent$Builder;", "(Lcom/google/testing/platform/runtime/android/driver/inject/AndroidInstrumentationDriverComponent$Builder;)V", "amInstrumentTimeout", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "androidInstrumentationDriverConfig", "Lcom/google/testing/platform/proto/api/config/AndroidInstrumentationDriverProto$AndroidInstrumentationDriver;", "config", "Lcom/google/testing/platform/api/config/Config;", "context", "Lcom/google/testing/platform/api/context/Context;", "coverageFilePath", "", "externalStoragePath", "instrumentation", "Lcom/google/testing/platform/lib/adb/command/Instrumentation;", "instrumentationHandle", "Lcom/google/testing/platform/api/device/CommandHandle;", "instrumentationWriter", "Lcom/google/testing/platform/lib/adb/command/io/LogWriter;", "isTestServiceInstalled", "", "shellExecutionOption", "Lcom/google/testing/platform/proto/api/config/AndroidInstrumentationDriverProto$AndroidInstrumentationDriver$ShellExecutionOption;", "testRunnerArgs", "Lcom/google/testing/platform/runtime/android/driver/lib/TestRunnerArgs;", "testTimeTrackerFactory", "Ljavax/inject/Provider;", "Lcom/google/testing/platform/lib/adb/command/timing/TestTimeTracker;", "useOrchestrator", "buildArgsForTestSuite", "", "timeout", "useTestStorageService", "additionalOptions", "", "cancel", "configure", "", "onDeviceCoverageFile", "testPackage", "run", "controller", "Lcom/google/testing/platform/api/device/DeviceController;", "testResultPublisher", "Lcom/google/testing/platform/api/result/TestResultPublisher;", "runTestSuite", "deviceController", "args", "setUp", "Companion", "InstrumentationListener", "Issues", "java_com_google_testing_platform_runtime_android_driver-android_instrumentation_driver"})
@AutoService(value={TestDriver.class})
public final class AndroidInstrumentationDriver
implements TestDriver {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final AndroidInstrumentationDriverComponent.Builder androidInstrumentationDriverComponentBuilder;
    private Duration amInstrumentTimeout;
    private boolean isTestServiceInstalled;
    private boolean useOrchestrator;
    @Nullable
    private String coverageFilePath;
    private TestRunnerArgs testRunnerArgs;
    private Instrumentation instrumentation;
    private LogWriter instrumentationWriter;
    private Provider<TestTimeTracker> testTimeTrackerFactory;
    private Config config;
    private Context context;
    private AndroidInstrumentationDriverProto.AndroidInstrumentationDriver androidInstrumentationDriverConfig;
    private CommandHandle instrumentationHandle;
    private String externalStoragePath;
    private AndroidInstrumentationDriverProto.AndroidInstrumentationDriver.ShellExecutionOption shellExecutionOption;
    @Deprecated
    @NotNull
    private static final Logger logger = LoggerExtKt.getLogger(Companion);
    @Deprecated
    private static final long DEFAULT_AM_INSTRUMENT_TIMEOUT_SEC = 240L;
    @Deprecated
    @NotNull
    private static final String COVERAGE_FILE_NAME = "ondevicecoverage.ec";
    @Deprecated
    private static final int NANOS_PER_SECOND = 1000000000;

    @VisibleForTesting
    public AndroidInstrumentationDriver(@NotNull AndroidInstrumentationDriverComponent.Builder androidInstrumentationDriverComponentBuilder) {
        Intrinsics.checkNotNullParameter((Object)androidInstrumentationDriverComponentBuilder, (String)"androidInstrumentationDriverComponentBuilder");
        this.androidInstrumentationDriverComponentBuilder = androidInstrumentationDriverComponentBuilder;
        this.amInstrumentTimeout = Duration.ofSeconds(240L);
    }

    public AndroidInstrumentationDriver() {
        AndroidInstrumentationDriverComponent.Builder builder = DaggerAndroidInstrumentationDriverComponent.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder()");
        this(builder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configure(@NotNull Context context) {
        AndroidInstrumentationDriverProto.AndroidInstrumentationDriver.ShellExecutionOption shellExecutionOption;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.config = (Config)((TestDriverConfigImpl)ContextExtKt.getConfig(context));
        Config config = this.config;
        if (config == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            config = null;
        }
        Config $this$parseConfig$iv = config;
        boolean $i$f$parseConfig = false;
        Message message = ConfigExtKt.parseConfig((Config)$this$parseConfig$iv, AndroidInstrumentationDriverProto.AndroidInstrumentationDriver.class);
        Intrinsics.checkNotNull((Object)message);
        this.androidInstrumentationDriverConfig = (AndroidInstrumentationDriverProto.AndroidInstrumentationDriver)message;
        StringBuilder stringBuilder = new StringBuilder().append("Configuring Android Instrumentation driver: ");
        AndroidInstrumentationDriverProto.AndroidInstrumentationDriver androidInstrumentationDriver = this.androidInstrumentationDriverConfig;
        if (androidInstrumentationDriver == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"androidInstrumentationDriverConfig");
            androidInstrumentationDriver = null;
        }
        logger.info(stringBuilder.append(androidInstrumentationDriver).toString());
        AndroidInstrumentationDriverProto.AndroidInstrumentationDriver androidInstrumentationDriver2 = this.androidInstrumentationDriverConfig;
        if (androidInstrumentationDriver2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"androidInstrumentationDriverConfig");
            androidInstrumentationDriver2 = null;
        }
        RuntimeProto.AndroidInstrumentationRuntime runtime = androidInstrumentationDriver2.getAndroidInstrumentationRuntime();
        InstrumentationProto.Instrumentation instrumentation = runtime.getInstrumentationInfo();
        Intrinsics.checkNotNullExpressionValue((Object)instrumentation, (String)"runtime.instrumentationInfo");
        this.instrumentation = InstrumentationExtKt.toInstrumentation(instrumentation);
        AndroidInstrumentationDriverProto.AndroidInstrumentationDriver androidInstrumentationDriver3 = this.androidInstrumentationDriverConfig;
        if (androidInstrumentationDriver3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"androidInstrumentationDriverConfig");
            androidInstrumentationDriver3 = null;
        }
        this.useOrchestrator = androidInstrumentationDriver3.getUseOrchestrator();
        AndroidInstrumentationDriverProto.AndroidInstrumentationDriver androidInstrumentationDriver4 = this.androidInstrumentationDriverConfig;
        if (androidInstrumentationDriver4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"androidInstrumentationDriverConfig");
            androidInstrumentationDriver4 = null;
        }
        if (androidInstrumentationDriver4.getShellExecutionOption() == AndroidInstrumentationDriverProto.AndroidInstrumentationDriver.ShellExecutionOption.UNSPECIFIED_SHELL_EXECUTION_OPTION) {
            shellExecutionOption = AndroidInstrumentationDriverProto.AndroidInstrumentationDriver.ShellExecutionOption.NO_SHELL_EXECUTION;
        } else {
            AndroidInstrumentationDriverProto.AndroidInstrumentationDriver androidInstrumentationDriver5 = this.androidInstrumentationDriverConfig;
            if (androidInstrumentationDriver5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidInstrumentationDriverConfig");
                androidInstrumentationDriver5 = null;
            }
            AndroidInstrumentationDriverProto.AndroidInstrumentationDriver.ShellExecutionOption shellExecutionOption2 = androidInstrumentationDriver5.getShellExecutionOption();
            shellExecutionOption = shellExecutionOption2;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)shellExecutionOption2), (String)"androidInstrumentationDr\u2026nfig.shellExecutionOption");
        }
        this.shellExecutionOption = shellExecutionOption;
        Instrumentation instrumentation2 = this.instrumentation;
        if (instrumentation2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"instrumentation");
            instrumentation2 = null;
        }
        if (instrumentation2.isNull()) return;
        Instrumentation instrumentation3 = this.instrumentation;
        if (instrumentation3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"instrumentation");
            instrumentation3 = null;
        }
        if (instrumentation3.isValid()) {
            return;
        }
        boolean bl = false;
        if (bl) return;
        boolean bl2 = false;
        StringBuilder stringBuilder2 = new StringBuilder().append("\n      |Please provide a valid instrumentation to run the test.\n      |The provided instrumentation is not valid: ");
        Instrumentation instrumentation4 = this.instrumentation;
        if (instrumentation4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"instrumentation");
            instrumentation4 = null;
        }
        String string = StringsKt.trimMargin$default((String)stringBuilder2.append(instrumentation4).append("\n      ").toString(), null, (int)1, null);
        throw new IllegalArgumentException(string.toString());
    }

    /*
     * WARNING - void declaration
     */
    private final void setUp(DeviceController controller) {
        Instrumentation instrumentation;
        Instrumentation instrumentation2;
        TestRunnerArgs testRunnerArgs;
        Config config;
        long l;
        Config config2 = this.config;
        if (config2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            config2 = null;
        }
        TestDriverConfigImpl cfr_ignored_0 = (TestDriverConfigImpl)config2;
        this.externalStoragePath = AndroidDeviceControllerExtKt.getExternalStoragePath(controller);
        AndroidInstrumentationDriverProto.AndroidInstrumentationDriver androidInstrumentationDriver = this.androidInstrumentationDriverConfig;
        if (androidInstrumentationDriver == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"androidInstrumentationDriverConfig");
            androidInstrumentationDriver = null;
        }
        long it = l = androidInstrumentationDriver.getAmInstrumentTimeout();
        boolean bl = false;
        if (it > 0L) {
            this.amInstrumentTimeout = Duration.ofSeconds(it);
        }
        if ((config = this.config) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            config = null;
        }
        AndroidInstrumentationDriverComponent testDriverComponent = this.androidInstrumentationDriverComponentBuilder.config(config).device(controller.getDevice()).build();
        this.testRunnerArgs = testDriverComponent.getTestRunnerArgs();
        this.instrumentationWriter = testDriverComponent.getInstrumentationWriter();
        this.testTimeTrackerFactory = testDriverComponent.getTestTimeTrackerFactory();
        TestRunnerArgs testRunnerArgs2 = this.testRunnerArgs;
        if (testRunnerArgs2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testRunnerArgs");
            testRunnerArgs2 = null;
        }
        if (testRunnerArgs2.getUseTestStorageService()) {
            void installed;
            boolean bl2;
            boolean bl3 = bl2 = AndroidDeviceControllerExtKt.isTestServiceInstalled(controller);
            AndroidInstrumentationDriver androidInstrumentationDriver2 = this;
            boolean bl4 = false;
            if (installed != false) {
                logger.fine("AndroidX test services are installed on the device.");
            }
            androidInstrumentationDriver2.isTestServiceInstalled = bl2;
        }
        if ((testRunnerArgs = this.testRunnerArgs) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testRunnerArgs");
            testRunnerArgs = null;
        }
        if (testRunnerArgs.getEnableCoverage()) {
            Instrumentation instrumentation3 = this.instrumentation;
            if (instrumentation3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"instrumentation");
                instrumentation3 = null;
            }
            this.coverageFilePath = this.onDeviceCoverageFile(instrumentation3.getTestPackage(), this.isTestServiceInstalled);
        }
        if ((instrumentation2 = this.instrumentation) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"instrumentation");
            instrumentation2 = null;
        }
        if (instrumentation2.isNull()) {
            logger.info("No instrumentation was configured.\nTrying to detect one by listing available instrumentations in the test package.");
            this.instrumentation = testDriverComponent.getListInstrumentationsCommand().getInstrumentation(controller);
        }
        if ((instrumentation = this.instrumentation) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"instrumentation");
            instrumentation = null;
        }
        if (!instrumentation.isValid()) {
            StringBuilder stringBuilder = new StringBuilder().append("\n          |No valid instrumentation is provided or can be detected in the test package.\n          |The instrumentation provided/detected is not valid: ");
            Instrumentation instrumentation4 = this.instrumentation;
            if (instrumentation4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"instrumentation");
                instrumentation4 = null;
            }
            throw new AndroidInstrumentationDriverException(AndroidInstrumentationDriverErrorSummary.INVALID_INSTRUMENTATION_PROVIDED, StringsKt.trimMargin$default((String)stringBuilder.append(instrumentation4).append("\n          ").toString(), null, (int)1, null), null, 4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void run(@NotNull DeviceController controller, @NotNull TestResultPublisher testResultPublisher) {
        void $this$mapTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)testResultPublisher, (String)"testResultPublisher");
        logger.info("Running Android Instrumentation driver.");
        this.setUp(controller);
        HashMap<String, String> additionalOptions = new HashMap<String, String>();
        Context context = this.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            context = null;
        }
        Events $this$get$iv = ContextExtKt.getEvents(context);
        boolean $i$f$get = false;
        String string = InstrumentationTestOptionsPluginProto.InstrumentationTestOptionsProvided.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"T::class.java.name");
        List messages$iv = $this$get$iv.get(string);
        Object object = InstrumentationTestOptionsPluginProto.InstrumentationTestOptionsProvided.class.getMethod("parser", new Class[0]).invoke(null, new Object[0]);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.google.protobuf.Parser<T of com.google.testing.platform.api.event.EventExtKt.get>");
        }
        Parser parser$iv = (Parser)object;
        Iterable $this$map$iv$iv = messages$iv;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
            void it$iv;
            byte[] byArray = (byte[])item$iv$iv$iv;
            Collection collection = destination$iv$iv$iv;
            boolean bl = false;
            Object object2 = parser$iv.parseFrom((byte[])it$iv);
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.google.testing.platform.plugin.android.proto.InstrumentationTestOptionsPluginProto.InstrumentationTestOptionsProvided");
            }
            collection.add((Message)((InstrumentationTestOptionsPluginProto.InstrumentationTestOptionsProvided)object2));
        }
        for (InstrumentationTestOptionsPluginProto.InstrumentationTestOptionsProvided event : (List)destination$iv$iv$iv) {
            additionalOptions.putAll(event.getTestOptionsMap());
        }
        Duration duration = this.amInstrumentTimeout;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"amInstrumentTimeout");
        List<String> list = this.buildArgsForTestSuite(duration, this.coverageFilePath, this.isTestServiceInstalled, (Map<String, String>)additionalOptions);
        Duration duration2 = this.amInstrumentTimeout;
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"amInstrumentTimeout");
        this.runTestSuite(controller, list, testResultPublisher, duration2);
    }

    public boolean cancel() {
        boolean bl;
        logger.warning("Cancellation triggered in Android Instrumentation Driver.");
        if (this.instrumentationHandle != null) {
            CommandHandle commandHandle = this.instrumentationHandle;
            if (commandHandle == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"instrumentationHandle");
                commandHandle = null;
            }
            commandHandle.stop();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final List<String> buildArgsForTestSuite(Duration timeout, String coverageFilePath, boolean useTestStorageService, Map<String, String> additionalOptions) {
        Instrumentation instrumentation = this.instrumentation;
        if (instrumentation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"instrumentation");
            instrumentation = null;
        }
        String string = instrumentation.getTestPackage();
        Instrumentation instrumentation2 = this.instrumentation;
        if (instrumentation2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"instrumentation");
            instrumentation2 = null;
        }
        String string2 = instrumentation2.getInstrumentationClass();
        TestRunnerArgs testRunnerArgs = this.testRunnerArgs;
        if (testRunnerArgs == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testRunnerArgs");
            testRunnerArgs = null;
        }
        boolean bl = testRunnerArgs.getEnableDebugging();
        TestRunnerArgs testRunnerArgs2 = this.testRunnerArgs;
        if (testRunnerArgs2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testRunnerArgs");
            testRunnerArgs2 = null;
        }
        Map map = MapsKt.plus(testRunnerArgs2.getArgs(), additionalOptions);
        TestRunnerArgs testRunnerArgs3 = this.testRunnerArgs;
        if (testRunnerArgs3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testRunnerArgs");
            testRunnerArgs3 = null;
        }
        boolean bl2 = testRunnerArgs3.getNoWindowAnimation();
        List list = CollectionsKt.emptyList();
        boolean bl3 = this.useOrchestrator;
        AndroidInstrumentationDriverProto.AndroidInstrumentationDriver.ShellExecutionOption shellExecutionOption = this.shellExecutionOption;
        if (shellExecutionOption == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shellExecutionOption");
            shellExecutionOption = null;
        }
        AndroidInstrumentationDriverProto.AndroidInstrumentationDriver.ShellExecutionOption shellExecutionOption2 = shellExecutionOption;
        return new AndroidInstrumentationArgs(string2, false, bl2, true, true, map, string, list, bl, coverageFilePath, timeout, bl3, useTestStorageService, shellExecutionOption2).toArgs();
    }

    private final void runTestSuite(DeviceController deviceController, List<String> args, TestResultPublisher testResultPublisher, Duration timeout) {
        InstrumentationListener instrumentationListener = new InstrumentationListener(testResultPublisher);
        Set set = SetsKt.setOf((Object)instrumentationListener);
        Provider<TestTimeTracker> provider = this.testTimeTrackerFactory;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testTimeTrackerFactory");
            provider = null;
        }
        AmInstrumentationParser instrumentationParser2 = new AmInstrumentationParser(set, (Function0<? extends TestTimeTracker>)((Function0)new Function0<TestTimeTracker>(provider){

            public final TestTimeTracker invoke() {
                return (TestTimeTracker)((Provider)this.receiver).get();
            }
        }));
        List testIssues = new ArrayList();
        boolean markTestSuiteFailed = false;
        this.instrumentationHandle = AndroidDeviceControllerExtKt.asyncShell(deviceController, args, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this, instrumentationParser2){
            final /* synthetic */ AndroidInstrumentationDriver this$0;
            final /* synthetic */ AmInstrumentationParser $instrumentationParser;
            {
                this.this$0 = $receiver;
                this.$instrumentationParser = $instrumentationParser;
                super(1);
            }

            public final void invoke(@NotNull String line) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                LogWriter logWriter = AndroidInstrumentationDriver.access$getInstrumentationWriter$p(this.this$0);
                if (logWriter == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"instrumentationWriter");
                    logWriter = null;
                }
                logWriter.write(line);
                this.$instrumentationParser.parse(line);
            }
        }));
        try {
            int statusCode;
            CommandHandle commandHandle = this.instrumentationHandle;
            if (commandHandle == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"instrumentationHandle");
                commandHandle = null;
            }
            commandHandle.waitFor(timeout.plusSeconds(15L));
            CommandHandle commandHandle2 = this.instrumentationHandle;
            if (commandHandle2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"instrumentationHandle");
                commandHandle2 = null;
            }
            if ((statusCode = commandHandle2.exitCode()) != 0) {
                logger.warning(StringsKt.trimMargin$default((String)("\"Instrumentation command failed with non zero exit code:\n          |Instrumentation command: " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "\n          |StatusCode: " + statusCode), null, (int)1, null));
            }
        }
        catch (TimeoutException ex) {
            logger.log(Level.WARNING, "Instrumentation did not complete in the configured test timeout of " + timeout, ex);
            markTestSuiteFailed = true;
            testIssues.add(Issues.INSTRUMENTATION_TIMED_OUT.toIssue("The test did not complete in the configured timeout of " + timeout + " and was aborted."));
        }
        instrumentationParser2.done();
        InstrumentationResult instrumentationResult = instrumentationListener.getInstrumentationResult();
        String instrumentationFailureMessage = instrumentationListener.getInstrumentationFailureMessage();
        if (instrumentationFailureMessage != null) {
            markTestSuiteFailed = true;
            testIssues.add(Issues.INSTRUMENTATION_FAILED.toIssue(instrumentationFailureMessage));
        } else if (instrumentationResult == null || !instrumentationResult.getSuccess()) {
            markTestSuiteFailed = true;
            Object object = instrumentationResult;
            String bundleString2 = object != null && (object = ((InstrumentationResult)object).getBundle()) != null && (object = (Iterable)object.entrySet()) != null ? CollectionsKt.joinToString$default((Iterable)object, (CharSequence)"\n", null, null, (int)0, null, (Function1)runTestSuite.bundleString.1.INSTANCE, (int)30, null) : null;
            InstrumentationResult instrumentationResult2 = instrumentationResult;
            testIssues.add(Issues.INSTRUMENTATION_FAILED.toIssue(StringsKt.trimIndent((String)("\n            Instrumentation did not complete:\n            Instrumentation code: " + (instrumentationResult2 != null ? instrumentationResult2.getCode() : null) + "\n            Instrumentation result bundle: " + bundleString2 + "\n          "))));
        }
        TestSuiteResultProto.TestSuiteResult.Builder updatedSuiteResult = testResultPublisher.getTestSuiteResult().toBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)updatedSuiteResult, (String)"updatedSuiteResult");
        LogWriter logWriter = this.instrumentationWriter;
        if (logWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"instrumentationWriter");
            logWriter = null;
        }
        File file = logWriter.getLogPath();
        String string = this.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this::class.java.name");
        TestSuiteResultExtKt.addPlainTextArtifact(updatedSuiteResult, file, string);
        String string2 = this.coverageFilePath;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            String string3 = this.externalStoragePath;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"externalStoragePath");
                string3 = null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            Config config = this.config;
            if (config == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                config = null;
            }
            TestSuiteResultExtKt.addCoverageFileArtifact(updatedSuiteResult, it, string3, this.isTestServiceInstalled, stringBuilder.append(ConfigExtKt.getEnvironment((Config)config).getOutputDirectory()).append("/ondevicecoverage.ec").toString());
            List list = updatedSuiteResult.getOutputArtifactList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"updatedSuiteResult.outputArtifactList");
            Object object = CollectionsKt.last((List)list);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"updatedSuiteResult.outputArtifactList.last()");
            deviceController.pull((TestArtifactProto.Artifact)object);
        }
        if (markTestSuiteFailed && updatedSuiteResult.getTestStatus() == TestStatusProto.TestStatus.TEST_STATUS_UNSPECIFIED) {
            updatedSuiteResult.setTestStatus(TestStatusProto.TestStatus.FAILED);
        }
        updatedSuiteResult.addAllIssue((Iterable)testIssues);
        TestSuiteResultProto.TestSuiteResult testSuiteResult = updatedSuiteResult.build();
        Intrinsics.checkNotNullExpressionValue((Object)testSuiteResult, (String)"updatedSuiteResult.build()");
        testResultPublisher.setTestSuiteResult(testSuiteResult);
    }

    private final String onDeviceCoverageFile(String testPackage, boolean isTestServiceInstalled) {
        return isTestServiceInstalled ? testPackage + "_ondevicecoverage.ec" : "/data/data/" + testPackage + "/ondevicecoverage.ec";
    }

    public static final /* synthetic */ LogWriter access$getInstrumentationWriter$p(AndroidInstrumentationDriver $this) {
        return $this.instrumentationWriter;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/google/testing/platform/runtime/android/driver/AndroidInstrumentationDriver$InstrumentationListener;", "Lcom/google/testing/platform/lib/adb/command/instrument/AmInstrumentationListener;", "testResultPublisher", "Lcom/google/testing/platform/api/result/TestResultPublisher;", "(Lcom/google/testing/platform/api/result/TestResultPublisher;)V", "instrumentationFailureMessage", "", "getInstrumentationFailureMessage", "()Ljava/lang/String;", "setInstrumentationFailureMessage", "(Ljava/lang/String;)V", "instrumentationResult", "Lcom/google/testing/platform/lib/adb/command/instrument/InstrumentationResult;", "getInstrumentationResult", "()Lcom/google/testing/platform/lib/adb/command/instrument/InstrumentationResult;", "setInstrumentationResult", "(Lcom/google/testing/platform/lib/adb/command/instrument/InstrumentationResult;)V", "instrumentationEnded", "", "instrumentationFailed", "errorMessage", "instrumentationStarted", "testCount", "", "testEnded", "testResult", "Lcom/google/testing/platform/lib/adb/command/instrument/TestResult;", "testStarted", "testIdentifier", "Lcom/google/testing/platform/lib/adb/command/instrument/TestIdentifier;", "toTestCase", "Lcom/google/testing/platform/proto/api/core/TestCaseProto$TestCase;", "toTestResult", "Lcom/google/testing/platform/proto/api/core/TestResultProto$TestResult;", "java_com_google_testing_platform_runtime_android_driver-android_instrumentation_driver"})
    private static final class InstrumentationListener
    implements AmInstrumentationListener {
        @NotNull
        private final TestResultPublisher testResultPublisher;
        @Nullable
        private String instrumentationFailureMessage;
        @Nullable
        private InstrumentationResult instrumentationResult;

        public InstrumentationListener(@NotNull TestResultPublisher testResultPublisher) {
            Intrinsics.checkNotNullParameter((Object)testResultPublisher, (String)"testResultPublisher");
            this.testResultPublisher = testResultPublisher;
        }

        @Nullable
        public final String getInstrumentationFailureMessage() {
            return this.instrumentationFailureMessage;
        }

        public final void setInstrumentationFailureMessage(@Nullable String string) {
            this.instrumentationFailureMessage = string;
        }

        @Nullable
        public final InstrumentationResult getInstrumentationResult() {
            return this.instrumentationResult;
        }

        public final void setInstrumentationResult(@Nullable InstrumentationResult instrumentationResult) {
            this.instrumentationResult = instrumentationResult;
        }

        @Override
        public void instrumentationStarted(int testCount) {
            TestSuiteResultProto.TestSuiteMetaData.Builder builder;
            TestSuiteResultProto.TestSuiteMetaData.Builder $this$instrumentationStarted_u24lambda_u2d0 = builder = TestSuiteResultProto.TestSuiteMetaData.newBuilder();
            boolean bl = false;
            $this$instrumentationStarted_u24lambda_u2d0.setScheduledTestCaseCount(testCount);
            TestSuiteResultProto.TestSuiteMetaData testSuiteMetadata = builder.build();
            this.testResultPublisher.beforeTestSuite(testSuiteMetadata);
        }

        @Override
        public void testStarted(@NotNull TestIdentifier testIdentifier) {
            Intrinsics.checkNotNullParameter((Object)testIdentifier, (String)"testIdentifier");
            this.testResultPublisher.beforeTest(this.toTestCase(testIdentifier));
        }

        @Override
        public void testEnded(@NotNull TestResult testResult) {
            Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
            this.testResultPublisher.afterTest(this.toTestResult(testResult));
        }

        @Override
        public void instrumentationFailed(@NotNull String errorMessage) {
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            this.instrumentationFailureMessage = errorMessage;
        }

        @Override
        public void instrumentationEnded(@NotNull InstrumentationResult instrumentationResult) {
            Intrinsics.checkNotNullParameter((Object)instrumentationResult, (String)"instrumentationResult");
            this.instrumentationResult = instrumentationResult;
        }

        private final TestCaseProto.TestCase toTestCase(TestIdentifier testIdentifier) {
            TestCaseProto.TestCase.Builder builder;
            TestCaseProto.TestCase.Builder $this$toTestCase_u24lambda_u2d1 = builder = TestCaseProto.TestCase.newBuilder();
            boolean bl = false;
            $this$toTestCase_u24lambda_u2d1.setTestClass(testIdentifier.getTestClass());
            $this$toTestCase_u24lambda_u2d1.setTestPackage(testIdentifier.getTestPackage());
            $this$toTestCase_u24lambda_u2d1.setTestMethod(testIdentifier.getTestMethod());
            TestCaseProto.TestCase testCase = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)testCase, (String)"newBuilder()\n        .ap\u2026       }\n        .build()");
            return testCase;
        }

        private final TestResultProto.TestResult toTestResult(TestResult testResult) {
            TestResultProto.TestResult.Builder builder;
            TestResultProto.TestResult.Builder $this$toTestResult_u24lambda_u2d6 = builder = TestResultProto.TestResult.newBuilder();
            boolean bl = false;
            $this$toTestResult_u24lambda_u2d6.setTestStatus(testResult.getStatus());
            TestCaseProto.TestCase.Builder $this$forEach$iv = testResult.getStatusBundle();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                TestResultProto.TestResult.TestDetailsEntry.Builder builder2;
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl2 = false;
                String key = entry.getKey();
                String value = entry.getValue();
                TestResultProto.TestResult.TestDetailsEntry.Builder $this$toTestResult_u24lambda_u2d6_u24lambda_u2d3_u24lambda_u2d2 = builder2 = $this$toTestResult_u24lambda_u2d6.addDetailsBuilder();
                boolean bl3 = false;
                $this$toTestResult_u24lambda_u2d6_u24lambda_u2d3_u24lambda_u2d2.setKey(key);
                $this$toTestResult_u24lambda_u2d6_u24lambda_u2d3_u24lambda_u2d2.setValue(value);
            }
            TestCaseProto.TestCase.Builder $this$toTestResult_u24lambda_u2d6_u24lambda_u2d4 = $this$forEach$iv = $this$toTestResult_u24lambda_u2d6.getTestCaseBuilder();
            boolean bl4 = false;
            $this$toTestResult_u24lambda_u2d6_u24lambda_u2d4.setTestClass(testResult.getTestIdentifier().getTestClass());
            $this$toTestResult_u24lambda_u2d6_u24lambda_u2d4.setTestPackage(testResult.getTestIdentifier().getTestPackage());
            $this$toTestResult_u24lambda_u2d6_u24lambda_u2d4.setTestMethod(testResult.getTestIdentifier().getTestMethod());
            $this$toTestResult_u24lambda_u2d6_u24lambda_u2d4.setStartTime(Companion.toProtoTimestamp(testResult.getStartTime()));
            $this$toTestResult_u24lambda_u2d6_u24lambda_u2d4.setEndTime(Companion.toProtoTimestamp(testResult.getEndTime()));
            String stackTrace = testResult.getStackTrace();
            if (stackTrace != null) {
                ErrorProto.Error.Builder builder3;
                ErrorProto.Error.Builder $this$toTestResult_u24lambda_u2d6_u24lambda_u2d5 = builder3 = $this$toTestResult_u24lambda_u2d6.getErrorBuilder();
                boolean bl5 = false;
                $this$toTestResult_u24lambda_u2d6_u24lambda_u2d5.setErrorMessage(stackTrace);
                $this$toTestResult_u24lambda_u2d6_u24lambda_u2d5.setErrorType(StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)stackTrace, (String)"Caused by: ", null, (int)2, null), (String)":", null, (int)2, null));
                $this$toTestResult_u24lambda_u2d6_u24lambda_u2d5.setStackTrace(stackTrace);
            }
            TestResultProto.TestResult testResult2 = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)testResult2, (String)"newBuilder()\n        .ap\u2026       }\n        .build()");
            return testResult2;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lcom/google/testing/platform/runtime/android/driver/AndroidInstrumentationDriver$Issues;", "", "code", "", "severity", "Lcom/google/testing/platform/proto/api/core/IssueProto$Issue$Severity;", "(Ljava/lang/String;IILcom/google/testing/platform/proto/api/core/IssueProto$Issue$Severity;)V", "getCode", "()I", "getSeverity", "()Lcom/google/testing/platform/proto/api/core/IssueProto$Issue$Severity;", "toIssue", "Lcom/google/testing/platform/proto/api/core/IssueProto$Issue;", "issueMessage", "", "INSTRUMENTATION_FAILED", "INSTRUMENTATION_TIMED_OUT", "java_com_google_testing_platform_runtime_android_driver-android_instrumentation_driver"})
    private static final class Issues
    extends Enum<Issues> {
        private final int code;
        @NotNull
        private final IssueProto.Issue.Severity severity;
        public static final /* enum */ Issues INSTRUMENTATION_FAILED = new Issues(1, IssueProto.Issue.Severity.SEVERE);
        public static final /* enum */ Issues INSTRUMENTATION_TIMED_OUT = new Issues(2, IssueProto.Issue.Severity.SEVERE);
        private static final /* synthetic */ Issues[] $VALUES;

        private Issues(int code, IssueProto.Issue.Severity severity) {
            this.code = code;
            this.severity = severity;
        }

        public final int getCode() {
            return this.code;
        }

        @NotNull
        public final IssueProto.Issue.Severity getSeverity() {
            return this.severity;
        }

        @NotNull
        public final IssueProto.Issue toIssue(@NotNull String issueMessage) {
            Intrinsics.checkNotNullParameter((Object)issueMessage, (String)"issueMessage");
            IssueProto.Issue.Builder it = IssueProto.Issue.newBuilder();
            boolean bl = false;
            it.getNamespaceBuilder().setNamespace(AndroidInstrumentationDriver.class.getName());
            it.setSeverity(this.severity);
            it.setCode(this.code);
            it.setName(this.name());
            it.setMessage(issueMessage);
            IssueProto.Issue issue = it.build();
            Intrinsics.checkNotNullExpressionValue((Object)issue, (String)"newBuilder().let {\n     \u2026       it.build()\n      }");
            return issue;
        }

        public static Issues[] values() {
            return (Issues[])$VALUES.clone();
        }

        public static Issues valueOf(String value) {
            return Enum.valueOf(Issues.class, value);
        }

        static {
            $VALUES = issuesArray = new Issues[]{Issues.INSTRUMENTATION_FAILED, Issues.INSTRUMENTATION_TIMED_OUT};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bH\u0002J\f\u0010\u0010\u001a\u00020\r*\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u00020\n8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u00a8\u0006\u0012"}, d2={"Lcom/google/testing/platform/runtime/android/driver/AndroidInstrumentationDriver$Companion;", "", "()V", "COVERAGE_FILE_NAME", "", "DEFAULT_AM_INSTRUMENT_TIMEOUT_SEC", "", "NANOS_PER_SECOND", "", "logger", "Ljava/util/logging/Logger;", "getLogger$annotations", "normalizeTimestamp", "Lcom/google/protobuf/Timestamp;", "seconds", "nano", "toProtoTimestamp", "Ljava/time/Instant;", "java_com_google_testing_platform_runtime_android_driver-android_instrumentation_driver"})
    private static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        private final Timestamp toProtoTimestamp(Instant $this$toProtoTimestamp) {
            return this.normalizeTimestamp($this$toProtoTimestamp.getEpochSecond(), $this$toProtoTimestamp.getNano());
        }

        private final Timestamp normalizeTimestamp(long seconds, int nano) {
            long adjustedSeconds = seconds;
            int adjustedNanos = nano;
            if (adjustedNanos <= -1000000000 || adjustedNanos >= 1000000000) {
                adjustedSeconds = LongMath.checkedAdd((long)adjustedSeconds, (long)((long)adjustedNanos / (long)1000000000));
                adjustedNanos %= 1000000000;
            }
            if (adjustedNanos < 0) {
                adjustedNanos += 1000000000;
                adjustedSeconds = LongMath.checkedSubtract((long)adjustedSeconds, (long)1L);
            }
            Timestamp timestamp = Timestamp.newBuilder().setSeconds(adjustedSeconds).setNanos(adjustedNanos).build();
            Timestamp timestamp2 = Timestamps.checkValid((Timestamp)timestamp);
            Intrinsics.checkNotNullExpressionValue((Object)timestamp2, (String)"checkValid(timestamp)");
            return timestamp2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

