/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.lib.adb.command.parser;

import com.google.auto.value.AutoValue;
import com.google.testing.platform.lib.adb.command.parser.AutoValue_Instrumentation;

@AutoValue
public abstract class Instrumentation {
    private static Instrumentation create(Builder builder) {
        return new AutoValue_Instrumentation(builder.androidPackage, builder.targetPackage, builder.instrumentationClass);
    }

    Instrumentation() {
    }

    public abstract String getAndroidPackage();

    public abstract String getTargetPackage();

    public abstract String getInstrumentationClass();

    public String getFullName() {
        return this.getAndroidPackage() + "/" + this.getInstrumentationClass();
    }

    public String getFullInstrumentationClass() {
        if (this.getInstrumentationClass().startsWith(".")) {
            return this.getAndroidPackage() + this.getInstrumentationClass();
        }
        return this.getInstrumentationClass();
    }

    public String toString() {
        return this.getFullName();
    }

    public static class Builder {
        private String androidPackage;
        private String instrumentationClass;
        private String targetPackage;

        public Builder withAndroidPackage(String androidPackage) {
            this.androidPackage = androidPackage;
            return this;
        }

        public Builder withTargetPackage(String targetPackage) {
            this.targetPackage = targetPackage;
            return this;
        }

        public Builder withInstrumentationClass(String instrumentationClass) {
            this.instrumentationClass = instrumentationClass;
            return this;
        }

        public Instrumentation build() {
            return Instrumentation.create(this);
        }
    }
}

