/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.auto.common.MoreTypes;
import com.google.auto.value.AutoValue;
import com.google.common.base.CaseFormat;
import com.google.common.base.Equivalence;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.FormatMethod;
import com.google.testing.compile.AutoValue_TreeDiffer_MethodSignature;
import com.google.testing.compile.TreeDifference;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import javax.lang.model.element.Name;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileObject;
import org.checkerframework.checker.nullness.qual.Nullable;

final class TreeDiffer {
    private static final TreeVisitor<@Nullable Void, // Could not load outer class - annotation placement on inner may be incorrect
    ImmutableList.Builder<Name>> IMPORT_NAMES_ACCUMULATOR = new SimpleTreeVisitor<Void, ImmutableList.Builder<Name>>(){

        @Override
        public @Nullable Void visitMemberSelect(MemberSelectTree memberSelectTree, ImmutableList.Builder<Name> names) {
            names.add((Object)memberSelectTree.getIdentifier());
            return memberSelectTree.getExpression().accept(this, names);
        }

        @Override
        public @Nullable Void visitIdentifier(IdentifierTree identifierTree, ImmutableList.Builder<Name> names) {
            names.add((Object)identifierTree.getName());
            return null;
        }
    };

    private TreeDiffer() {
    }

    static TreeDifference diffCompilationUnits(CompilationUnitTree expected, CompilationUnitTree actual) {
        return TreeDiffer.createDiff((CompilationUnitTree)Preconditions.checkNotNull((Object)expected), (CompilationUnitTree)Preconditions.checkNotNull((Object)actual), TreeFilter.KEEP_ALL);
    }

    static TreeDifference matchCompilationUnits(CompilationUnitTree pattern, Trees patternTrees, CompilationUnitTree actual, Trees actualTrees) {
        Preconditions.checkNotNull((Object)pattern);
        Preconditions.checkNotNull((Object)actual);
        return TreeDiffer.createDiff(pattern, actual, new MatchExpectedTreesFilter(pattern, patternTrees, actual, actualTrees));
    }

    private static TreeDifference createDiff(@Nullable CompilationUnitTree expected, @Nullable CompilationUnitTree actual, TreeFilter treeFilter) {
        TreeDifference.Builder diffBuilder = new TreeDifference.Builder();
        DiffVisitor diffVisitor = new DiffVisitor(diffBuilder, treeFilter);
        diffVisitor.scan(expected, actual);
        return diffBuilder.build();
    }

    static TreeDifference diffSubtrees(TreePath pathToExpected, TreePath pathToActual) {
        TreeDifference.Builder diffBuilder = new TreeDifference.Builder();
        DiffVisitor diffVisitor = new DiffVisitor(diffBuilder, TreeFilter.KEEP_ALL, pathToExpected, pathToActual);
        diffVisitor.scan(pathToExpected.getLeaf(), pathToActual.getLeaf());
        return diffBuilder.build();
    }

    @AutoValue
    static abstract class MethodSignature {
        MethodSignature() {
        }

        abstract String name();

        abstract ImmutableList<Equivalence.Wrapper<TypeMirror>> parameterTypes();

        static MethodSignature create(CompilationUnitTree compilationUnitTree, MethodTree tree, Trees trees) {
            ImmutableList.Builder parameterTypes = ImmutableList.builder();
            for (VariableTree variableTree : tree.getParameters()) {
                parameterTypes.add((Object)MoreTypes.equivalence().wrap((Object)trees.getTypeMirror(trees.getPath(compilationUnitTree, variableTree))));
            }
            return new AutoValue_TreeDiffer_MethodSignature(tree.getName().toString(), (ImmutableList<Equivalence.Wrapper<TypeMirror>>)parameterTypes.build());
        }
    }

    private static class MatchExpectedTreesFilter
    implements TreeFilter {
        private final CompilationUnitTree pattern;
        private final Trees patternTrees;
        private final CompilationUnitTree actual;
        private final Trees actualTrees;

        MatchExpectedTreesFilter(CompilationUnitTree pattern, Trees patternTrees, CompilationUnitTree actual, Trees actualTrees) {
            this.pattern = pattern;
            this.patternTrees = patternTrees;
            this.actual = actual;
            this.actualTrees = actualTrees;
        }

        @Override
        public ImmutableList<Tree> filterActualMembers(ImmutableList<Tree> patternMembers, ImmutableList<Tree> actualMembers) {
            final HashSet patternVariableNames = new HashSet();
            final HashSet patternNestedTypeNames = new HashSet();
            final HashSet patternMethods = new HashSet();
            for (Tree patternTree : patternMembers) {
                patternTree.accept(new SimpleTreeVisitor<Void, Void>(){

                    @Override
                    public @Nullable Void visitVariable(VariableTree variable, @Nullable Void p) {
                        patternVariableNames.add(variable.getName().toString());
                        return null;
                    }

                    @Override
                    public @Nullable Void visitMethod(MethodTree method, @Nullable Void p) {
                        patternMethods.add(MethodSignature.create(pattern, method, patternTrees));
                        return null;
                    }

                    @Override
                    public @Nullable Void visitClass(ClassTree clazz, @Nullable Void p) {
                        patternNestedTypeNames.add(clazz.getSimpleName().toString());
                        return null;
                    }
                }, null);
            }
            final ImmutableList.Builder filteredActualTrees = ImmutableList.builder();
            for (final Tree actualTree : actualMembers) {
                actualTree.accept(new SimpleTreeVisitor<Void, Void>(){

                    @Override
                    public @Nullable Void visitVariable(VariableTree variable, @Nullable Void p) {
                        if (patternVariableNames.contains(variable.getName().toString())) {
                            filteredActualTrees.add((Object)actualTree);
                        }
                        return null;
                    }

                    @Override
                    public @Nullable Void visitMethod(MethodTree method, @Nullable Void p) {
                        if (patternMethods.contains(MethodSignature.create(actual, method, actualTrees))) {
                            filteredActualTrees.add((Object)method);
                        }
                        return null;
                    }

                    @Override
                    public @Nullable Void visitClass(ClassTree clazz, @Nullable Void p) {
                        if (patternNestedTypeNames.contains(clazz.getSimpleName().toString())) {
                            filteredActualTrees.add((Object)clazz);
                        }
                        return null;
                    }

                    @Override
                    protected @Nullable Void defaultAction(Tree tree, @Nullable Void p) {
                        filteredActualTrees.add((Object)tree);
                        return null;
                    }
                }, null);
            }
            return filteredActualTrees.build();
        }

        @Override
        public ImmutableList<ImportTree> filterImports(ImmutableList<ImportTree> patternImports, ImmutableList<ImportTree> actualImports) {
            ImmutableSet patternImportsAsStrings = (ImmutableSet)patternImports.stream().map(this::fullyQualifiedImport).collect(ImmutableSet.toImmutableSet());
            return (ImmutableList)actualImports.stream().filter(importTree -> patternImportsAsStrings.contains((Object)this.fullyQualifiedImport((ImportTree)importTree))).collect(ImmutableList.toImmutableList());
        }

        private String fullyQualifiedImport(ImportTree importTree) {
            ImmutableList.Builder names = ImmutableList.builder();
            importTree.getQualifiedIdentifier().accept(IMPORT_NAMES_ACCUMULATOR, names);
            return Joiner.on((char)'.').join((Iterable)names.build().reverse());
        }
    }

    private static interface TreeFilter {
        public static final TreeFilter KEEP_ALL = new TreeFilter(){

            @Override
            public ImmutableList<Tree> filterActualMembers(ImmutableList<Tree> expectedMembers, ImmutableList<Tree> actualMembers) {
                return actualMembers;
            }

            @Override
            public ImmutableList<ImportTree> filterImports(ImmutableList<ImportTree> expectedImports, ImmutableList<ImportTree> actualImports) {
                return actualImports;
            }
        };

        public ImmutableList<Tree> filterActualMembers(ImmutableList<Tree> var1, ImmutableList<Tree> var2);

        public ImmutableList<ImportTree> filterImports(ImmutableList<ImportTree> var1, ImmutableList<ImportTree> var2);
    }

    static final class DiffVisitor
    extends SimpleTreeVisitor<Void, Tree> {
        private @Nullable TreePath expectedPath;
        private @Nullable TreePath actualPath;
        private final TreeDifference.Builder diffBuilder;
        private final TreeFilter filter;

        DiffVisitor(TreeDifference.Builder diffBuilder, TreeFilter filter) {
            this(diffBuilder, filter, null, null);
        }

        private DiffVisitor(TreeDifference.Builder diffBuilder, TreeFilter filter, @Nullable TreePath pathToExpected, @Nullable TreePath pathToActual) {
            this.diffBuilder = diffBuilder;
            this.filter = filter;
            this.expectedPath = pathToExpected;
            this.actualPath = pathToActual;
        }

        public void addTypeMismatch(Tree expected, Tree actual) {
            this.diffBuilder.addDifferingNodes(this.expectedPathPlus(expected), this.actualPathPlus(actual), String.format("Expected node kind to be <%s> but was <%s>.", new Object[]{expected.getKind(), actual.getKind()}));
        }

        @FormatMethod
        private void reportDiff(String message, Object ... formatArgs) {
            this.diffBuilder.addDifferingNodes(Objects.requireNonNull(this.expectedPath), Objects.requireNonNull(this.actualPath), String.format(message, formatArgs));
        }

        private TreePath actualPathPlus(Tree actual) {
            Preconditions.checkNotNull((Object)actual, (Object)"Tried to push null actual tree onto path.");
            return new TreePath(this.actualPath, actual);
        }

        private TreePath expectedPathPlus(Tree expected) {
            Preconditions.checkNotNull((Object)expected, (Object)"Tried to push null expected tree onto path.");
            return new TreePath(this.expectedPath, expected);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private @Nullable Void pushPathAndAccept(Tree expected, Tree actual) {
            TreePath prevExpectedPath = this.expectedPath;
            TreePath prevActualPath = this.actualPath;
            this.expectedPath = this.expectedPathPlus(expected);
            this.actualPath = this.actualPathPlus(actual);
            try {
                Void void_ = expected.accept(this, actual);
                return void_;
            }
            finally {
                this.expectedPath = prevExpectedPath;
                this.actualPath = prevActualPath;
            }
        }

        private boolean namesEqual(@Nullable Name expected, @Nullable Name actual) {
            return expected == null ? actual == null : actual != null && expected.contentEquals(actual);
        }

        private void scan(@Nullable Tree expected, @Nullable Tree actual) {
            if (expected == null && actual != null) {
                this.diffBuilder.addExtraActualNode(this.actualPathPlus(actual));
            } else if (expected != null && actual == null) {
                this.diffBuilder.addExtraExpectedNode(this.expectedPathPlus(expected));
            } else if (actual != null && expected != null) {
                this.pushPathAndAccept(expected, actual);
            }
        }

        private void parallelScan(Iterable<? extends Tree> expecteds, Iterable<? extends Tree> actuals) {
            if (expecteds != null && actuals != null) {
                Iterator<? extends Tree> expectedsIterator = expecteds.iterator();
                Iterator<? extends Tree> actualsIterator = actuals.iterator();
                while (expectedsIterator.hasNext() && actualsIterator.hasNext()) {
                    this.pushPathAndAccept(expectedsIterator.next(), actualsIterator.next());
                }
                if (!expectedsIterator.hasNext() && actualsIterator.hasNext()) {
                    this.diffBuilder.addExtraActualNode(this.actualPathPlus(actualsIterator.next()));
                } else if (expectedsIterator.hasNext() && !actualsIterator.hasNext()) {
                    this.diffBuilder.addExtraExpectedNode(this.expectedPathPlus(expectedsIterator.next()));
                }
            } else if (expecteds == null && actuals != null && !Iterables.isEmpty(actuals)) {
                this.diffBuilder.addExtraActualNode(this.actualPathPlus(actuals.iterator().next()));
            } else if (actuals == null && expecteds != null && !Iterables.isEmpty(expecteds)) {
                this.diffBuilder.addExtraExpectedNode(this.expectedPathPlus(expecteds.iterator().next()));
            }
        }

        @Override
        public @Nullable Void defaultAction(Tree expected, Tree actual) {
            if (expected.getKind() != actual.getKind()) {
                this.addTypeMismatch(expected, actual);
                return null;
            }
            Class<? extends Tree> treeInterface = expected.getKind().asInterface();
            for (Method method : treeInterface.getMethods()) {
                Object actualValue;
                Object expectedValue;
                if (!method.getName().startsWith("get") || method.getParameterTypes().length != 0) continue;
                try {
                    expectedValue = method.invoke((Object)expected, new Object[0]);
                    actualValue = method.invoke((Object)actual, new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new VerifyException((Throwable)e);
                }
                this.defaultCompare(method, expected.getKind(), expectedValue, actualValue);
            }
            return null;
        }

        private void defaultCompare(Method method, Tree.Kind kind, Object expected, Object actual) {
            Type type = method.getGenericReturnType();
            if (DiffVisitor.isIterableOfTree(type)) {
                Iterable expectedList = (Iterable)expected;
                Iterable<? extends Tree> actualList = (Iterable<? extends Tree>)actual;
                actualList = this.filterActual(method, kind, expectedList, actualList);
                this.parallelScan(expectedList, actualList);
            } else if (type instanceof Class && Tree.class.isAssignableFrom((Class)type)) {
                this.scan((Tree)expected, (Tree)actual);
            } else {
                boolean eq;
                if (expected instanceof LineMap && actual instanceof LineMap) {
                    return;
                }
                if (expected instanceof JavaFileObject && actual instanceof JavaFileObject) {
                    return;
                }
                boolean bl = eq = expected instanceof Name ? this.namesEqual((Name)expected, (Name)actual) : Objects.equals(expected, actual);
                if (!eq) {
                    String treeKind = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, kind.name());
                    String property = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, method.getName().substring("get".length())).replace('_', ' ');
                    this.reportDiff("Expected %s %s to be <%s> but was <%s>.", treeKind, property, expected, actual);
                }
            }
        }

        private Iterable<? extends Tree> filterActual(Method method, Tree.Kind kind, Iterable<? extends Tree> expected, Iterable<? extends Tree> actual) {
            switch (kind) {
                case COMPILATION_UNIT: {
                    if (!method.getName().equals("getImports")) break;
                    Iterable<? extends Tree> expectedImports = expected;
                    Iterable<? extends Tree> actualImports = actual;
                    return this.filter.filterImports((ImmutableList<ImportTree>)ImmutableList.copyOf(expectedImports), (ImmutableList<ImportTree>)ImmutableList.copyOf(actualImports));
                }
                case CLASS: {
                    if (!method.getName().equals("getMembers")) break;
                    return this.filter.filterActualMembers((ImmutableList<Tree>)ImmutableList.copyOf(expected), (ImmutableList<Tree>)ImmutableList.copyOf(actual));
                }
            }
            return actual;
        }

        private static boolean isIterableOfTree(Type type) {
            if (!(type instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (!Iterable.class.isAssignableFrom((Class)parameterizedType.getRawType()) || parameterizedType.getActualTypeArguments().length != 1) {
                return false;
            }
            Type argType = parameterizedType.getActualTypeArguments()[0];
            if (argType instanceof Class) {
                return Tree.class.isAssignableFrom((Class)argType);
            }
            if (argType instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)argType;
                return wildcardType.getUpperBounds().length == 1 && wildcardType.getUpperBounds()[0] instanceof Class && Tree.class.isAssignableFrom((Class)wildcardType.getUpperBounds()[0]);
            }
            return false;
        }

        @Override
        public @Nullable Void visitOther(Tree expected, Tree actual) {
            throw new UnsupportedOperationException("cannot compare unknown trees");
        }
    }
}

