/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.shared.SoyIdRenamingMap;
import com.google.template.soy.soytree.AbstractCommandNode;
import com.google.template.soy.soytree.SoyNode;

public final class XidNode
extends AbstractCommandNode
implements SoyNode.StandaloneNode,
SoyNode.StatementNode {
    private static final SoyErrorKind INVALID_XID_VALUE = SoyErrorKind.of("Invalid xid value");
    private final String text;
    private volatile Pair<SoyIdRenamingMap, String> renameCache;

    public XidNode(int id, SourceLocation sourceLocation, String commandText) {
        super(id, sourceLocation, "xid", commandText);
        this.text = commandText;
    }

    private XidNode(XidNode orig, CopyState copyState) {
        super(orig, copyState);
        this.text = orig.text;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.XID_NODE;
    }

    public String getText() {
        return this.text;
    }

    public String getRenamedText(SoyIdRenamingMap idRenamingMap) {
        String mappedText;
        Pair<SoyIdRenamingMap, String> cache = this.renameCache;
        if (cache != null && cache.first == idRenamingMap) {
            return (String)cache.second;
        }
        if (idRenamingMap != null && (mappedText = idRenamingMap.get(this.text)) != null) {
            this.renameCache = Pair.of(idRenamingMap, mappedText);
            return mappedText;
        }
        return this.text + "_";
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public XidNode copy(CopyState copyState) {
        return new XidNode(this, copyState);
    }

    public static final class Builder {
        public static final XidNode ERROR = new XidNode(-1, SourceLocation.UNKNOWN, "error");
        private final int id;
        private final String commandText;
        private final SourceLocation sourceLocation;

        public Builder(int id, String commandText, SourceLocation sourceLocation) {
            this.id = id;
            this.commandText = commandText;
            this.sourceLocation = sourceLocation;
        }

        public XidNode build(ErrorReporter errorReporter) {
            ErrorReporter.Checkpoint checkpoint = errorReporter.checkpoint();
            if (!BaseUtils.isDottedOrDashedIdent(this.commandText)) {
                errorReporter.report(this.sourceLocation, INVALID_XID_VALUE, new Object[0]);
            }
            if (errorReporter.errorsSince(checkpoint)) {
                return ERROR;
            }
            XidNode node = new XidNode(this.id, this.sourceLocation, this.commandText);
            return node;
        }
    }
}

