/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.LegacyInternalSyntaxException;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class TemplateBasicNodeBuilder
extends TemplateNodeBuilder {
    private static final SoyErrorKind FULLY_QUALIFIED_NAME = SoyErrorKind.of("Soy V2 template names must be relative to the file namespace, i.e. a dot followed by an identifier.  Templates with fully qualified names are only allowed in legacy templates marked with the deprecatedV1=\"true\" attribute.");
    private static final SoyErrorKind MISSING_TEMPLATE_NAME = SoyErrorKind.of("Missing template name.");
    private static final SoyErrorKind PRIVATE_AND_VISIBILITY = SoyErrorKind.of("Cannot specify both private=\"true\" and visibility=\"{0}\".");
    private static final Pattern TEMPLATE_NAME = Pattern.compile("^\\s*([.\\w]+)(?=\\s|$)", 32);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("template", new CommandTextAttributesParser.Attribute("private", CommandTextAttributesParser.Attribute.BOOLEAN_VALUES, "false"), new CommandTextAttributesParser.Attribute("autoescape", AutoescapeMode.getAttributeValues(), null), new CommandTextAttributesParser.Attribute("kind", NodeContentKinds.getAttributeValues(), null), new CommandTextAttributesParser.Attribute("requirecss", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("cssbase", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("visibility", Visibility.getAttributeValues(), null), new CommandTextAttributesParser.Attribute("deprecatedV1", CommandTextAttributesParser.Attribute.BOOLEAN_VALUES, "false"));

    public TemplateBasicNodeBuilder(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, SourceLocation sourceLocation, ErrorReporter errorReporter) {
        super(soyFileHeaderInfo, sourceLocation, errorReporter, null);
    }

    public TemplateBasicNodeBuilder(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, SourceLocation sourceLocation, ErrorReporter errorReporter, SoyTypeRegistry typeRegistry) {
        super(soyFileHeaderInfo, sourceLocation, errorReporter, typeRegistry);
    }

    @Override
    public TemplateBasicNodeBuilder setId(int id) {
        return (TemplateBasicNodeBuilder)super.setId(id);
    }

    @Override
    public TemplateBasicNodeBuilder setCmdText(String cmdText) {
        String visibilityName;
        Preconditions.checkState((this.cmdText == null ? 1 : 0) != 0);
        this.cmdText = cmdText;
        String commandTextForParsing = cmdText;
        Matcher ntnMatcher = TEMPLATE_NAME.matcher(commandTextForParsing);
        if (!ntnMatcher.find()) {
            this.errorReporter.report(this.sourceLocation, MISSING_TEMPLATE_NAME, new Object[0]);
            return this;
        }
        String nameAttr = ntnMatcher.group(1);
        commandTextForParsing = commandTextForParsing.substring(ntnMatcher.end()).trim();
        Map<String, String> attributes = ATTRIBUTES_PARSER.parse(commandTextForParsing, this.errorReporter, this.sourceLocation);
        if (attributes.get("private").equals("true")) {
            this.visibility = Visibility.LEGACY_PRIVATE;
        }
        if ((visibilityName = attributes.get("visibility")) != null) {
            if (this.visibility != null) {
                this.errorReporter.report(this.sourceLocation, PRIVATE_AND_VISIBILITY, visibilityName);
            }
            this.visibility = Visibility.forAttributeValue(visibilityName);
        }
        if (this.visibility == null) {
            this.visibility = Visibility.PUBLIC;
        }
        this.setAutoescapeCmdText(attributes);
        this.setRequireCssCmdText(attributes);
        this.setCssBaseCmdText(attributes);
        this.setV1Marker(attributes);
        if (BaseUtils.isIdentifierWithLeadingDot(nameAttr)) {
            if (this.soyFileHeaderInfo.namespace == null) {
                throw LegacyInternalSyntaxException.createWithMetaInfo("Template has namespace-relative name, but file has no namespace declaration.", this.sourceLocation);
            }
            this.setTemplateNames(this.soyFileHeaderInfo.namespace + nameAttr, nameAttr);
        } else {
            if (!this.isMarkedV1 && BaseUtils.isDottedIdentifier(nameAttr)) {
                this.errorReporter.report(this.sourceLocation, FULLY_QUALIFIED_NAME, new Object[0]);
            }
            this.setTemplateNames(nameAttr, null);
        }
        this.templateNameForUserMsgs = this.getTemplateName();
        return this;
    }

    public TemplateBasicNodeBuilder setCmdTextInfo(String templateName, @Nullable String partialTemplateName, Visibility visibility, AutoescapeMode autoescapeMode, SanitizedContent.ContentKind contentKind, ImmutableList<String> requiredCssNamespaces) {
        Preconditions.checkState((this.cmdText == null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(templateName));
        Preconditions.checkArgument((partialTemplateName == null || BaseUtils.isIdentifierWithLeadingDot(partialTemplateName) ? 1 : 0) != 0);
        Preconditions.checkArgument((contentKind != null == (autoescapeMode == AutoescapeMode.STRICT) ? 1 : 0) != 0);
        this.setTemplateNames(templateName, partialTemplateName);
        this.templateNameForUserMsgs = templateName;
        this.visibility = visibility;
        this.setAutoescapeInfo(autoescapeMode, contentKind);
        this.setRequiredCssNamespaces(requiredCssNamespaces);
        StringBuilder cmdTextBuilder = new StringBuilder();
        cmdTextBuilder.append(partialTemplateName != null ? partialTemplateName : templateName);
        cmdTextBuilder.append(" autoescape=\"").append(autoescapeMode.getAttributeValue()).append('\"');
        if (contentKind != null) {
            cmdTextBuilder.append(" kind=\"").append(NodeContentKinds.toAttributeValue(contentKind)).append('\"');
        }
        if (visibility == Visibility.LEGACY_PRIVATE) {
            cmdTextBuilder.append(" private=\"true\"");
        }
        if (!requiredCssNamespaces.isEmpty()) {
            cmdTextBuilder.append(" requirecss=\"").append(Joiner.on((String)", ").join(requiredCssNamespaces)).append("\"");
        }
        this.cmdText = cmdTextBuilder.toString();
        return this;
    }

    @Override
    public TemplateBasicNodeBuilder setSoyDoc(String soyDoc) {
        return (TemplateBasicNodeBuilder)super.setSoyDoc(soyDoc);
    }

    @Override
    public TemplateBasicNodeBuilder setHeaderDecls(TemplateNodeBuilder.DeclInfo ... declInfos) {
        return (TemplateBasicNodeBuilder)super.setHeaderDecls(declInfos);
    }

    @Override
    public TemplateBasicNodeBuilder addParams(Iterable<? extends TemplateParam> allParams) {
        return (TemplateBasicNodeBuilder)super.addParams(allParams);
    }

    @Override
    public TemplateBasicNode build() {
        Preconditions.checkState((this.id != null && this.cmdText != null ? 1 : 0) != 0);
        return new TemplateBasicNode(this, this.soyFileHeaderInfo, this.visibility, (ImmutableList<TemplateParam>)this.params);
    }
}

