/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.SoyNode;

public final class MsgFallbackGroupNode
extends AbstractParentSoyNode<MsgNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<MsgNode>,
SoyNode.StatementNode {
    private ImmutableList<String> escapingDirectiveNames = ImmutableList.of();

    public MsgFallbackGroupNode(int id, SourceLocation sourceLocation) {
        super(id, sourceLocation);
    }

    private MsgFallbackGroupNode(MsgFallbackGroupNode orig, CopyState copyState) {
        super(orig, copyState);
        this.escapingDirectiveNames = orig.escapingDirectiveNames;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_FALLBACK_GROUP_NODE;
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        this.appendSourceStringForChildren(sb);
        sb.append("{/msg}");
        return sb.toString();
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    public boolean hasFallbackMsg() {
        return this.numChildren() > 1;
    }

    public MsgNode getMsg() {
        return (MsgNode)this.getChild(0);
    }

    public MsgNode getFallbackMsg() {
        Preconditions.checkState((boolean)this.hasFallbackMsg(), (Object)"This node doesn't have a {fallbackmsg}");
        return (MsgNode)this.getChild(1);
    }

    @Override
    public MsgFallbackGroupNode copy(CopyState copyState) {
        return new MsgFallbackGroupNode(this, copyState);
    }

    public void setEscapingDirectiveNames(ImmutableList<String> escapingDirectiveNames) {
        this.escapingDirectiveNames = escapingDirectiveNames;
    }

    public ImmutableList<String> getEscapingDirectiveNames() {
        return this.escapingDirectiveNames;
    }
}

