/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.LegacyInternalSyntaxException;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soyparse.ParseErrors;
import com.google.template.soy.soyparse.ParseException;
import com.google.template.soy.soyparse.SimpleCharStream;
import com.google.template.soy.soyparse.SoyFileParserConstants;
import com.google.template.soy.soyparse.SoyFileParserTokenManager;
import com.google.template.soy.soyparse.TemplateParseResult;
import com.google.template.soy.soyparse.TemplateParser;
import com.google.template.soy.soyparse.Token;
import com.google.template.soy.soyparse.TokenMgrError;
import com.google.template.soy.soyparse.Tokens;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.NameAttributePair;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateBasicNodeBuilder;
import com.google.template.soy.soytree.TemplateDelegateNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.types.SoyTypeRegistry;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SoyFileParser
implements SoyFileParserConstants {
    private static final Pattern ERROR_MSG_LINE_NUM_PAT = Pattern.compile("(?<=line )\\d+(?=, column )");
    private static final SoyErrorKind UNCATEGORIZED = SoyErrorKind.of("In file {0}, template {1}: {2}");
    private SoyTypeRegistry typeRegistry;
    private IdGenerator nodeIdGen;
    private SoyFileKind soyFileKind;
    private String filePath;
    private ErrorReporter errorReporter;
    public SoyFileParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[8];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public SoyFileParser(SoyTypeRegistry typeRegistry, IdGenerator nodeIdGen, Reader input, SoyFileKind soyFileKind, String filePath, ErrorReporter errorReporter) {
        this(input);
        Preconditions.checkNotNull((Object)typeRegistry);
        Preconditions.checkNotNull((Object)nodeIdGen);
        this.typeRegistry = typeRegistry;
        this.nodeIdGen = nodeIdGen;
        this.soyFileKind = soyFileKind;
        this.filePath = filePath;
        this.errorReporter = errorReporter;
    }

    public SoyFileNode parseSoyFile() {
        Preconditions.checkNotNull((Object)this.typeRegistry);
        Preconditions.checkNotNull((Object)this.nodeIdGen);
        ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
        SoyFileNode soyFileNode = null;
        try {
            soyFileNode = this.SoyFile();
        }
        catch (ParseException e) {
            ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, e);
        }
        catch (LegacyInternalSyntaxException e) {
            ParseErrors.report(this.errorReporter, this.filePath, e);
        }
        catch (TokenMgrError e) {
            ParseErrors.report(this.errorReporter, this.filePath, e);
        }
        if (this.errorReporter.errorsSince(checkpoint)) {
            return null;
        }
        return soyFileNode;
    }

    @VisibleForTesting
    static String adjustLineNumInErrorMsg(String errorMsg, int templateTagLineNum) {
        Matcher matcher = ERROR_MSG_LINE_NUM_PAT.matcher(errorMsg);
        if (!matcher.find()) {
            return errorMsg;
        }
        int newLineNum = templateTagLineNum + Integer.parseInt(matcher.group());
        return errorMsg.substring(0, matcher.start()) + newLineNum + errorMsg.substring(matcher.end());
    }

    private SourceLocation createSrcLoc(Token tok1, Token ... rest) {
        return Tokens.createSrcLoc(this.filePath, tok1, rest);
    }

    private final SoyFileNode SoyFile() throws ParseException {
        String delpackageName = null;
        NamespaceDeclaration namespace = NamespaceDeclaration.NULL;
        ArrayList<TemplateNode> templates = new ArrayList<TemplateNode>();
        ArrayList<AliasDeclaration> aliases = new ArrayList<AliasDeclaration>();
        AliasDeclaration alias = null;
        int id = this.nodeIdGen.genId();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                delpackageName = this.DelPackage();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                namespace = this.Namespace();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block12;
                }
            }
            alias = this.Alias();
            aliases.add(alias);
        }
        TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo = new TemplateNode.SoyFileHeaderInfo(delpackageName, namespace);
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: 
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block13;
                }
            }
            TemplateNode template = this.Template(soyFileHeaderInfo);
            templates.add(template);
        }
        this.jj_consume_token(0);
        SoyFileNode sfn = new SoyFileNode(id, this.filePath, this.soyFileKind, this.errorReporter, delpackageName, namespace, aliases);
        sfn.addChildren(templates);
        return sfn;
    }

    private final AliasDeclaration Alias() throws ParseException {
        Token alias = null;
        Token as = null;
        Token open = this.jj_consume_token(12);
        Token namespace = this.jj_consume_token(21);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                as = this.jj_consume_token(11);
                alias = this.jj_consume_token(21);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        Token close = this.jj_consume_token(9);
        return alias == null ? new AliasDeclaration(namespace.image, this.errorReporter, this.createSrcLoc(open, namespace, close)) : new AliasDeclaration(namespace.image, alias.image, this.errorReporter, this.createSrcLoc(open, namespace, as, alias, close));
    }

    private final NamespaceDeclaration Namespace() throws ParseException {
        ArrayList<NameAttributePair> attributes = new ArrayList<NameAttributePair>();
        Token open = this.jj_consume_token(14);
        Token name = this.jj_consume_token(21);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: 
                case 15: 
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block3;
                }
            }
            NameAttributePair attr = this.Attribute();
            attributes.add(attr);
        }
        Token close = this.jj_consume_token(9);
        return new NamespaceDeclaration(name.image, attributes, this.errorReporter);
    }

    private final NameAttributePair Attribute() throws ParseException {
        Token name;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                name = this.jj_consume_token(15);
                break;
            }
            case 16: {
                name = this.jj_consume_token(16);
                break;
            }
            case 13: {
                name = this.jj_consume_token(13);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Token eq = this.jj_consume_token(10);
        Token value = this.jj_consume_token(18);
        return new NameAttributePair(name.image, value.image.substring(1, value.image.length() - 1), this.createSrcLoc(name, eq, value));
    }

    private final String DelPackage() throws ParseException {
        this.jj_consume_token(17);
        Token name = this.jj_consume_token(21);
        this.jj_consume_token(9);
        return name.image;
    }

    private final TemplateNode Template(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo) throws ParseException {
        boolean isBasicTemplate;
        Token templateContent;
        Token open;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: {
                open = this.jj_consume_token(24);
                templateContent = this.jj_consume_token(26);
                isBasicTemplate = true;
                break;
            }
            case 23: {
                open = this.jj_consume_token(23);
                templateContent = this.jj_consume_token(27);
                isBasicTemplate = false;
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        SourceLocation srcLocation = this.createSrcLoc(open, templateContent);
        TemplateNodeBuilder templateNodeBuilder = isBasicTemplate ? new TemplateBasicNodeBuilder(soyFileHeaderInfo, srcLocation, this.errorReporter, this.typeRegistry) : new TemplateDelegateNodeBuilder(soyFileHeaderInfo, srcLocation, this.errorReporter, this.typeRegistry);
        templateNodeBuilder.setId(this.nodeIdGen.genId());
        String cmdText = open.image.substring(isBasicTemplate ? 10 : 13, open.image.length() - 1);
        templateNodeBuilder.setCmdText(cmdText);
        Token soyDoc = open.specialToken;
        if (soyDoc != null && soyDoc.kind == 30) {
            templateNodeBuilder.setSoyDoc(soyDoc.image);
        } else {
            templateNodeBuilder.setSoyDoc(null);
        }
        List<TemplateNodeBuilder.DeclInfo> templateHeaderDecls = null;
        List<SoyNode.StandaloneNode> templateBodyNodes = null;
        String templateBodyContent = templateContent.image.substring(0, templateContent.image.lastIndexOf("{"));
        try {
            TemplateParseResult result = new TemplateParser(this.nodeIdGen, templateBodyContent, this.filePath, templateContent.beginLine, templateContent.beginColumn, this.errorReporter).parseTemplateContent();
            templateHeaderDecls = result.getHeaderDecls();
            templateBodyNodes = result.getBodyNodes();
        }
        catch (TokenMgrError tme) {
            String adjustedErrorMsg = SoyFileParser.adjustLineNumInErrorMsg(tme.getMessage(), open.beginLine);
            this.errorReporter.report(SourceLocation.UNKNOWN, UNCATEGORIZED, this.filePath, templateNodeBuilder.getTemplateNameForUserMsgs(), adjustedErrorMsg);
        }
        catch (ParseException pe) {
            String adjustedErrorMsg = SoyFileParser.adjustLineNumInErrorMsg(pe.getMessage(), open.beginLine);
            this.errorReporter.report(SourceLocation.UNKNOWN, UNCATEGORIZED, this.filePath, templateNodeBuilder.getTemplateNameForUserMsgs(), adjustedErrorMsg);
        }
        catch (LegacyInternalSyntaxException sse) {
            this.errorReporter.report(SourceLocation.UNKNOWN, UNCATEGORIZED, this.filePath, templateNodeBuilder.getTemplateNameForUserMsgs(), sse.getMessage());
        }
        if (templateHeaderDecls != null) {
            templateNodeBuilder.setHeaderDecls(templateHeaderDecls);
        }
        TemplateNode templateNode = templateNodeBuilder.build();
        if (templateBodyNodes != null) {
            templateNode.addChildren(templateBodyNodes);
        }
        return templateNode;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{131072, 16384, 4096, 0x1800000, 2048, 106496, 106496, 0x1800000};
    }

    public SoyFileParser(InputStream stream) {
        this(stream, null);
    }

    public SoyFileParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SoyFileParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SoyFileParser(SoyFileParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(SoyFileParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[32];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 8; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 32; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        SoyFileParser.jj_la1_init_0();
    }
}

